<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;

$i = $k = $s = 1;
$settings = $this->get_settings();

$settings['show_no_tv_show'] = $settings['show_no_tv_show'] == 0 ? 10 : $settings['show_no_tv_show'];
$lazy_load	= $settings['enable_lazy_load_images'] == "yes" ? "iqonic-lazy-load-images" : "";

$args = array(
	'post_type'         => 'tv_show',
	'fields'            => 'ids',
	'post_status'       => 'publish',
	'posts_per_page'    => $settings['show_no_tv_show'],
);

$default = $settings['post_filter'] == "default" ? true : false;

if (!$default) {
	$posts 		= $settings['tabs'];
	$post_in 	= array_column($settings['tabs'], "tvshow_id");
	$post__in = [];
	$post_name_in = [];
	foreach($post_in as $post){
		if(is_numeric($post))
			$post__in[]=$post;
		else
			$post_name_in[]=$post;
	}

	if (isset($post_in[0]) && !empty($post_in[0])) {
		if(!empty($post__in)){
			$args['post__in'] 	= $post__in;
		}
		if(!empty($post_name_in)){
			$args['post_name__in'] 	= $post_name_in;
		}
		$args['orderby'] 		= 'post_name__in';
	}
} else {
	$args['meta_key'] = 'tv_show_views_count';
	$args['orderby']  = 'meta_value_num';
	$args['order']    = 'DESC';
}

$posts = get_posts($args);

$this->add_render_attribute('slider', 'data-infinite', 	$settings['infinite']);
$this->add_render_attribute('slider', 'data-speed', 	$settings['speed']);
$this->add_render_attribute('slider', 'data-nav', 		$settings['nav-arrow']);
$this->add_render_attribute('slider', 'class', 			'tvshow_tab_new_slider');
?>

<div id="iq-trending" class="s-margin iq-tvshow-tabs iq-rtl-direction iq-trending-tabs <?php echo esc_attr($lazy_load) ?>">
	<div class="streamit-tvshow-tab-new">
		<div <?php echo $this->get_render_attribute_string('slider'); ?>>
			<?php foreach ($posts as $index => $post) {
				$year 			= get_the_date('M Y');
				$season_data 	= get_post_meta($post, '_seasons', true);

				$img_class = $srcset 	= '';

				if (has_post_thumbnail($post)) {
					$full_image = wp_get_attachment_image_src(get_post_thumbnail_id($post), "full");
					$full_image = $full_image[0];

					if (!empty($lazy_load)) {
						$img_class = ' iqonic-lazy';
						$lazy_image = get_lazy_load_image();

						$original_image = $full_image;
						$full_image 	= $lazy_image;
						$srcset 		= "data-srcset=" . $original_image . "";
					}
				} else {
					$full_image = get_lazy_load_image();
				} ?>

				<li data-post="<?php echo esc_attr($post); ?>">
					<div class="streamit-thumb-items streamit-tvshow tvshow-<?php echo esc_attr($post); ?> <?php echo esc_attr($img_class); ?>" style="background:url('<?php echo esc_attr($full_image) ?>')" <?php echo esc_attr($srcset); ?>>
						<div class="thumbnail-list-wrapper">
							<div class="streamit-tvshow-details">

								<?php if (!empty($settings['trending_top_img']['url'])) {
									if (!empty($settings['trending_top_img']['alt']))
										$alt = esc_attr($settings['trending_top_img']['alt']);
									else
										$alt = esc_attr__('image', 'streamit-extensions'); ?>
									<div class="series mb-3 RightAnimate">
										<img src="<?php echo esc_url($settings['trending_top_img']['url']) ?>" class="img-fluid" alt="<?php echo esc_attr($alt); ?>">
									<?php } ?>
									<span class="text-gold ml-3">
										<?php echo sprintf(esc_html__('#%1d in Series Today', SE_TEXT_DOMAIN), $i); ?>
									</span>
									</div>

									<h2 class="season-name big-title RightAnimate-two">
										<a href="<?php echo get_the_permalink($post) ?>">
											<?php echo get_the_title($post); ?>
										</a>
									</h2>

									<div class="season-excerpt mb-3 RightAnimate-three">
										<?php echo get_the_excerpt($post);  ?>
									</div>

									<div class="text-detail RightAnimate-four">
										<span class="trending-year"><?php echo esc_html($year); ?></span>

										<span class="season_date">
											<?php if (is_array($season_data)) {
												$season_count = count($season_data);
												echo $season_count . _n(" Season", " Seasons", $season_count, SE_TEXT_DOMAIN);
											} else {
												echo esc_html__("Arriving soon", SE_TEXT_DOMAIN);
											} ?>
										</span>
									</div>

									<div class="iq-btn-container RightAnimate-four">
										<a class="iq-button btn btn-hover btn-hover has-icon btn-icon-right" href="<?php echo get_the_permalink($post) ?>">
											<span>
												<?php echo esc_attr($settings['play_now_text']) ?>
												<i aria-hidden="true" class="fas fa-play"></i>
											</span>
										</a>
									</div>
							</div>
						</div>
					</div>
				</li>
			<?php
				$i++;
				unset($post);
			}
			wp_reset_postdata(); ?>
		</div>

		<div class="streamit-wrap-details">
			<?php if (!empty($season_data)) { ?>
				<div class="episodes-tab">
					<div class="trending-info align-items-center w-100 animated fadeIn">
						<div class="all-episodes">
							<h5 class="trending-text mb-2"> <?php echo esc_html__("All Episodes", 'streamit-extensions'); ?> </h5>
						</div>

						<div class="nav nav-tabs">
							<div class="nav-tabs-inner">
								<?php $season_data = get_post_meta($posts[0], '_seasons', true);
								foreach ($season_data as $index => $val) { ?>
									<a class="nav-item nav-link streamit-episodes-meta tvshow-<?php echo esc_attr($posts[0]); ?>" data-tvshow-id="<?php echo esc_attr($posts[0]); ?>" data-season="<?php echo $index ?>" data-ajax_loaded="false">
										<?php echo esc_html($val['name']); ?>
									</a>
								<?php
									$s++;
								} ?>
							</div>
						</div>

						<div class="season-content">
							<?php foreach ($season_data as $episode) { ?>
								<div class="season-episodes-details">
									<?php $episodes = $episode['episodes'];
									$episode_count = 0;
									foreach ($episodes as $post) {
										$_episode_run_time = get_post_meta($post, '_episode_run_time');
										$_thumbnail_id = get_post_meta($post, '_thumbnail_id');

										$url = isset($_thumbnail_id[0]) ? wp_get_attachment_image_src($_thumbnail_id[0])[0] : '';
										$episode_run_time = isset($_episode_run_time[0]) ? $_episode_run_time[0] : ''; ?>

										<div class="episodes-info episode-<?php echo esc_attr($post); ?> tvshow-<?php echo esc_attr($posts[0]); ?>-season-<?php echo esc_attr($k); ?>">
											<div class="episode-img">
												<img src="<?php echo esc_attr($url); ?>" alt="episode-img">
											</div>

											<div class="episodes-meta">
												<div class="episode-name">
													<a href="<?php echo get_the_permalink($post); ?>">
														<?php echo get_the_title($post); ?>
													</a>
												</div>

												<div class="episode-time mt-2">
													<?php echo esc_html($episode_run_time); ?>
												</div>
											</div>
										</div>
										<?php // To show only 5 episodes 
										if ($episode_count == 4) { ?>
											<div class="view-all-btn episodes-info tvshow-<?php echo esc_attr($posts[0]); ?>-season-<?php echo esc_attr($k); ?>">
												<div class="p-btns align-items-center justify-content-center" data-episode_card_text="<?php echo esc_attr($settings['episode_card_text']); ?>">
													<a href="<?php echo get_the_permalink($posts[0]) ?>" class="season-btn">
														<?php echo esc_html($settings['episode_card_text']); ?>
													</a>
												</div>
											</div>
									<?php
											break;
										} else {
											$episode_count++;
										}
									} ?>
								</div>
							<?php
								$k++;
								break;
							} ?>
						</div>
					</div>
				</div>
			<?php } ?>
		</div>
	</div>
</div>