<?php

namespace Iqonic\Elementor\Elements\TvShow_Season;

use Elementor\Plugin;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit;

class Widget extends Widget_Base
{
	public function get_name()
	{
		return 'iq_tvshow_season';
	}

	public function get_title()
	{
		return esc_html__('TvShow Season', 'streamit-extensions');
	}

	public function get_categories()
	{
		return ['streamit-extension'];
	}

	public function get_icon()
	{
		return 'eicon-slider-push';
	}

	protected function register_controls()
	{
		$this->start_controls_section(
			'section_Team',
			[
				'label' => __('TvShow Banner', 'streamit-extensions'),
			]
		);

		$this->add_control(
			'post_filter',
			[
				'label' => __('Posts Filter', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT,
				'label_block' => true,
				'multiple' => false,
				'options' => [
					'selected' 	=> __('Selected', 'streamit-extensions'),
					'default' 	=> __('Default', 'streamit-extensions')
				],
				'default' => 'default'
			]
		);

		$this->add_control(
			'enable_lazy_load_images',
			[
				'label' => __('Lazy Load Images', 'streamit-extensions'),
				'type' => Controls_Manager::SWITCHER,
				'yes' 			=> __('Yes', 'streamit-extensions'),
				'no' 			=> __('No', 'streamit-extensions'),
				'return_value' 	=> 'yes',
				'default' 		=> 'no',
			]
		);

		$repeater = new Repeater();
		$repeater->add_control(
			'tvshow_id',
			[
				'label' 		=> __('Select Tv Show', 'streamit-extensions'),
				'type' 			=> Controls_Manager::SELECT,
				'label_block' 	=> true,
				'options' 		=> isset($_REQUEST['editor_post_id']) ? iq_custom_post_data('tv_show', true) : [],
			]
		);

		$this->add_control(
			'tabs',
			[
				'label' 	=> __('Select Tv Shows Manually', 'streamit-extensions'),
				'type' 		=> Controls_Manager::REPEATER,
				'fields' 	=> $repeater->get_controls(),
				'condition' => ['post_filter' => 'selected']
			]
		);

		$this->add_control(
			'trending_top_img',
			[
				'label' => __('Trending Order Image', 'streamit-extensions'),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => STREAMIT_EXTENSION_PLUGIN_URL . '/includes/Elementor/assets/img/placeholder.jpg',
				],
			]
		);

		$this->add_control(
			'play_now_text',
			[
				'label' => __('Play Now Text', 'streamit-extensions'),
				'type' => Controls_Manager::TEXT,
				'default' => __('Stream Now', 'streamit-extensions'),
				'label_block' => true,
			]
		);

		$this->add_control(
			'episode_card_text',
			[
				'label' => __('Episode Card Text', 'streamit-extensions'),
				'type' => Controls_Manager::TEXT,
				'default' => __('More', 'streamit-extensions'),
				'label_block' => true,
			]
		);

		$this->add_control(
			'title_text',
			[
				'label' => __('Trending', 'streamit-extensions'),
				'type' => Controls_Manager::TEXT,
				'default' => __('Trending', 'streamit-extensions'),
				'label_block' => true,
				'condition' => ['show_title' => ['yes']]
			]
		);

		$this->add_control(
			'show_no_tv_show',
			[
				'label' => __('Show Number Of Tv Show ', 'streamit-extensions'),
				'type' => Controls_Manager::NUMBER,
				'default' => __('6', 'streamit-extensions'),
				'min' => __('-1', 'streamit-extensions'),
				'max' => wp_count_posts('tv_show')->publish,
				'condition' => ['post_filter' => 'default']
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'slick_control_section',
			[
				'label' => __('Slider Control', 'streamit-extensions'),
			]
		);

		$this->add_control(
			'infinite',
			[
				'label' => __('Infinite', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT,
				'default' => 'true',
				'options' => [
					'true' => __('True', 'streamit-extensions'),
					'false' => __('False', 'streamit-extensions'),
				],
			]
		);

		$this->add_control(
			'speed',
			[
				'label' => __('Speed', 'streamit-extensions'),
				'type' => Controls_Manager::TEXT,
				'default' => '300',
			]
		);

		$this->add_control(
			'nav-arrow',
			[
				'label' => __('Arrow', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT,
				'default' => 'true',
				'options' => [
					'true' => __('True', 'streamit-extensions'),
					'false' => __('False', 'streamit-extensions'),

				],
			]
		);

		$this->add_control(
			'arrow_back_normal_color',
			[
				'label' => __('Arrow Background Color', 'streamit-extensions'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .favorites-slider .slick-arrow i,{{WRAPPER}} .inner-slider .slick-arrow i,{{WRAPPER}} .trending-slider-nav .slick-arrow i,{{WRAPPER}} .trending-contens .slick-arrow i,{{WRAPPER}} .favorites-slider .slick-arrow svg,{{WRAPPER}} .inner-slider .slick-arrow svg,{{WRAPPER}} .trending-slider-nav .slick-arrow svg,{{WRAPPER}} .trending-contens .slick-arrow svg, {{WRAPPER}} .iq-woocommerce-product-slider .slick-arrow, {{WRAPPER}}.iq-main-slider .slick-arrow::before , {{WRAPPER}} .streamit-product-cat-slick .slick-arrow i, {{WRAPPER}} .streamit-product-cat-slick .slick-arrow svg' => 'background: {{VALUE}};',
				],
				'condition' => ['nav-arrow' => 'true']
			]
		);

		$this->add_control(
			'icon_color',
			[
				'label' => __('Icon Color', 'streamit-extensions'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .favorites-slider .slick-arrow i,{{WRAPPER}} .inner-slider .slick-arrow i,{{WRAPPER}} .trending-slider-nav .slick-arrow i,{{WRAPPER}} .trending-contens .slick-arrow i,{{WRAPPER}} .favorites-slider .slick-arrow svg,{{WRAPPER}} .inner-slider .slick-arrow svg,{{WRAPPER}} .trending-slider-nav .slick-arrow svg,{{WRAPPER}} .iq-main-slider,{{WRAPPER}} .iq-woocommerce-product-slider .slick-arrow i, {{WRAPPER}} .streamit-product-cat-slick .slick-arrow i, {{WRAPPER}} .streamit-product-cat-slick .slick-arrow svg  ' => 'color: {{VALUE}};--iq-primary:{{VALUE}};--active:{{VALUE}}',

				],
				'condition' => ['nav-arrow' => 'true']
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_button_style',
			[
				'label' => __('Button', 'streamit-extensions'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'button_padding',
			[
				'label' => __('Padding', 'streamit-extensions'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors' => [
					'{{WRAPPER}} .iq-btn-container .iq-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
				],
			]
		);

		$this->add_responsive_control(
			'button_border_radius',
			[
				'label' => __('Border Radius', 'streamit-extensions'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors' => [
					'{{WRAPPER}} .iq-btn-container .iq-button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important',
				],
			]
		);

		$this->end_controls_section();
	}

	protected function render()
	{
		require 'render.php';
		if (Plugin::$instance->editor->is_edit_mode()) { ?>
			<script>
				(function(jQuery) {
					callTvShowTabNew(jQuery('.tvshow_tab_new_slider'));
				})(jQuery);
			</script>
<?php
		}
	}
}
