<?php

namespace Iqonic\Elementor\Elements\TvShow_Cards;

use Elementor\Plugin;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit;

class Widget extends Widget_Base
{
	public function get_name()
	{
		return 'iqonic_tvshow_cards';
	}

	public function get_title()
	{
		return esc_html__('Tv Show Cards', 'streamit-extensions');
	}

	public function get_categories()
	{
		return ['streamit-extension'];
	}

	public function get_icon()
	{
		return 'eicon-slider-push';
	}

	protected function register_controls()
	{
		$this->start_controls_section(
			'section_Team',
			[
				'label' => __('Tv Show Cards', 'streamit-extensions'),
			]
		);

		$this->add_control(
			'section_title',
			[
				'label' 		=> __('Title', 'streamit-extensions'),
				'type' 			=> Controls_Manager::TEXT,
				'default' 		=> __('Title', 'streamit-extensions'),
				'label_block' 	=> true,
			]
		);

		$this->add_control(
			'title_tag',
			[
				'label'      => __('Title Tag', 'streamit-extensions'),
				'type'       => Controls_Manager::SELECT,
				'options'    => [
					'h1'          => __('h1', 'streamit-extensions'),
					'h2'          => __('h2', 'streamit-extensions'),
					'h3'          => __('h3', 'streamit-extensions'),
					'h4'          => __('h4', 'streamit-extensions'),
					'h5'          => __('h5', 'streamit-extensions'),
					'h6'          => __('h6', 'streamit-extensions'),
				],
				'default'    => 'h4',
			]
		);

		$this->add_control(
			'slider_start',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);

		$this->add_control(
			'slider_type',
			[
				'label' 	=> __('Style', 'streamit-extensions'),
				'type' 		=> Controls_Manager::SELECT,
				'options' 	=> [
					'slider' 	=> __('Slider', 'streamit-extensions'),
					'grid' 		=> __('Grid', 'streamit-extensions')
				],
				'default' 	=> 'slider'
			]
		);

		$this->add_control(
			'tvshow_grid_style',
			[
				'label'     => __('Grid', 'streamit-extensions'),
				'type'      => Controls_Manager::SELECT,
				'default'   => '4',
				'options'   => [
					'1'          => __('One', 'streamit-extensions'),
					'2'          => __('Two', 'streamit-extensions'),
					'3'          => __('Three', 'streamit-extensions'),
					'4'          => __('Four', 'streamit-extensions'),
					'5'          => __('Five', 'streamit-extensions'),
					'6'          => __('Six', 'streamit-extensions'),
				],
				'condition'	=> ['slider_type' => 'grid']
			]
		);

		$this->add_control(
			'image_style',
			[
				'label' 	=> __('Image style', 'streamit-extensions'),
				'type' 		=> Controls_Manager::SELECT,
				'options' 	=> [
					'landscape' 	=> __('Landscape', 'streamit-extensions'),
					'portrait' 		=> __('Portrait', 'streamit-extensions')
				],
				'default' 	=> 'portrait'
			]
		);

		$this->add_control(
			'iq_select_tvshows',
			[
				'label' 		=> __('Select Tv Shows', 'streamit-extensions'),
				'type' 			=> Controls_Manager::SELECT2,
				'label_block'	=> true,
				'multiple' 		=> true,
				'options' 		=> isset($_REQUEST['editor_post_id']) ? iq_custom_post_data('tv_show') : [],
			]
		);

		$this->add_control(
			'iq_tvshow_genre',
			[
				'label' 		=> __('Display Tv Show From Specific Genre', 'streamit-extensions'),
				'type' 			=> Controls_Manager::SELECT2,
				'label_block' 	=> true,
				'multiple' 		=> true,
				'options' 		=> isset($_REQUEST['editor_post_id']) ? iq_get_custom_taxonomy('tv_show_genre') : [],
			]
		);

		$this->add_control(
			'iq_tvshow_tag',
			[
				'label' 		=> __('Display Tv Show From Specific Tags', 'streamit-extensions'),
				'type' 			=> Controls_Manager::SELECT2,
				'label_block'	=> true,
				'multiple' 		=> true,
				'options' 		=> isset($_REQUEST['editor_post_id']) ? iq_get_custom_taxonomy('tv_show_tag') : [],
			]
		);

		$this->add_control(
			'show_title',
			[
				'label' 		=> __('Show Title', 'streamit-extensions'),
				'type' 			=> Controls_Manager::SWITCHER,
				'yes' 			=> __('Yes', 'streamit-extensions'),
				'no' 			=> __('No', 'streamit-extensions'),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);

		$this->add_control(
			'enable_premium_badges',
			[
				'label' 		=> __('Enable Premium Badges', 'streamit-extensions'),
				'type' 			=> Controls_Manager::SWITCHER,
				'yes' 			=> __('Yes', 'streamit-extensions'),
				'no' 			=> __('No', 'streamit-extensions'),
				'return_value' 	=> 'yes',
				'default' 		=> 'no',
			]
		);

		$this->add_control(
			'enable_ajax',
			[
				'label' 		=> __('Enable Ajax', 'streamit-extensions'),
				'type' 			=> Controls_Manager::SWITCHER,
				'yes' 			=> __('Yes', 'streamit-extensions'),
				'no' 			=> __('No', 'streamit-extensions'),
				'return_value' 	=> 'yes',
				'default' 		=> 'no',
			]
		);

		$this->add_control(
			'view_all_start',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);

		$this->add_control(
			'view_all_switch',
			[
				'label' 		=> __('Enable view all button', 'streamit-extensions'),
				'type' 			=> Controls_Manager::SWITCHER,
				'yes' 			=> __('Yes', 'streamit-extensions'),
				'no' 			=> __('No', 'streamit-extensions'),
				'return_value' 	=> 'yes',
				'default' 		=> 'no',
			]
		);

		$this->add_control(
			'use_custom_link_viewall',
			[
				'label' 		=> __('Add custom link ?', 'streamit-extensions'),
				'type' 			=> Controls_Manager::SWITCHER,
				'yes' 			=> __('Yes', 'streamit-extensions'),
				'no' 			=> __('No', 'streamit-extensions'),
				'return_value'	=> 'yes',
				'default' 		=> 'no',
				'condition' 	=> ['view_all_switch' => 'yes'],
			]
		);

		$this->add_control(
			'use_custom_link_text',
			[
				'label' 		=> __('Link Text', 'streamit-extensions'),
				'type' 			=> Controls_Manager::TEXT,
				'default' 		=> __('Link Text', 'streamit-extensions'),
				'label_block' 	=> true,
				'condition' 	=> [
					'use_custom_link_viewall' 	=> 'yes',
					'view_all_switch' 			=> 'yes'
				],
			]
		);

		$this->add_control(
			'view_all_custom_link',
			[
				'label' 		=> __('Custom link', 'streamit-extensions'),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> __('https://your-link.com', 'streamit-extensions'),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '',
					'is_external' 	=> true,
					'nofollow' 		=> true,
				],
				'condition' 	=> [
					'use_custom_link_viewall' 	=> 'yes',
					'view_all_switch' 			=> 'yes'
				],
			]
		);

		$this->add_control(
			'post_control_start',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);

		require STREAMIT_EXTENSION_PLUGIN_PATH . '/includes/Elementor/Controls/post-control.php';

		$this->add_control(
			'pagination_start',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);

		$this->add_control(
			'pagination',
			[
				'label'   => __('Pagination type', 'streamit-extensions'),
				'type'    => Controls_Manager::SELECT,
				'default' => 'loadmore',
				'options' => [
					'yes' 		=> esc_html__('Pagination', 'streamit-extensions'),
					'loadmore' 	=> esc_html__('Loadmore', 'streamit-extensions'),
					'infinite' 	=> esc_html__('Infinite Scroll', 'streamit-extensions'),
					'no' 		=> esc_html__('No Pagination', 'streamit-extensions'),
				],
				'condition' => ['slider_type' => 'grid']
			]
		);

		$this->add_control(
			'more_text',
			[
				'label' 		=> __('Button text', 'streamit-extensions'),
				'type' 			=> Controls_Manager::TEXT,
				'default' 		=> __('Load More', 'streamit-extensions'),
				'label_block' 	=> true,
				'condition' 	=> ['slider_type' => 'grid', 'pagination' => 'loadmore']
			]
		);

		$this->add_control(
			'loading_text',
			[
				'label' 		=> __('Loading button text', 'streamit-extensions'),
				'type' 			=> Controls_Manager::TEXT,
				'default' 		=> __('Loading...', 'streamit-extensions'),
				'label_block' 	=> true,
				'condition' 	=> ['slider_type' => 'grid', 'pagination' => 'loadmore']
			]
		);

		$this->add_responsive_control(
			'posts_per_page',
			[
				'label' 		=> __('Posts Per Page', 'streamit-extensions'),
				'type' 			=> Controls_Manager::SLIDER,
				'default' 		=> [
					'unit' 	=> '%',
					'size' 	=> 10,
				]
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'slick_control_section',
			[
				'label' 	=> __('Slider Control', 'streamit-extensions'),
				'condition' => ['slider_type' => ['slider']],
			]
		);

		require STREAMIT_EXTENSION_PLUGIN_PATH . '/includes/Elementor/Controls/slick-control.php';

		$this->end_controls_section();
	}

	protected function render()
	{
		require   'render.php';
		if (Plugin::$instance->editor->is_edit_mode()) { ?>
			<script>
				(function(jQuery) {
					jQuery(document).ready(function() {
						callSlickSlider(jQuery('.favorites-slider'));
						tvshowCardsAjaxHandler();
					});
				})(jQuery)
			</script>
<?php
		}
	}
}
