<?php

$count_numbers++;

$badge      = false;
$url_link   = get_the_permalink($post_id);

if ($is_badges_enable) {
    $is_post_restricted = pmpro_has_membership_access($post_id) === false;
    if ($is_post_restricted) $badge = streamit_premium_bage_svg();
}

if ($settings['show_verticle_image'] == "yes") {
    $slider_image = streamit_get_portrait_image($post_id);
} else {
    $thumb_id   = get_post_thumbnail_id($post_id);
    $slider_image = wp_get_attachment_image_src($thumb_id, 'medium_large')[0];
}

if ($is_ajax_enable && isset($lazy_load) && !empty($lazy_load)) {
    $img_class      = ' iqonic-lazy';
    $lazy_image     = get_cards_lazy_load_image();

    $original_image = $slider_image;
    $slider_image   = $lazy_image;
    $srcset         = "data-srcset=" . $original_image . "";
} else {
    $img_class  = '';
    $srcset     = '';
} ?>

<li class="slide-items <?php echo esc_attr($col); ?>">
    <div class="block-image position-relative">
        <div class="img-box">
            <?php if ($badge) {
                echo "<img class='streamit-badges' src=" . $badge . " alt=" . esc_attr__("Premium", SE_TEXT_DOMAIN) . ">";
            } ?>
            <a class="overly-images" href="<?php echo esc_url($url_link); ?>">
                <img src="<?php echo esc_url($slider_image) ?>" class="img-fluid <?php echo esc_attr($img_class); ?>" alt="<?php echo esc_attr__('image', ' streamit-extensions'); ?>" <?php echo esc_attr($srcset); ?>>
            </a>
            <span class="top_ten_numbers"> <?php echo esc_html($count_numbers); ?> </span>
        </div>
    </div>
</li>