<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;

$rand 			= rand(10, 100);
$slider_title 	= $view_cat = $view_all  = $lazy_load = $ajax_load = '';

$current_page 	= '1';
$can_be_loaded 	= false;
$loadmore_btn 	= 'top_ten-load-btn-' . $rand;

$settings 				= $this->get_settings();

$is_grid 				= ($settings['slider_type'] == 'grid');
$parent_class 			= $is_grid ? "grid-view" : "";
$options_streamit_load 	= $is_grid ? $settings['pagination'] : "";

$is_ajax_enable			= $settings['enable_ajax'] == "yes";
$is_badges_enable		= (isset($settings['enable_premium_badges']) && $settings['enable_premium_badges'] == "yes") ? true : false;

$paged 					= (get_query_var('paged')) ? get_query_var('paged') : 1;

if ($paged > 1 && $settings['posts_per_page']['size'] > 0) {
	$post_per_page 	=  $settings['posts_per_page']['size'];
	$count_numbers 	=  ($paged - 2) * $post_per_page + $post_per_page;
} else {
	$count_numbers = 0;
}

$args = array(
	'post_status'       => 'publish',
	'paged' 			=> $paged,
	'meta_key'			=> 'post_views_count',
	'order'				=> 'DESC',
	'fields'			=> 'ids',
	'meta_query' 		=> [
		[
			'key'     => 'name_upcoming',
			'value'   => '',
			'compare' => '=='
		]
	]
);

if ($settings['post_filter'] == "selected") {
	$args['posts_per_page'] = -1;
	$tabs 					= $settings['tabs'];
	$args['post_type'] 		= array('movie', 'tv_show', 'video');

	foreach ($tabs as $index => $item) {
		$type = $item["iq_type"];
		if (!empty($item['iq_' . $type])) {
			$post_names[] = $item['iq_' . $type];
		}
	}
	$args['post_name__in'] 	= $post_names;
	$args['orderby']		= 'post_name__in';
} else {
	$args['orderby'] 		= 'meta_value_num';
	$args['post_type'] 		= $settings['filter_post_types'];
	$args['posts_per_page'] = $settings['posts_per_page']['size'];
}

$wp_query 		= new \WP_Query($args);

$post_ids 		= $wp_query->posts;
$count 			= $wp_query->post_count;
$total_pages 	= $wp_query->max_num_pages;

if ($is_ajax_enable) {
	$current_page 	= '0';
	$can_be_loaded 	= true;
	$ajax_load 		= 'ajax_load';
	$lazy_load 		= " iqonic-lazy-load-images";
	$parent_class 	.= $lazy_load;
}

if (isset($settings['section_title'])) {
	$slider_title 		= $settings['section_title'];
	$slider_title_key  	= str_replace(" ", "_", $slider_title);
	$title_option 		= $slider_title_key;
	$view_cat 			= '&title=' . $title_option;
}

if ($settings['use_custom_link_viewall'] == 'yes') {
	$this->add_render_attribute('viewall_attr', 'class', 'iq-view-all');
	if ($settings['view_all_custom_link']['url']) {
		$url = $settings['view_all_custom_link']['url'];
		$this->add_render_attribute('viewall_attr', 'href', esc_url($url));

		if ($settings['view_all_custom_link']['is_external']) {
			$this->add_render_attribute('viewall_attr', 'target', '_blank');
		}

		if ($settings['view_all_custom_link']['nofollow']) {
			$this->add_render_attribute('viewall_attr', 'rel', 'nofollow');
		}
	}
	$view_all_text = esc_html($settings['use_custom_link_text']);
	$view_all = '<a ' . $this->get_render_attribute_string('viewall_attr') . '">' . $view_all_text . '</a>';
}

if ($settings['slider_type'] == "slider") {
	$temp_col 		= '';
	$is_grid 		=  false;
	$thumbnail_size = "full";
	$col 			= "slide-item";

	$this->add_render_attribute('ul_attr', 'data-nav', $settings['nav-arrow']);
	$this->add_render_attribute('ul_attr', 'data-items', $settings['desk_number']);
	$this->add_render_attribute('ul_attr', 'data-items-laptop', $settings['lap_number']);
	$this->add_render_attribute('ul_attr', 'data-items-tab', $settings['tab_number']);
	$this->add_render_attribute('ul_attr', 'data-items-mobile', $settings['mob_number']);
	$this->add_render_attribute('ul_attr', 'data-items-mobile-sm', $settings['mob_number']);
	$this->add_render_attribute('ul_attr', 'data-autoplay', $settings['autoplay']);
	$this->add_render_attribute('ul_attr', 'data-autoplay-speed', $settings['autoplay_speed']);
	$this->add_render_attribute('ul_attr', 'data-loop', $settings['infinite']);
	$this->add_render_attribute('ul_attr', 'data-speed', $settings['speed']);
	$this->add_render_attribute('ul_attr', 'class', "favorites-slider movie-list-slider list-inline top-ten row p-0 mb-0");
	$this->add_render_attribute('ul_attr', 'class', "iq-rtl-direction");

	if ($settings['nav-arrow-style'] == 'style-2')
		$this->add_render_attribute('ul_attr', 'class', "iq-arrow-2");
} else {
	$this->add_render_attribute('ul_attr', 'class', "top-ten movie-list-grid list-grid row p-0 list-unstyled");
	$li_class = [
		'1' => "col-12 wl-child",
		'2' => "col-lg-6 col-md-6 col-sm-6 wl-child",
		'3' => "col-lg-4 col-md-4 col-sm-6 wl-child",
		'4' => "col-xl-3 col-lg-4 col-md-4 col-sm-6 col-6 wl-child",
		'5' => "iq-five col-lg-4 col-md-6 col-sm-6 col-6 wl-child",
		'6' => "col-xl-2 col-lg-4 col-md-6 col-sm-6 col-6 wl-child"
	];

	$can_be_loaded 		= ($is_ajax_enable || $total_pages > 1) ? true : false;
	$col = $temp_col 	= $li_class[$settings['movie_grid_style']];
}

$temp_settings = [
	'col'					=> $temp_col,
	'is_badges_enable'		=> $is_badges_enable,
	'show_verticle_image' 	=> $settings['show_verticle_image'],
	'is_ajax_enable'		=> $is_ajax_enable,
	'lazy_load'				=> $lazy_load,
];

if (empty($settings['number_bg_image_image']['url']) && !empty($settings['number_bg_image_color']))
	$this->add_render_attribute('ul_attr', 'class', "number-has-back-color"); ?>

<div class="iq-card-wrapper iq-ajax-content favorites-contens streamit-top_ten clearfix <?php echo esc_attr($parent_class); ?>" data-options="<?php echo esc_html($options_streamit_load); ?>" data-can-beloaded="true">
	<?php if (!empty($post_ids)) :
		$title_tag = $settings['title_tag'];
		echo streamit_get_shortcode_title($slider_title, $title_tag, $view_all); ?>
	<?php endif; ?>

	<ul <?php echo $this->get_render_attribute_string('ul_attr'); ?>>
		<?php if (!$is_ajax_enable && $wp_query->have_posts()) {
			foreach ($post_ids as $post_id) {
				require trailingslashit(plugin_dir_path(__FILE__)) . 'template.php';
			}
			wp_reset_postdata();
		} else {
			for ($i = 0; $i < $count; $i++) {
				require trailingslashit(STREAMIT_EXTENSION_PLUGIN_PATH) . 'includes/Elementor/Elements/General/TopTen_General.php';
			}
		} ?>
	</ul>

	<?php if ($is_grid && $can_be_loaded && $settings['pagination'] == 'yes') {
		streamit_get_numbers_pagination($total_pages);
	} elseif ($is_grid && $can_be_loaded && $settings['pagination'] == 'infinite' && $total_pages > 1) {
		echo '<div class="loader-wheel-container"></div>';
	} ?>
</div>

<?php if ($can_be_loaded) { ?>
	<div class="loader-wheel-container">
		<?php if ($is_grid && $settings['pagination'] == 'loadmore' && $total_pages > 1) : ?>
			<div class="<?php echo esc_attr($loadmore_btn); ?>">
				<div class="btn btn-hover iq-button">
					<span><?php echo !empty($settings['more_text']) ? esc_html($settings['more_text']) : '' ?></span>
				</div>
			</div>
		<?php endif;

		if ($is_grid && $settings['pagination'] == "yes") {
			$current_page  = max(1, get_query_var('paged')) - 1;
		}

		$pagination_args = [
			'action' 			=> 'top_ten',
			'current_page'		=> $current_page,
			'total_pages'		=> $total_pages,
			'loadmore_btn'		=> $loadmore_btn,
			'loading_text'		=> $settings['loading_text'],
			'query_args'		=> $args,
			'temp_settings'		=> $temp_settings,
			'posts_per_page' 	=> $count,
			'ajax_load'			=> $ajax_load,
			'is_ajax_enable'	=> $is_ajax_enable,
			'count_numbers'		=> $count_numbers,
		];

		streamit_get_pagination_args($pagination_args); ?>
	</div>
<?php } ?>