<?php

namespace Iqonic\Elementor\Elements\Top_Ten;

use Elementor\Plugin;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Typography;

if (!defined('ABSPATH')) exit;

class Widget extends Widget_Base
{
	public function get_name()
	{
		return 'iqonic_top_ten';
	}

	public function get_title()
	{
		return esc_html__('Top Ten Movies/Tv Shows/Videos', 'streamit-extensions');
	}

	public function get_categories()
	{
		return ['streamit-extension'];
	}

	public function get_icon()
	{
		return 'eicon-slider-push';
	}

	protected function register_controls()
	{
		$this->start_controls_section(
			'section_Team',
			[
				'label' => __('Top Ten', 'streamit-extensions'),
			]
		);

		$this->add_control(
			'section_title',
			[
				'label' => __('Title', 'streamit-extensions'),
				'type' => Controls_Manager::TEXT,
				'default' => __('Title', 'streamit-extensions'),
				'label_block' => true,
			]
		);

		$this->add_control(
			'title_tag',
			[
				'label'      => __('Title Tag', 'streamit-extensions'),
				'type'       => Controls_Manager::SELECT,
				'options'    => [
					'h1'          => __('h1', 'streamit-extensions'),
					'h2'          => __('h2', 'streamit-extensions'),
					'h3'          => __('h3', 'streamit-extensions'),
					'h4'          => __('h4', 'streamit-extensions'),
					'h5'          => __('h5', 'streamit-extensions'),
					'h6'          => __('h6', 'streamit-extensions'),
				],
				'default'    => 'h4',
			]
		);

		$this->add_control(
			'post_filter',
			[
				'label' => __('Posts Filter', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT,
				'label_block' => true,
				'multiple' => false,
				'options' => [
					'selected' 	=> __('Selected', 'streamit-extensions'),
					'latest' 	=> __('Latest', 'streamit-extensions')
				],
				'default' => 'latest'
			]
		);

		$this->add_control(
			'filter_post_types',
			[
				'label' 		=> __('Posts Filter', 'streamit-extensions'),
				'type' 			=> Controls_Manager::SELECT2,
				'label_block' 	=> true,
				'multiple' 		=> true,
				'options' 		=> [
					'movie' 		=> __('Movie', 'streamit-extensions'),
					'tv_show' 		=> __('Tv Show', 'streamit-extensions'),
					'video' 		=> __('Video', 'streamit-extensions')
				],
				'default' 		=> 'movie',
				'condition' 	=> ['post_filter!' => 'selected']
			]
		);

		$repeater = new Repeater();
		$repeater->add_control(
			'iq_type',
			[
				'label' => __('Select Post Type', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT,
				'label_block' => true,
				'multiple' => true,
				'options' => [
					'movie' => __('Movie', 'streamit-extensions'),
					'tv_show' => __('Tv Show', 'streamit-extensions'),
					'video' => __('Video', 'streamit-extensions')
				],
				'default' => 'movie'
			]
		);

		$repeater->add_control(
			'iq_tv_show',
			[
				'label' => __('Display Specific Tv-Show', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT,
				'label_block' => true,
				'multiple' => true,
				'options' => isset($_REQUEST['editor_post_id']) ? iq_custom_post_data('tv_show') : [],
				'condition' => ['iq_type' => ['tv_show']],
			]
		);

		$repeater->add_control(
			'iq_movie',
			[
				'label' => __('Display Specific Movie', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT,
				'label_block' => true,
				'multiple' => true,
				'options' => isset($_REQUEST['editor_post_id']) ? iq_custom_post_data('movie') : [],
				'condition' => ['iq_type' => ['movie']],
			]
		);

		$repeater->add_control(
			'iq_video',
			[
				'label' => __('Display Specific Video', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT,
				'label_block' => true,
				'multiple' => true,
				'options' => isset($_REQUEST['editor_post_id']) ? iq_custom_post_data('video') : [],
				'condition' => ['iq_type' => ['video']],
			]
		);

		$this->add_control(
			'tabs',
			[
				'label' => __('Select posts manually', 'streamit-extensions'),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'condition' => ['post_filter' => 'selected']
			]
		);

		$this->add_control(
			'slider_type',
			[
				'label' => __('Style', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT,
				'label_block' => true,
				'multiple' => true,
				'options' => [
					'slider' => __('Slider', 'streamit-extensions'),
					'grid' => __('Grid', 'streamit-extensions')
				],
				'default' => 'slider'
			]
		);

		$this->add_control(
			'movie_grid_style',
			[
				'label'      => __('Movie Grid', 'streamit-extensions'),
				'type'       => Controls_Manager::SELECT,
				'default'    => '4',
				'options'    => [
					'1'            => __('One', 'streamit-extensions'),
					'2'          => __('Two', 'streamit-extensions'),
					'3'          => __('Three', 'streamit-extensions'),
					'4'          => __('Four', 'streamit-extensions'),
					'5'          => __('Five', 'streamit-extensions'),
					'6'          => __('Six', 'streamit-extensions'),
				],
				'condition' => ['slider_type' => 'grid']
			]
		);

		$this->add_control(
			'enable_premium_badges',
			[
				'label' 		=> __('Enable Premium Badges', 'streamit-extensions'),
				'type' 			=> Controls_Manager::SWITCHER,
				'yes' 			=> __('Yes', 'streamit-extensions'),
				'no' 			=> __('No', 'streamit-extensions'),
				'return_value' 	=> 'yes',
				'default' 		=> 'no',
			]
		);

		$this->add_control(
			'enable_ajax',
			[
				'label' 		=> __('Enable Ajax', 'streamit-extensions'),
				'type' 			=> Controls_Manager::SWITCHER,
				'yes' 			=> __('Yes', 'streamit-extensions'),
				'no' 			=> __('No', 'streamit-extensions'),
				'return_value' 	=> 'yes',
				'default' 		=> 'no',
			]
		);

		$this->add_control(
			'show_verticle_image',
			[
				'label' => __('Show Verticle Image ?', 'streamit-extensions'),
				'type' => Controls_Manager::SWITCHER,
				'yes' => __('Yes', 'streamit-extensions'),
				'no' => __('No', 'streamit-extensions'),
				'return_value' => 'yes',
				'default' => 'no',
				'description' => esc_html__("Note: Kindly Upload verticle image of size 522*760, if option set to true", 'streamit-extensions'),
			]
		);

		$this->add_control(
			'view_all_start',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);

		$this->add_control(
			'use_custom_link_viewall',
			[
				'label' => __('Use View All custom link ?', 'streamit-extensions'),
				'type' => Controls_Manager::SWITCHER,
				'yes' => __('Yes', 'streamit-extensions'),
				'no' => __('No', 'streamit-extensions'),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'use_custom_link_text',
			[
				'label' => __('Custom Link Text', 'streamit-extensions'),
				'type' => Controls_Manager::TEXT,
				'default' => __('Link Text', 'streamit-extensions'),
				'label_block' => true,
				'condition' => [
					'use_custom_link_viewall' => 'yes',
				],
			]
		);

		$this->add_control(
			'view_all_custom_link',
			[
				'label' => __('Custom link', 'streamit-extensions'),
				'type' => Controls_Manager::URL,
				'placeholder' => __('https://your-link.com', 'streamit-extensions'),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
				'condition' => [
					'use_custom_link_viewall' => 'yes',
				],
			]
		);

		$this->add_control(
			'pagination',
			[
				'label'   => __('Show Pagintion/Loadmore/Infinite', 'streamit-extensions'),
				'type'    => Controls_Manager::SELECT,
				'default' => 'loadmore',
				'label_block' => true,
				'options' => [
					'yes' => esc_html__('Pagination', 'streamit-extensions'),
					'loadmore' => esc_html__('Loadmore', 'streamit-extensions'),
					'infinite' => esc_html__('Infinite Scroll', 'streamit-extensions')
				],
				'condition' => ['slider_type' => 'grid']

			]
		);

		$this->add_control(
			'more_text',
			[
				'label' => __('Load More button text', 'streamit-extensions'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __('Load More', 'streamit-extensions'),
				'label_block' => true,
				'condition' => ['slider_type' => 'grid', 'pagination' => 'loadmore']
			]
		);

		$this->add_control(
			'loading_text',
			[
				'label' => __('Loading button text', 'streamit-extensions'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __('Loading...', 'streamit-extensions'),
				'label_block' => true,
				'condition' => ['slider_type' => 'grid', 'pagination' => 'loadmore']
			]
		);

		$this->add_responsive_control(
			'posts_per_page',
			[
				'label' => __('Posts Per Page', 'streamit-extensions'),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'unit' => '%',
					'size' => 10,
				],
				'condition' => [
					'post_filter' => 'latest'
				],
			]
		);

		$this->end_controls_section();
		$this->start_controls_section(
			'slick_control_section',
			[
				'label' => __('Slider Control', 'streamit-extensions'),
				'condition' => [
					'slider_type' => 'slider'
				],
			]
		);

		require STREAMIT_EXTENSION_PLUGIN_PATH . '/includes/Elementor/Controls/slick-control.php';

		$this->end_controls_section();

		$this->start_controls_section(
			'section_title_style',
			[
				'label' => __('Numbers', 'streamit-extensions'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => __('Typography', 'streamit-extensions'),
				'selector' => '{{WRAPPER}} .top-ten .top_ten_numbers',
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'number_bg_image',
				'label' => __('Choose Background Color/Image For Numbers', 'streamit-extensions'),
				'types' => ['classic', 'gradient'],
				'selector' => '{{WRAPPER}} .top-ten .top_ten_numbers',
			]
		);

		$this->end_controls_section();
	}

	protected function render()
	{
		require 'render.php';

		if (Plugin::$instance->editor->is_edit_mode()) { ?>
			<script>
				(function(jQuery) {
					callSlickSlider(jQuery('.favorites-slider'));
					toptenAjaxHandler();
				})(jQuery)
			</script>
<?php
		}
	}
}
