<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;

$id         = $this->get_id();
$settings   = $this->get_settings(); ?>

<div class="info-toggle-menu iq-users-settings user-btn nav-item nav-icon header-user-rights iq-usermenu-dropdown">
    <div class="nav-item nav-icon header-user-rights">
        <a href="javascript:void(0);" class="iq-user-dropdown search-toggle p-0 d-flex align-items-center active" id="<?php echo esc_html($id) ?>" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
            <?php if (!empty($settings['toggle_icon']['value'])) {
                echo '<span class="iq-avatar" >';
                Icons_Manager::render_icon($settings['toggle_icon'], ['aria-hidden' => 'true', 'alt' => 'user']);
                echo '</span>';
            } ?>
        </a>

        <div class="iq-sub-dropdown iq-user-dropdown  dropdown-menu" aria-labelledby="<?php echo esc_html($id) ?>">
            <div class="iq-card shadow-none m-0">
                <div class="iq-card-body p-0 pl-3 pr-3">
                    <?php if ($settings['list_user_non_login']) {
                        foreach ($settings['list_user_non_login'] as $item) {
                            $url = $item['use_archive_link'] == 'yes' ? $item['archive_dynamic_link'] : get_permalink(get_page_by_path($item['list_page_link'])); ?>
                            <a href="<?php echo  esc_url($url) ?>" class="iq-list-link iq-sub-card">
                                <div class="media align-items-center">
                                    <?php if (!empty($item['list_icon']['value'])) { ?>
                                        <div class="right-icon">
                                            <?php Icons_Manager::render_icon($item['list_icon'], ['aria-hidden' => 'true', 'class' => 'iq-user-list-icon']); ?>
                                        </div>
                                    <?php } ?>

                                    <div class="media-body">
                                        <h6 class="m-0 ">
                                            <?php echo esc_html($item['list_title']); ?>
                                        </h6>
                                    </div>
                                </div>
                            </a>
                    <?php
                        }
                    } ?>
                </div>
            </div>
        </div>
    </div>
</div>