<?php

namespace Iqonic\Elementor\Elements\ToggleMenu;

use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Group_Control_Typography;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit;

class Widget extends Widget_Base
{
	public function get_name()
	{
		return 'iqonic_layout_toggle_menu';
	}

	public function get_title()
	{
		return esc_html__('Toggle Menu', 'streamit-extensions');
	}

	public function get_categories()
	{
		return ['iqonic-layouts-extension'];
	}

	public function get_icon()
	{
		return 'eicon-nav-menu';
	}

	protected function register_controls()
	{
		$this->start_controls_section(
			'section_sc_layouts_user_button',
			[
				'label' => esc_html__('Toggle Menu Icon', 'streamit-extensions'),
			]
		);
		$this->add_control(
			'toggle_icon',
			[
				'label' => esc_html__('Select Menu icon', 'streamit-extensions'),
				'type' => Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-bars',
					'library' => 'fa-solid',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_sc_layouts_user_non_login',
			[
				'label' => esc_html__('Items list', 'streamit-extensions'),
			]
		);

		$repeater = new Repeater();
		$repeater->add_control(
			'list_title',
			[
				'label' => esc_html__('Title', 'streamit-extensions'),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('User', 'streamit-extensions'),
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'list_icon',
			[
				'label' => esc_html__('Select Icon', 'streamit-extensions'),
				'type' => Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-plus',
					'library' => 'fa-solid',
				],
			]
		);

		$repeater->add_control(
			'use_archive_link',
			[
				'label' => __('Use Archive Page link?', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT,
				'default' => 'no',
				'options' => [
					'yes' => __('Yes', 'streamit-extensions'),
					'no' => __('No', 'streamit-extensions'),
				],
			]
		);

		$repeater->add_control(
			'list_page_link',
			[
				'label' => esc_html__('Select Page ', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT,
				'options' => isset($_REQUEST['editor_post_id']) ? iq_custom_post_data('page', true) : [],
				'label_block' => true,
				'condition' => [
					'use_archive_link' => 'no'
				],
			]
		);

		$repeater->add_control(
			'archive_dynamic_link',
			[
				'label' => esc_html__('Select Archive', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT,
				'return_value' => 'true',
				'multiple' => true,
				'condition' => [
					'use_archive_link' => 'yes'
				],
				'options' => isset($_REQUEST['editor_post_id']) ? iq_custom_post_data_archive_link() : [],
			]
		);

		$this->add_control(
			'list_user_non_login',
			[
				'label' => esc_html__('List', 'streamit-extensions'),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'list_title' => esc_html__('Item', 'streamit-extensions'),
						'list_icon' => esc_html__('fas fa-plus', 'streamit-extensions'),

					],
				],
				'title_field' => '{{{ list_title }}}',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_menu_style',
			[
				'label' => __('Menu Icon', 'streamit-extensions'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'icon_menu_size',
			[
				'label' => __('Icon size', 'streamit-extensions'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px', 'em'],
				'range' => [
					'px' => [
						'min' => 6,
						'max' => 300,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .iq-users-settings .iq-user-dropdown svg' => 'height: {{SIZE}}{{UNIT}}; width: {{SIZE}}{{UNIT}}',
					'{{WRAPPER}} .iq-users-settings .iq-user-dropdown i' => 'font-size: {{SIZE}}{{UNIT}}',
				],
			]
		);

		$this->add_responsive_control(
			'menu_parent_padding',
			[
				'label' => __('Padding', 'streamit-extensions'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors' => [
					'{{WRAPPER}}  .iq-users-settings' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->start_controls_tabs('list_tabs');
		$this->start_controls_tab(
			'tabs_c8fpaelTGDkNORMAL',
			[
				'label' => __('Normal', 'streamit-extensions'),
			]
		);

		$this->add_control(
			'social_menu_icon_color',
			[
				'label' => __('Menu Color', 'streamit-extensions'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .iq-users-settings .iq-user-dropdown i' => 'color: {{VALUE}};',
					'{{WRAPPER}} .iq-users-settings .iq-user-dropdown svg' => 'fill: {{VALUE}};',
					'{{WRAPPER}} .iq-users-settings .iq-user-dropdown svg rect' => 'fill: {{VALUE}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tabs_hover_1322c8M564ER0',
			[
				'label' => __('Hover', 'streamit-extensions'),
			]
		);

		$this->add_control(
			'menu_icon_hover_color',
			[
				'label' => __('Menu Color', 'streamit-extensions'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .iq-users-settings .iq-user-dropdown i:hover' => 'color: {{VALUE}};',
					'{{WRAPPER}} .iq-users-settings .iq-user-dropdown svg:hover' => 'fill: {{VALUE}};',
					'{{WRAPPER}} .iq-users-settings .iq-user-dropdown svg:hover rect' => 'fill: {{VALUE}};',
				],
			]
		);

		$this->end_controls_tab();
		$this->end_controls_tabs();

		$this->end_controls_section();

		$this->start_controls_section(
			'section_menu_list_style',
			[
				'label' => __('List Items', 'streamit-extensions'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'icon_heading',
			[
				'label' => esc_html__('Icon Options', 'streamit-extensions'),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_responsive_control(
			'icon_menu_list_size',
			[
				'label' => __('List Icon size', 'streamit-extensions'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px', 'em'],
				'range' => [
					'px' => [
						'min' => 6,
						'max' => 300,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .iq-users-settings .iq-user-dropdown .right-icon svg' => 'height: {{SIZE}}{{UNIT}}; width: {{SIZE}}{{UNIT}}',
					'{{WRAPPER}} .iq-users-settings .iq-user-dropdown .right-icon i' => 'font-size: {{SIZE}}{{UNIT}}',
				],
			]
		);

		$this->start_controls_tabs('titlebox_tabs');
		$this->start_controls_tab(
			'tabs__listc8fpaelTGDkNORMAL',
			[
				'label' => __('Normal', 'streamit-extensions'),
			]
		);

		$this->add_control(
			'social_menu_list_icon_color',
			[
				'label' => __('Color', 'streamit-extensions'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .iq-users-settings .iq-user-dropdown .right-icon i' => 'color: {{VALUE}};',
					'{{WRAPPER}} .iq-users-settings .iq-user-dropdown .right-icon svg' => 'fill: {{VALUE}};',
					'{{WRAPPER}} .iq-users-settings .iq-user-dropdown .right-icon svg rect' => 'fill: {{VALUE}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tabs_hover_list_1322c8M564ER0',
			[
				'label' => __('Hover', 'streamit-extensions'),
			]
		);

		$this->add_control(
			'menu_icon_hover_list_color',
			[
				'label' => __('Color', 'streamit-extensions'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .iq-users-settings .iq-user-dropdown .right-icon i:hover' => 'color: {{VALUE}};',
					'{{WRAPPER}} .iq-users-settings .iq-user-dropdown .right-icon svg:hover' => 'fill: {{VALUE}};',
					'{{WRAPPER}} .iq-users-settings .iq-user-dropdown .right-icon svg:hover rect' => 'fill: {{VALUE}};',
				],
			]
		);

		$this->end_controls_tab();
		$this->end_controls_tabs();

		$this->add_control(
			'text_heading',
			[
				'label' => esc_html__('Text Options', 'streamit-extensions'),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'mobile_typography',
				'label' => __('Typography', 'streamit-extensions'),
				'selector' => '{{WRAPPER}} .iq-users-settings .iq-user-dropdown .media-body h6',
			]
		);

		$this->start_controls_tabs('text_tabs');
		$this->start_controls_tab(
			'tabs_text_c8fpaelTGDkNORMAL',
			[
				'label' => __('Normal', 'streamit-extensions'),
			]
		);

		$this->add_control(
			'social_menu_text_color',
			[
				'label' => __('Color', 'streamit-extensions'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .iq-users-settings .iq-user-dropdown .media-body h6' => 'color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tabs_hover_text_c8M564ER0',
			[
				'label' => __('Hover', 'streamit-extensions'),
			]
		);

		$this->add_control(
			'menu_text_hover_color',
			[
				'label' => __('Menu Color', 'streamit-extensions'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .iq-users-settings .iq-user-dropdown .media-body:hover h6' => 'color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_tab();
		$this->end_controls_tabs();

		$this->end_controls_section();
	}

	protected function render()
	{
		require 'render.php';
	}
}
