<?php

namespace Iqonic\Elementor\Elements\Timer;

use Elementor\Plugin;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;

if (!defined('ABSPATH')) exit;

class Widget extends Widget_Base
{
	public function get_name()
	{
		return 'iqonic_timer';
	}

	public function get_title()
	{
		return esc_html__('Iqonic Timer', 'iqonic-extension');
	}

	public function get_categories()
	{
		return ['streamit-extension'];
	}

	public function get_icon()
	{
		return 'eicon-countdown';
	}

	protected function register_controls()
	{
		$this->start_controls_section(
			'section',
			[
				'label' => esc_html__('Count Down Timer', 'iqonic-extension'),
			]
		);

		$this->add_control(
			'timer_title',
			[
				'label' => esc_html__('Title', 'iqonic-extension'),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => esc_html__('Default title', 'iqonic-extension'),
				'placeholder' => esc_html__('Type your title here', 'iqonic-extension'),
			]
		);

		$this->add_control(
			'title_tag',
			[
				'label'      => esc_html__('Title Tag', 'iqonic-extension'),
				'type'       => Controls_Manager::SELECT,
				'default'    => 'h2',
				'options'    => [
					'h1'          => esc_html__('h1', 'iqonic-extension'),
					'h2'          => esc_html__('h2', 'iqonic-extension'),
					'h3'          => esc_html__('h3', 'iqonic-extension'),
					'h4'          => esc_html__('h4', 'iqonic-extension'),
					'h5'          => esc_html__('h5', 'iqonic-extension'),
					'h6'          => esc_html__('h6', 'iqonic-extension'),
				],
			]
		);

		$this->add_control(
			'future_date',
			[
				'label' => esc_html__('Select Date', 'iqonic-extension'),
				'type' => Controls_Manager::DATE_TIME,
				'dynamic' => [
					'active' => true,
				],
				'label_block' => true,
				'picker_options' => ['enableTime' => true]
			]
		);

		$this->add_control(
			'timer_format',
			[
				'label'      => esc_html__('Select Format', 'iqonic-extension'),
				'type'       => Controls_Manager::SELECT,
				'default'    => 'YODHMS',
				'options'    => [
					'YODHMS' => esc_html__('Year / Month / Day / Hour / Minute / Second', 'iqonic-extension'),
					'ODHMS'  => esc_html__('Month / Day/ Hour / Minute / Second', 'iqonic-extension'),
					'DHMS'   => esc_html__('Day / Hour / Minute / Second', 'iqonic-extension'),
					'HMS'    => esc_html__(' Hour / Minute / Second', 'iqonic-extension'),
					'MS'     => esc_html__('Minute / Second', 'iqonic-extension'),
					'S'      => esc_html__(' Second', 'iqonic-extension'),
				],
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label' => esc_html__('Alignment', 'iqonic-extension'),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__('Left', 'iqonic-extension'),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__('Center', 'iqonic-extension'),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__('Right', 'iqonic-extension'),
						'icon' => 'eicon-text-align-right',
					],
				],
				'selectors' => [
					'{{WRAPPER}} .iq-count-down' => 'text-align: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_count_down_title',
			[
				'label' => esc_html__('Title', 'iqonic-extension'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => esc_html__(' Title Typography', 'iqonic-extension'),
				'selector' => '{{WRAPPER}} .streamit-title.streamit-heading-title',
			]
		);

		$this->add_control(
			'timer_title_color',
			[
				'label' => esc_html__('Title Color', 'iqonic-extension'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .streamit-title.streamit-heading-title' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'timer_title_hover_color',
			[
				'label' => esc_html__('Title Hover Color', 'iqonic-extension'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .streamit-title.streamit-heading-title:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'title_margin',
			[
				'label' => esc_html__('Margin', 'iqonic-extension'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .streamit-title.streamit-heading-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'title_padding',
			[
				'label' => esc_html__('Padding', 'iqonic-extension'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .streamit-title.streamit-heading-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_count_down_style',
			[
				'label' => esc_html__('Timer Text', 'iqonic-extension'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'numbers_typography',
				'label' => esc_html__(' Number Typography', 'iqonic-extension'),
				'selector' => '{{WRAPPER}} .numberDisplay',
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'periods_typography',
				'label' => esc_html__(' Period Typography', 'iqonic-extension'),
				'selector' => '{{WRAPPER}} .periodDisplay',
			]
		);

		$this->add_control(
			'title_color',
			[
				'label' => esc_html__('Timer Color', 'iqonic-extension'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .iq-count-down ' => 'color: {{VALUE}};',
					'{{WRAPPER}} .numberDisplay' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'label_color',
			[
				'label' => esc_html__('Text Color', 'iqonic-extension'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .iq-count-down .iq-data-countdown-timer .periodDisplay' => 'color: {{VALUE}};',

				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_border_style',
			[
				'label' => esc_html__('Border', 'iqonic-extension'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'has_border',
			[
				'label' => esc_html__('Border?', 'iqonic-extension'),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'label_off',
				'yes' => esc_html__('yes', 'iqonic-extension'),
				'no' => esc_html__('no', 'iqonic-extension'),
			]
		);
		
		$this->add_control(
			'border_style',
			[
				'label' => esc_html__('Border Style', 'iqonic-extension'),
				'type' => Controls_Manager::SELECT,
				'default' => 'none',
				'options' => [
					'solid'  => esc_html__('Solid', 'iqonic-extension'),
					'dashed' => esc_html__('Dashed', 'iqonic-extension'),
					'dotted' => esc_html__('Dotted', 'iqonic-extension'),
					'double' => esc_html__('Double', 'iqonic-extension'),
					'outset' => esc_html__('outset', 'iqonic-extension'),
					'groove' => esc_html__('groove', 'iqonic-extension'),
					'ridge' => esc_html__('ridge', 'iqonic-extension'),
					'inset' => esc_html__('inset', 'iqonic-extension'),
					'hidden' => esc_html__('hidden', 'iqonic-extension'),
					'none' => esc_html__('none', 'iqonic-extension'),
				],
				'condition' => [
					'has_border' => 'yes',
				],
				'selectors' => [
					'{{WRAPPER}} .iq-count-down .numberDisplay' => 'border-style: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'border_color',
			[
				'label' => esc_html__('Color', 'iqonic-extension'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .iq-count-down .numberDisplay' => 'border-color: {{VALUE}};',
				],
				'condition' => [
					'has_border' => 'yes',
				],
			]
		);

		$this->add_control(
			'border_width',
			[
				'label' => esc_html__('Border Width', 'iqonic-extension'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .iq-count-down .numberDisplay' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [
					'has_border' => 'yes',
				],
			]
		);

		$this->add_control(
			'count_down_padding',
			[
				'label' => esc_html__('Padding', 'iqonic-extension'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .iq-count-down .numberDisplay' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [
					'has_border' => 'yes',
				],
			]
		);

		$this->add_control(
			'border_radius',
			[
				'label' => esc_html__('Border Radius', 'iqonic-extension'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .iq-count-down .numberDisplay' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [
					'has_border' => 'yes',
				],
			]
		);
		$this->end_controls_section();
	}

	protected function render()
	{
		require 'render.php';

		if (Plugin::$instance->editor->is_edit_mode()) { ?>
			<script>
				(function($) {
					callTimer();
				})(jQuery);
			</script>
<?php
		}
	}
}
