<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;

$taxargs        = array();
$rand           = rand(10, 100);
$settings       = $this->get_settings();
$loadmore_btn   = 'tags-load-btn-' . $rand;
$terms_per_page = $settings['posts_per_page']['size'] != -1 ? $settings['posts_per_page']['size'] : 0;
$current_page   = (get_query_var('paged')) ? get_query_var('paged') : 1;
$offset         = ($terms_per_page * $current_page) - $terms_per_page;


$target = "target=" . $settings['link_target'] . "";

$args = array(
    'post_type'     => $settings['iq_type'],
    'orderby'       => 'name',
    'order'         => $settings['order'],
    'taxonomy'      => $settings['iq_type'] . '_tag',
    'show_count'    => true,
);

if ($terms_per_page == -1) {
    $args['paged']          = $current_page;
    $args['posts_per_page'] = -1;
} else {
    $args['number']         = $terms_per_page;
    $args['offset']         = $offset;
}

$tag = [];
if(in_array($settings['iq_type'],['video','tv_show','movie'])){
    $args['post_type']  = $settings['iq_type'];
    $taxonomy           = $settings['iq_type'] . '_tag';
    $tag               = $settings['iq_' . $settings['iq_type']];
} 

if ($settings['iq_type_filter'] == 'selected' && !empty($tag)) {
    $tax_query['taxonomy']  = $taxonomy;
    $tax_query['field']     = 'slug';
    $tax_query['terms']     = $tag;
    $tax_query['operator']  = 'IN';
    array_push($taxargs, $tax_query);
    $args['name']  = $tag;
}else{
    $term_count = get_terms(array(
        'taxonomy' => $taxonomy,
        'fields' => 'count',
    ));
}
$tags       = get_terms($taxonomy, $args);

$grid_syle = [
    '1' => 'col-12 wl-child',
    '2' => 'col-lg-6 col-md-6 col-sm-6 wl-child',
    '3' => 'col-lg-4 col-md-4 col-sm-6 wl-child',
    '4' => 'col-lg-3 col-md-4 col-sm-6 col-6 wl-child',
    '6' => 'col-xl-2 col-lg-3 col-md-4 col-sm-6 col-6 wl-child'
];

$col            = $grid_syle[$settings['grid_style']];
$can_be_loaded  = ($term_count > $terms_per_page) ? true : false;
$total_pages    = ceil(($term_count == 0 ? 1 : $term_count) / ($terms_per_page == 0 ? 1 : $terms_per_page));

$temp_settings = [
    'col'                   => $col,
    'taxonomy'              => $taxonomy,
    'terms_per_page'        => $terms_per_page,
    'link_target'           => $settings['link_target'],
]; ?>

<div class="iq_tags-contents iq-ajax-content streamit_datapass_tags_grid " data-options="<?php echo esc_html($settings['pagination']); ?>" data-can-beloaded="<?php echo esc_attr($can_be_loaded); ?>">
    <div class="iq-main-header">
        <h4 class="iq-title">
            <?php echo esc_html($settings['slider_title']); ?>
        </h4>
    </div>

    <div class="row iq-tag-mainbox list-grid">
        <?php foreach ($tags as $val) {
            if (term_exists($val->term_id))
				require trailingslashit(plugin_dir_path(__FILE__)) . 'template.php';
        } ?>
    </div>

    <?php if ($can_be_loaded && $settings['pagination'] == 'infinite' && $total_pages > 1) {
        echo '<div class="loader-wheel-container"></div>';
    } ?>
</div>

<?php if ($can_be_loaded) { ?>
    <div class="loader-wheel-container">
        <?php if ($settings['pagination'] == 'loadmore' && $total_pages > 1) : ?>
            <div class="<?php echo esc_attr($loadmore_btn); ?>">
                <div class="btn btn-hover iq-button">
                    <span><?php echo !empty($settings['more_text']) ? esc_html($settings['more_text']) : '' ?></span>
                </div>
            </div>
        <?php endif;

        $pagination_args = [
            'action'             => 'loadmore_tags',
            'current_page'       => $current_page,
            'total_pages'        => $total_pages,
            'loadmore_btn'       => $loadmore_btn,
            'loading_text'       => $settings['loading_text'],
            'query_args'         => $args,
            'temp_settings'      => $temp_settings,
            'posts_per_page'     => $terms_per_page,
        ];

        streamit_get_pagination_args($pagination_args); ?>
    </div>
<?php }
