<?php

namespace Iqonic\Elementor\Elements\Tags;

use Elementor\Plugin;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit;

class Widget extends Widget_Base
{

    public function get_name()
    {
        return 'Iq_Tags';
    }

    public function get_title()
    {
        return esc_html__('Tags', 'streamit-extensions');
    }

    public function get_categories()
    {
        return ['streamit-extension'];
    }

    public function get_icon()
    {
        return 'eicon-tags';
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'section_tags',
            [
                'label' => __('Tags', 'streamit-extensions'),
            ]
        );

        $this->add_control(
            'slider_title',
            [
                'label' => __('Title', 'streamit-extensions'),
                'type' => Controls_Manager::TEXT,
                'default' => __('Title', 'streamit-extensions'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'iq_type',
            [
                'label' => __('Select Specific Post', 'streamit-extensions'),
                'type' => Controls_Manager::SELECT,
                'label_block' => true,
                'multiple' => true,
                'options' => [
                    'movie' => __('Movie', 'streamit-extensions'),
                    'tv_show' => __('Tv Show', 'streamit-extensions'),
                    'video' => __('Video', 'streamit-extensions')
                ],
                'default' => 'movie'
            ]
        );

        $this->add_control(
            'iq_type_filter',
            [
                'label' => __('Select List', 'streamit-extensions'),
                'type' => Controls_Manager::SELECT,
                'label_block' => true,
                'multiple' => true,
                'options' => [
                    'all' => __('All', 'streamit-extensions'),
                    'selected' => __('Selected', 'streamit-extensions'),
                ],
                'default' => 'all'
            ]
        );

        $this->add_control(
            'iq_tv_show',
            [
                'label' => __('Display Specific Tv-Show', 'streamit-extensions'),
                'type' => Controls_Manager::SELECT2,
                'label_block' => true,
                'multiple' => true,
                'options' => isset($_REQUEST['editor_post_id']) ? iq_get_custom_taxonomy('tv_show_tag') : [],
                'condition' => ['iq_type' => ['tv_show'], 'iq_type_filter' => 'selected'],
            ]
        );

        $this->add_control(
            'iq_movie',
            [
                'label' => __('Display Specific Movie', 'streamit-extensions'),
                'type' => Controls_Manager::SELECT2,
                'label_block' => true,
                'multiple' => true,
                'options' => isset($_REQUEST['editor_post_id']) ? iq_get_custom_taxonomy('movie_tag') : [],
                'condition' => ['iq_type' => ['movie'], 'iq_type_filter' => 'selected'],
            ]
        );

        $this->add_control(
            'iq_video',
            [
                'label' => __('Display Specific Video', 'streamit-extensions'),
                'type' => Controls_Manager::SELECT2,
                'label_block' => true,
                'multiple' => true,
                'options' => isset($_REQUEST['editor_post_id']) ? iq_get_custom_taxonomy('video_tag') : [],
                'condition' => ['iq_type' => ['video'], 'iq_type_filter' => 'selected'],
            ]
        );

        $this->add_control(
            'grid_style',
            [
                'label' => __('Grid', 'streamit-extensions'),
                'type' => Controls_Manager::SELECT,
                'default' => '4',
                'options' => [
                    '1' => __('One', 'streamit-extensions'),
                    '2' => __('Two', 'streamit-extensions'),
                    '3' => __('Three', 'streamit-extensions'),
                    '4' => __('Four', 'streamit-extensions'),
                    '6' => __('Six', 'streamit-extensions'),
                ],
            ]
        );

        $this->add_control(
            'order',
            [
                'label' => __('Order By', 'streamit-extensions'),
                'type' => Controls_Manager::SELECT,
                'default' => 'ASC',
                'options' => [
                    'DESC' => esc_html__('Descending', 'streamit-extensions'),
                    'ASC' => esc_html__('Ascending', 'streamit-extensions')
                ],
            ]
        );

        $this->add_control(
            'link_target',
            [
                'label' => __('Link Target', 'streamit-extensions'),
                'type' => Controls_Manager::SELECT,
                'default' => '_self',
                'options' => [
                    '_blank' => esc_html__('Blank', 'streamit-extensions'),
                    '_self' => esc_html__('Self', 'streamit-extensions')
                ],
            ]
        );

        $this->add_control(
            'pagination',
            [
                'label' => __('Content Load Type', 'streamit-extensions'),
                'type' => Controls_Manager::SELECT,
                'default' => 'loadmore',
                'label_block' => true,
                'options' => [
                    'loadmore' => esc_html__('Loadmore', 'streamit-extensions'),
                    'infinite' => esc_html__('Infinite Scroll', 'streamit-extensions')
                ],
                'condition' => ['iq_type_filter' => 'all']
            ]
        );

        $this->add_control(
            'more_text',
            [
                'label' => __('Load More button text', 'streamit-extensions'),
                'type' => Controls_Manager::TEXT,
                'default' => __('Load More', 'streamit-extensions'),
                'label_block' => true,
                'condition' => ['pagination' => 'loadmore', 'iq_type_filter' => 'all']
            ]
        );

        $this->add_control(
            'loading_text',
            [
                'label' => __('Loading button text', 'streamit-extensions'),
                'type' => Controls_Manager::TEXT,
                'default' => __('Loading...', 'streamit-extensions'),
                'label_block' => true,
                'condition' => ['pagination' => 'loadmore', 'iq_type_filter' => 'all']
            ]
        );

        $this->add_responsive_control(
            'posts_per_page',
            [
                'label' => __('Posts Per Page', 'streamit-extensions'),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'unit' => '%',
                    'size' => 10,
                ],
                'condition' => ['iq_type_filter' => 'all']
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings();
        require 'render.php';
        if (Plugin::$instance->editor->is_edit_mode()) { ?>
            <script>
                (function(jQuery) {
                    callSlider();
                    tagsAjaxHandler();
                })(jQuery)
            </script>
<?php

        }
    }
}
