<?php

namespace Iqonic\Elementor\Elements\Social_Icons;

use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;

if (!defined('ABSPATH')) exit;
class Widget extends Widget_Base
{
	public function get_name()
	{
		return 'iqonic_social_icons';
	}

	public function get_title()
	{
		return __('Social Icons', 'streamit-extensions');
	}
	public function get_categories()
	{
		return ['iqonic-layouts-extension'];
	}

	public function get_icon()
	{
		return 'eicon-social-icons';
	}

	protected function register_controls()
	{
		$this->start_controls_section(
			'section_social_icon',
			[
				'label' => __('Social Icons', 'streamit-extensions'),
			]
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'social_icon',
			[
				'label' => __('Icon', 'streamit-extensions'),
				'type' => Controls_Manager::ICONS,
				'fa4compatibility' => 'social',
				'default' => [
					'value' => 'fab fa-wordpress',
					'library' => 'fa-brands',
				],
				'recommended' => [
					'fa-brands' => [
						'android',
						'apple',
						'behance',
						'bitbucket',
						'codepen',
						'delicious',
						'deviantart',
						'digg',
						'dribbble',
						'iqonic',
						'facebook',
						'flickr',
						'foursquare',
						'free-code-camp',
						'github',
						'gitlab',
						'globe',
						'houzz',
						'instagram',
						'jsfiddle',
						'linkedin',
						'medium',
						'meetup',
						'mix',
						'mixcloud',
						'odnoklassniki',
						'pinterest',
						'product-hunt',
						'reddit',
						'shopping-cart',
						'skype',
						'slideshare',
						'snapchat',
						'soundcloud',
						'spotify',
						'stack-overflow',
						'steam',
						'telegram',
						'thumb-tack',
						'tripadvisor',
						'tumblr',
						'twitch',
						'twitter',
						'viber',
						'vimeo',
						'vk',
						'weibo',
						'weixin',
						'whatsapp',
						'wordpress',
						'xing',
						'yelp',
						'youtube',
						'500px',
					],
					'fa-solid' => [
						'envelope',
						'link',
						'rss',
					],
				],
			]
		);

		$repeater->add_control(
			'link',
			[
				'label' => __('Link', 'streamit-extensions'),
				'type' => Controls_Manager::URL,
				'default' => [
					'is_external' => 'true',
				],
				'dynamic' => [
					'active' => true,
				],
				'placeholder' => __('https://your-link.com', 'streamit-extensions'),
			]
		);

		$repeater->add_control(
			'social_text',
			[
				'label' => __('Text', 'streamit-extensions'),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'label_block' => true,
			]
		);

		$this->add_control(
			'social_icon_list',
			[
				'label' => __('Social Icons', 'streamit-extensions'),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'social_icon' => [
							'value' => 'fab fa-facebook',
							'library' => 'fa-brands',
						],
						'social_text' => __('Facebook', 'streamit-extensions'),
					],
					[
						'social_icon' => [
							'value' => 'fab fa-twitter',
							'library' => 'fa-brands',
						],
						'social_text' => __('Twitter', 'streamit-extensions'),
					],
					[
						'social_icon' => [
							'value' => 'fab fa-youtube',
							'library' => 'fa-brands',
						],
						'social_text' => __('Youtube', 'streamit-extensions'),
					],
				],
				'title_field' => '<# var migrated = "undefined" !== typeof __fa4_migrated, social = ( "undefined" === typeof social ) ? false : social; #>{{{ elementor.helpers.getSocialNetworkNameFromIcon( social_icon, social, true, migrated, true ) }}}',
			]
		);

		$this->add_control(
			'layout',
			[
				'label' => __('Layout', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT,
				'default' => 'default',
				'options' => [
					'default' => __('Only Icons', 'streamit-extensions'),
					'names' => __('Only Names', 'streamit-extensions'),
					'icons_names' => __('Icon + name', 'streamit-extensions'),
				],
			]
		);

		$this->add_control(
			'position',
			[
				'label' => __('Position', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT,
				'default' => 'horizontal',
				'options' => [
					'horizontal' => __('Horizontal', 'streamit-extensions'),
					'verticle' => __('Verticle', 'streamit-extensions'),
				],
				'prefix_class' => 'iqonic-social-position-',
			]
		);

		$this->add_control(
			'shape',
			[
				'label' => __('Shape', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT,
				'default' => 'rounded',
				'options' => [
					'rounded' => __('Rounded', 'streamit-extensions'),
					'square' => __('Square', 'streamit-extensions'),
					'circle' => __('Circle', 'streamit-extensions'),
				],
				'prefix_class' => 'iqonic-shape-',
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label' => __('Alignment', 'streamit-extensions'),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left'    => [
						'title' => __('Left', 'streamit-extensions'),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => __('Center', 'streamit-extensions'),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => __('Right', 'streamit-extensions'),
						'icon' => 'eicon-text-align-right',
					],
				],
				'prefix_class' => 'e-grid-align-',
				'default' => 'center',
				'selectors' => [
					'{{WRAPPER}} .streamit-socials-share' => 'text-align: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'view',
			[
				'label' => __('View', 'streamit-extensions'),
				'type' => Controls_Manager::HIDDEN,
				'default' => 'traditional',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_social_style',
			[
				'label' => __('Social Icons', 'streamit-extensions'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'social_icon_color',
			[
				'label' => __('Color', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT,
				'default' => 'default',
				'options' => [
					'default' => __('Official Color', 'streamit-extensions'),
					'custom' => __('Custom', 'streamit-extensions'),
				],
			]
		);

		$this->add_control(
			'social_icon_primary_color',
			[
				'label' => __('Primary Color', 'streamit-extensions'),
				'type' => Controls_Manager::COLOR,
				'condition' => [
					'social_icon_color' => 'custom',
				],
				'selectors' => [
					'{{WRAPPER}} .streamit-share' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'social_typography',
				'label' => esc_html__('Name Typography','streamit-extensions'),
				'selector' => '{{WRAPPER}} .streamit-socials-share .streamit-social-item >a',
			]
		);

		$this->add_control(
			'social_icon_secondary_color',
			[
				'label' => __('Secondary Color', 'streamit-extensions'),
				'type' => Controls_Manager::COLOR,
				'condition' => [
					'social_icon_color' => 'custom',
				],
				'selectors' => [
					'{{WRAPPER}} .streamit-share i, {{WRAPPER}} .streamit-share' => 'color: {{VALUE}};',
					'{{WRAPPER}} .streamit-share svg,{{WRAPPER}} .streamit-share svg path' => 'fill: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'icon_container_size',
			[
				'label' => __('Icon container size', 'streamit-extensions'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em' ],
				'range' => [
					'px' => [
						'min' => 6,
						'max' => 300,
					],
				],
				'selectors' => [
					'{{WRAPPER}} ' => '--icon-container-size: {{SIZE}}{{UNIT}}; line-size: {{SIZE}}{{UNIT}}',
					'{{WRAPPER}} .streamit-social-icons-names .streamit-share' => 'width: {{SIZE}}{{UNIT}}',
					'{{WRAPPER}} .streamit-social-icons-names .streamit-share' => 'width: {{SIZE}}{{UNIT}}',
				],
				'condition' => ['layout!' => 'names']
			]
		);

		$this->add_responsive_control(
			'icon_size',
			[
				'label' => __('Icon size', 'streamit-extensions'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em' ],
				'range' => [
					'px' => [
						'min' => 6,
						'max' => 300,
					],
				],
				'selectors' => [
					'{{WRAPPER}} ' => '--icon-size: {{SIZE}}{{UNIT}}; line-size: {{SIZE}}{{UNIT}}',
					'{{WRAPPER}} .streamit-social-icons-names .streamit-share i,{{WRAPPER}} .streamit-social-icons-names .streamit-share svg' => 'width: {{SIZE}}{{UNIT}}',
				],
				'condition' => ['layout!' => 'names']
			]
		);

		$this->add_responsive_control(
			'icon_spacing',
			[
				'label' => __('Spacing', 'streamit-extensions'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'size' => 5,
				],
				'selectors' => [
					'{{WRAPPER}} .streamit-socials-share' => 'word-spacing: {{SIZE}}{{UNIT}}',
				],
			]
		);

		$this->add_responsive_control(
			'row_gap',
			[
				'label' => __('Rows Gap', 'streamit-extensions'),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 0,
				],
				'selectors' => [
					'{{WRAPPER}} .streamit-social-item' => 'margin-bottom: {{SIZE}}{{UNIT}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'image_border', // We know this mistake - TODO: 'icon_border' (for hover control condition also)
				'selector' => '{{WRAPPER}} .streamit-share',
				'separator' => 'before',
			]
		);

		$this->add_control(
			'border_radius',
			[
				'label' => __('Border Radius', 'streamit-extensions'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .streamit-share' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_social_hover',
			[
				'label' => __('Icon Hover', 'streamit-extensions'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'social_hover_primary_color',
			[
				'label' => __('Primary Color', 'streamit-extensions'),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'condition' => [
					'social_icon_color' => 'custom',
				],
				'selectors' => [
					'{{WRAPPER}} .streamit-share:hover' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'social_hover_secondary_color',
			[
				'label' => __('Secondary Color', 'streamit-extensions'),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'condition' => [
					'social_icon_color' => 'custom',
				],
				'selectors' => [
					'{{WRAPPER}} .streamit-share:hover i, {{WRAPPER}} .streamit-share:hover' => 'color: {{VALUE}};',
					'{{WRAPPER}} .streamit-share:hover svg,{{WRAPPER}} .streamit-share:hover svg path' => 'fill: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'social_hover_border_color',
			[
				'label' => __('Border Color', 'streamit-extensions'),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'condition' => [
					'image_border_border!' => '',
				],
				'selectors' => [
					'{{WRAPPER}} .streamit-share:hover' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'hover_animation',
			[
				'label' => __('Hover Animation', 'streamit-extensions'),
				'type' => Controls_Manager::HOVER_ANIMATION,
			]
		);

		$this->end_controls_section();
	}

	protected function render()
	{
		require 'render.php';
	}
}
