<?php

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;

$this->start_controls_section(
    'section_NIfezt7YM7feDaT9vP8J',
    [
        'label' => __('Title Box', 'streamit-extensions'),
        'tab' => Controls_Manager::TAB_STYLE,
    ]
);

$this->start_controls_tabs('titlebox_tabs');
$this->start_controls_tab(
    'tabs_c8fpaelTGDkf951QeYf2',
    [
        'label' => __('Normal', 'streamit-extensions'),
    ]
);

$this->add_group_control(
    Group_Control_Background::get_type(),
    [
        'name' => 'titlebox_background',
        'label' => __('Background', 'streamit-extensions'),
        'types' => ['classic', 'gradient'],
        'selector' => '{{WRAPPER}} .iq-title-box',
    ]
);

$this->add_control(
    'titlebox_has_border',
    [
        'label' => __('Set Custom Border?', 'streamit-extensions'),
        'type' => Controls_Manager::SWITCHER,
        'default' => 'no',
        'yes' => __('yes', 'streamit-extensions'),
        'no' => __('no', 'streamit-extensions'),
    ]
);

$this->add_control(
    'titlebox_border_style',
    [
        'label' => __('Border Style', 'streamit-extensions'),
        'type' => Controls_Manager::SELECT,
        'default' => 'none',
        'condition' => [
            'titlebox_has_border' => 'yes',
        ],
        'options' => [
            'solid'  => __('Solid', 'streamit-extensions'),
            'dashed' => __('Dashed', 'streamit-extensions'),
            'dotted' => __('Dotted', 'streamit-extensions'),
            'double' => __('Double', 'streamit-extensions'),
            'outset' => __('outset', 'streamit-extensions'),
            'groove' => __('groove', 'streamit-extensions'),
            'ridge' => __('ridge', 'streamit-extensions'),
            'inset' => __('inset', 'streamit-extensions'),
            'hidden' => __('hidden', 'streamit-extensions'),
            'none' => __('none', 'streamit-extensions'),

        ],
        'selectors' => [
            '{{WRAPPER}} .iq-title-box ' => 'border-style: {{VALUE}};',
        ],
    ]
);

$this->add_control(
    'titlebox_border_color',
    [
        'label' => __('Border Color', 'streamit-extensions'),
        'condition' => [
            'titlebox_has_border' => 'yes',
        ],
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .iq-title-box' => 'border-color: {{VALUE}};',
        ],
    ]
);

$this->add_control(
    'titlebox_border_width',
    [
        'label' => __('Border Width', 'streamit-extensions'),
        'condition' => [
            'titlebox_has_border' => 'yes',
        ],
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors' => [
            '{{WRAPPER}} .iq-title-box' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$this->add_control(
    'titlebox_border_radius',
    [
        'label' => __('Border Radius', 'streamit-extensions'),
        'condition' => [
            'titlebox_has_border' => 'yes',
        ],
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors' => [
            '{{WRAPPER}} .iq-title-box' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$this->end_controls_tab();

$this->start_controls_tab(
    'tabs_49pcfagYof19beG4w8Ee',
    [
        'label' => __('Hover', 'streamit-extensions'),
    ]
);

$this->add_group_control(
    Group_Control_Background::get_type(),
    [
        'name' => 'titlebox_hover_background',
        'label' => __('Hover Background', 'streamit-extensions'),
        'types' => ['classic', 'gradient'],
        'selector' => '{{WRAPPER}} .iq-title-box:hover ',
    ]
);

$this->add_control(
    'titlebox_hover_has_border',
    [
        'label' => __('Set Custom Border?', 'streamit-extensions'),
        'type' => Controls_Manager::SWITCHER,
        'default' => 'no',
        'yes' => __('yes', 'streamit-extensions'),
        'no' => __('no', 'streamit-extensions'),
    ]
);

$this->add_control(
    'titlebox_hover_border_style',
    [
        'label' => __('Border Style', 'streamit-extensions'),
        'condition' => [
            'titlebox_hover_has_border' => 'yes',
        ],
        'type' => Controls_Manager::SELECT,
        'default' => 'none',
        'options' => [
            'solid'  => __('Solid', 'streamit-extensions'),
            'dashed' => __('Dashed', 'streamit-extensions'),
            'dotted' => __('Dotted', 'streamit-extensions'),
            'double' => __('Double', 'streamit-extensions'),
            'outset' => __('outset', 'streamit-extensions'),
            'groove' => __('groove', 'streamit-extensions'),
            'ridge' => __('ridge', 'streamit-extensions'),
            'inset' => __('inset', 'streamit-extensions'),
            'hidden' => __('hidden', 'streamit-extensions'),
            'none' => __('none', 'streamit-extensions'),
        ],
        'selectors' => [
            '{{WRAPPER}} .iq-title-box:hover' => 'border-style: {{VALUE}};',
        ],
    ]
);

$this->add_control(
    'titlebox_hover_border_color',
    [
        'label' => __('Border Color', 'streamit-extensions'),
        'condition' => [
            'titlebox_hover_has_border' => 'yes',
        ],
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .iq-title-box:hover' => 'border-color: {{VALUE}};',
        ],
    ]
);

$this->add_control(
    'titlebox_hover_border_width',
    [
        'label' => __('Border Width', 'streamit-extensions'),
        'condition' => [
            'titlebox_hover_has_border' => 'yes',
        ],
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors' => [
            '{{WRAPPER}} .iq-title-box:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$this->add_control(
    'titlebox_hover_border_radius',
    [
        'label' => __('Border Radius', 'streamit-extensions'),
        'condition' => [
            'titlebox_hover_has_border' => 'yes',
        ],
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors' => [
            '{{WRAPPER}} .iq-title-box:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$this->end_controls_tab();
$this->end_controls_tabs();

$this->add_responsive_control(
    'titlebox_padding',
    [
        'label' => __('Padding', 'streamit-extensions'),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors' => [
            '{{WRAPPER}}  .iq-title-box' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],

    ]
);

$this->add_responsive_control(
    'titlebox_margin',
    [
        'label' => __('Margin', 'streamit-extensions'),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors' => [
            '{{WRAPPER}}  .iq-title-box' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],

    ]
);

$this->end_controls_section();

$this->start_controls_section(
    'section_f4aS9uHc50Of5eNP8jbc',
    [
        'label' => __('Title', 'streamit-extensions'),
        'tab' => Controls_Manager::TAB_STYLE,
    ]
);

$this->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name' => 'mobile_typography',
        'label' => __('Typography', 'streamit-extensions'),
        'selector' => '{{WRAPPER}} .iq-title-box .iq-title',
    ]
);

$this->start_controls_tabs('title_tabs');

$this->start_controls_tab(
    'title_color_tab_normal',
    [
        'label' => __('normal', 'streamit-extensions'),
    ]
);

$this->add_control(
    'title_normal_color',
    [
        'label' => __('Color', 'streamit-extensions'),
        'type' => Controls_Manager::COLOR,

        'selectors' => [
            '{{WRAPPER}} .iq-title-box .iq-title' => 'color: {{VALUE}};',
        ],
    ]
);

$this->add_group_control(
    Group_Control_Background::get_type(),
    [
        'name' => 'title_back_color',
        'types' => ['classic', 'gradient'],
        'selector' => '{{WRAPPER}} .iq-title-box .iq-title',
    ]
);

$this->add_control(
    'iq_title_has_border',
    [
        'label' => __('Set Custom Border?', 'streamit-extensions'),
        'type' => Controls_Manager::SWITCHER,
        'default' => 'no',
        'yes' => __('yes', 'streamit-extensions'),
        'no' => __('no', 'streamit-extensions'),
    ]
);

$this->add_control(
    'iq_title_border_style',
    [
        'label' => __('Border Style', 'streamit-extensions'),
        'condition' => [
            'iq_title_has_border' => 'yes',
        ],
        'type' => Controls_Manager::SELECT,
        'default' => 'none',
        'options' => [
            'solid'  => __('Solid', 'streamit-extensions'),
            'dashed' => __('Dashed', 'streamit-extensions'),
            'dotted' => __('Dotted', 'streamit-extensions'),
            'double' => __('Double', 'streamit-extensions'),
            'outset' => __('outset', 'streamit-extensions'),
            'groove' => __('groove', 'streamit-extensions'),
            'ridge' => __('ridge', 'streamit-extensions'),
            'inset' => __('inset', 'streamit-extensions'),
            'hidden' => __('hidden', 'streamit-extensions'),
            'none' => __('none', 'streamit-extensions'),
        ],
        'selectors' => [
            '{{WRAPPER}} .iq-title-box .iq-title' => 'border-style: {{VALUE}};',
        ],
    ]
);

$this->add_control(
    'iq_title_border_color',
    [
        'label' => __('Border Color', 'streamit-extensions'),
        'condition' => [
            'iq_title_has_border' => 'yes',
        ],
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}}  .iq-title-box .iq-title' => 'border-color: {{VALUE}};',
        ],
    ]
);

$this->add_control(
    'iq_title_border_width',
    [
        'label' => __('Border Width', 'streamit-extensions'),
        'condition' => [
            'iq_title_has_border' => 'yes',
        ],
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors' => [
            '{{WRAPPER}}  .iq-title-box .iq-title' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$this->add_control(
    'iq_title_border_radius',
    [
        'label' => __('Border Radius', 'streamit-extensions'),
        'condition' => [
            'iq_title_has_border' => 'yes',
        ],
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors' => [
            '{{WRAPPER}}  .iq-title-box .iq-title' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$this->end_controls_tab();

$this->start_controls_tab(
    'title_color_tab_hover',
    [
        'label' => __('Hover', 'streamit-extensions'),
    ]
);

$this->add_control(
    'title_hover_color',
    [
        'label' => __('Color', 'streamit-extensions'),
        'type' => Controls_Manager::COLOR,

        'selectors' => [
            '{{WRAPPER}} .iq-title-box .iq-title:hover' => 'color: {{VALUE}};',
        ],
    ]
);

$this->add_group_control(
    Group_Control_Background::get_type(),
    [
        'name' => 'title_hover_back_color',
        'types' => ['classic', 'gradient'],
        'selector' => '{{WRAPPER}} .iq-title-box:hover .iq-title',
    ]
);

$this->add_control(
    'iq_title_hover_has_border',
    [
        'label' => __('Set Custom Border?', 'streamit-extensions'),
        'type' => Controls_Manager::SWITCHER,
        'default' => 'no',
        'yes' => __('yes', 'streamit-extensions'),
        'no' => __('no', 'streamit-extensions'),
    ]
);

$this->add_control(
    'iq_title_hover_border_style',
    [
        'label' => __('Border Style', 'streamit-extensions'),
        'condition' => [
            'iq_title_hover_has_border' => 'yes',
        ],
        'type' => Controls_Manager::SELECT,
        'default' => 'none',
        'options' => [
            'solid'  => __('Solid', 'streamit-extensions'),
            'dashed' => __('Dashed', 'streamit-extensions'),
            'dotted' => __('Dotted', 'streamit-extensions'),
            'double' => __('Double', 'streamit-extensions'),
            'outset' => __('outset', 'streamit-extensions'),
            'groove' => __('groove', 'streamit-extensions'),
            'ridge' => __('ridge', 'streamit-extensions'),
            'inset' => __('inset', 'streamit-extensions'),
            'hidden' => __('hidden', 'streamit-extensions'),
            'none' => __('none', 'streamit-extensions'),
        ],
        'selectors' => [
            '{{WRAPPER}} .iq-title-box:hover .iq-title' => 'border-style: {{VALUE}};',
        ],
    ]
);

$this->add_control(
    'iq_title_hover_border_color',
    [
        'label' => __('Border Color', 'streamit-extensions'),
        'condition' => [
            'iq_title_hover_has_border' => 'yes',
        ],
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}}  .iq-title-box:hover .iq-title' => 'border-color: {{VALUE}};',
        ],
    ]
);

$this->add_control(
    'iq_title_hover_border_width',
    [
        'label' => __('Border Width', 'streamit-extensions'),
        'condition' => [
            'iq_title_hover_has_border' => 'yes',
        ],
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors' => [
            '{{WRAPPER}}  .iq-title-box:hover .iq-title' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$this->add_control(
    'iq_title_hover_border_radius',
    [
        'label' => __('Border Radius', 'streamit-extensions'),
        'condition' => [
            'iq_title_hover_has_border' => 'yes',
        ],
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors' => [
            '{{WRAPPER}}  .iq-title-box:hover .iq-title' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$this->end_controls_tab();
$this->end_controls_tabs();

$this->add_responsive_control(
    'title_margin',
    [
        'label' => __('Margin', 'streamit-extensions'),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors' => [
            '{{WRAPPER}} .iq-title-box .iq-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$this->add_responsive_control(
    'title_padding',
    [
        'label' => __('Padding', 'streamit-extensions'),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors' => [
            '{{WRAPPER}} .iq-title-box .iq-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);
$this->end_controls_section();

$this->start_controls_section(
    'section_sub_title__',
    [
        'label' => __('Sub Title', 'streamit-extensions'),
        'tab' => Controls_Manager::TAB_STYLE,
        'condition' => ['has_sub_title' => 'yes']
    ]
);

$this->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name' => 'sub_title_typography',
        'label' => __('Typography', 'streamit-extensions'),
        'selector' => '{{WRAPPER}} .iq-title-box .iq-sub-title',
    ]
);

$this->start_controls_tabs('sub_title_tabs');

$this->start_controls_tab(
    'sub_title_color_tab_normal',
    [
        'label' => __('normal', 'streamit-extensions'),
    ]
);

$this->add_control(
    'sub_title_normal_color',
    [
        'label' => __('Color', 'streamit-extensions'),
        'type' => Controls_Manager::COLOR,

        'selectors' => [
            '{{WRAPPER}} .iq-title-box .iq-sub-title' => 'color: {{VALUE}};',
        ],
    ]
);

$this->add_group_control(
    Group_Control_Background::get_type(),
    [
        'name' => 'sub_title_back_color',
        'types' => ['classic', 'gradient'],
        'selector' => '{{WRAPPER}} .iq-title-box .iq-sub-title',
    ]
);

$this->add_control(
    'iq_sub_title_has_border',
    [
        'label' => __('Set Custom Border?', 'streamit-extensions'),
        'type' => Controls_Manager::SWITCHER,
        'default' => 'no',
        'yes' => __('yes', 'streamit-extensions'),
        'no' => __('no', 'streamit-extensions'),
    ]
);

$this->add_control(
    'iq_sub_title_border_style',
    [
        'label' => __('Border Style', 'streamit-extensions'),
        'condition' => [
            'iq_sub_title_has_border' => 'yes',
        ],
        'type' => Controls_Manager::SELECT,
        'default' => 'none',
        'options' => [
            'solid'  => __('Solid', 'streamit-extensions'),
            'dashed' => __('Dashed', 'streamit-extensions'),
            'dotted' => __('Dotted', 'streamit-extensions'),
            'double' => __('Double', 'streamit-extensions'),
            'outset' => __('outset', 'streamit-extensions'),
            'groove' => __('groove', 'streamit-extensions'),
            'ridge' => __('ridge', 'streamit-extensions'),
            'inset' => __('inset', 'streamit-extensions'),
            'hidden' => __('hidden', 'streamit-extensions'),
            'none' => __('none', 'streamit-extensions'),
        ],
        'selectors' => [
            '{{WRAPPER}} .iq-title-box .iq-sub-title' => 'border-style: {{VALUE}};',
        ],
    ]
);

$this->add_control(
    'iq_sub_title_border_color',
    [
        'label' => __('Border Color', 'streamit-extensions'),
        'condition' => [
            'iq_sub_title_has_border' => 'yes',
        ],
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}}  .iq-title-box .iq-sub-title' => 'border-color: {{VALUE}};',
        ],
    ]
);

$this->add_control(
    'iq_sub_title_border_width',
    [
        'label' => __('Border Width', 'streamit-extensions'),
        'condition' => [
            'iq_sub_title_has_border' => 'yes',
        ],
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors' => [
            '{{WRAPPER}}  .iq-title-box .iq-sub-title' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$this->add_control(
    'iq_sub_title_border_radius',
    [
        'label' => __('Border Radius', 'streamit-extensions'),
        'condition' => [
            'iq_sub_title_has_border' => 'yes',
        ],
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors' => [
            '{{WRAPPER}}  .iq-title-box .iq-sub-title' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$this->end_controls_tab();

$this->start_controls_tab(
    'sub_title_color_tab_hover',
    [
        'label' => __('Hover', 'streamit-extensions'),
    ]
);

$this->add_control(
    'sub_title_hover_color',
    [
        'label' => __('Color', 'streamit-extensions'),
        'type' => Controls_Manager::COLOR,

        'selectors' => [
            '{{WRAPPER}} .iq-title-box .iq-sub-title:hover' => 'color: {{VALUE}};',
        ],
    ]
);

$this->add_group_control(
    Group_Control_Background::get_type(),
    [
        'name' => 'sub_title_hover_back_color',
        'types' => ['classic', 'gradient'],
        'selector' => '{{WRAPPER}} .iq-title-box:hover .iq-sub-title',
    ]
);

$this->add_control(
    'iq_sub_title_hover_has_border',
    [
        'label' => __('Set Custom Border?', 'streamit-extensions'),
        'type' => Controls_Manager::SWITCHER,
        'default' => 'no',
        'yes' => __('yes', 'streamit-extensions'),
        'no' => __('no', 'streamit-extensions'),
    ]
);

$this->add_control(
    'iq_sub_title_hover_border_style',
    [
        'label' => __('Border Style', 'streamit-extensions'),
        'condition' => [
            'iq_sub_title_hover_has_border' => 'yes',
        ],
        'type' => Controls_Manager::SELECT,
        'default' => 'none',
        'options' => [
            'solid'  => __('Solid', 'streamit-extensions'),
            'dashed' => __('Dashed', 'streamit-extensions'),
            'dotted' => __('Dotted', 'streamit-extensions'),
            'double' => __('Double', 'streamit-extensions'),
            'outset' => __('outset', 'streamit-extensions'),
            'groove' => __('groove', 'streamit-extensions'),
            'ridge' => __('ridge', 'streamit-extensions'),
            'inset' => __('inset', 'streamit-extensions'),
            'hidden' => __('hidden', 'streamit-extensions'),
            'none' => __('none', 'streamit-extensions'),
        ],
        'selectors' => [
            '{{WRAPPER}} .iq-title-box:hover .iq-sub-title' => 'border-style: {{VALUE}};',
        ],
    ]
);

$this->add_control(
    'iq_sub_title_hover_border_color',
    [
        'label' => __('Border Color', 'streamit-extensions'),
        'condition' => [
            'iq_sub_title_hover_has_border' => 'yes',
        ],
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}}  .iq-title-box:hover .iq-sub-title' => 'border-color: {{VALUE}};',
        ],
    ]
);

$this->add_control(
    'iq_sub_title_hover_border_width',
    [
        'label' => __('Border Width', 'streamit-extensions'),
        'condition' => [
            'iq_sub_title_hover_has_border' => 'yes',
        ],
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors' => [
            '{{WRAPPER}}  .iq-title-box:hover .iq-sub-title' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$this->add_control(
    'iq_sub_title_hover_border_radius',
    [
        'label' => __('Border Radius', 'streamit-extensions'),
        'condition' => [
            'iq_sub_title_hover_has_border' => 'yes',
        ],
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors' => [
            '{{WRAPPER}}  .iq-title-box:hover .iq-sub-title' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$this->end_controls_tab();
$this->end_controls_tabs();

$this->add_responsive_control(
    'sub_title_margin',
    [
        'label' => __('Margin', 'streamit-extensions'),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors' => [
            '{{WRAPPER}} .iq-title-box .iq-sub-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$this->add_responsive_control(
    'sub_title_padding',
    [
        'label' => __('Padding', 'streamit-extensions'),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors' => [
            '{{WRAPPER}} .iq-title-box .iq-sub-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);
$this->end_controls_section();

$this->start_controls_section(
    'section_ZcASngaa14lc8er55aND',
    [
        'label' => __('Description', 'streamit-extensions'),
        'tab' => Controls_Manager::TAB_STYLE,
        'condition' => ['has_description' => 'yes']
    ]
);

$this->add_control(
    'description_heading_color',
    [
        'label' => __('Color', 'streamit-extensions'),
        'type' => Controls_Manager::HEADING,
        'separator' => 'before',
    ]
);

$this->start_controls_tabs('description_tabs');
$this->start_controls_tab(
    'description_color_tab_normal',
    [
        'label' => __('normal', 'streamit-extensions'),
    ]
);

$this->add_control(
    'description_normal_color',
    [
        'label' => __('Color', 'streamit-extensions'),
        'type' => Controls_Manager::COLOR,

        'selectors' => [
            '{{WRAPPER}} .iq-title-box .iq-title-desc' => 'color: {{VALUE}};',
        ],
    ]
);

$this->end_controls_tab();

$this->start_controls_tab(
    'description_color_tab_hover',
    [
        'label' => __('Hover', 'streamit-extensions'),
    ]
);

$this->add_control(
    'description_hover_color',
    [
        'label' => __('Color', 'streamit-extensions'),
        'type' => Controls_Manager::COLOR,

        'selectors' => [
            '{{WRAPPER}} .iq-title-box .iq-title-desc:hover' => 'color: {{VALUE}};',
        ],
    ]
);

$this->end_controls_tab();
$this->end_controls_tabs();

$this->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name' => 'description_typography',
        'label' => __('Typography', 'streamit-extensions'),
        'selector' => '{{WRAPPER}} .iq-title-box .iq-title-desc',
    ]
);

$this->add_responsive_control(
    'desciption_marging',
    [
        'label' => __('Margin', 'streamit-extensions'),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors' => [
            '{{WRAPPER}} .iq-title-box .iq-title-desc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$this->add_responsive_control(
    'desciption_padding',
    [
        'label' => __('Padding', 'streamit-extensions'),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors' => [
            '{{WRAPPER}} .iq-title-box .iq-title-desc' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);
$this->end_controls_section();
