<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;

$settings = $this->get_settings();

$align = !empty($settings['align']) ? $settings['align'] : 'text-left';

$this->add_render_attribute('iq-section', 'class', $align);
$this->add_render_attribute('iq-section', 'class', 'iq-title-box');

if ($settings['title_style'] == 'big-title' &&  !empty($settings['title_image']['url'])) {
	$this->add_render_attribute('iq-section', 'style', 'background-image:url(' . $settings['title_image']['url'] . ')');
}
$this->add_render_attribute('iq-section', 'class', $settings['title_style']); ?>

<div <?php echo $this->get_render_attribute_string('iq-section'); ?>>


	<<?php echo $settings['title_tag'];  ?> class="iq-title">
		<?php echo wp_kses(__($settings['section_title']), 'post'); ?>
	</<?php echo $settings['title_tag']; ?>>

	<?php if ($settings['has_sub_title'] == 'yes') { ?>
		<span class="iq-sub-title">
			<?php echo $settings['section_sub_title']; ?>
		</span>
	<?php } ?>

	<?php if (!empty($settings['description']) && $settings['has_description'] == 'yes') {
		echo sprintf('<p class="iq-title-desc">%1$s</p>', $this->parse_text_editor($settings['description']));
	} ?>
</div>