<?php

namespace Iqonic\Elementor\Elements\Section_Title;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit;

class Widget extends Widget_Base
{
	public function get_name()
	{
		return 'section_title';
	}

	public function get_title()
	{
		return esc_html__('Section Title', 'streamit-extensions');
	}

	public function get_categories()
	{
		return ['streamit-extension'];
	}

	public function get_icon()
	{
		return 'eicon-site-title';
	}

	protected function register_controls()
	{
		$this->start_controls_section(
			'section',
			[
				'label' => __('Section Title', 'streamit-extensions'),
			]
		);

		$this->add_control(
			'section_title',
			[
				'label' => __('Section Title', 'streamit-extensions'),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'label_block' => true,
				'default' => __('Section Title', 'streamit-extensions'),
			]
		);

		$this->add_control(
			'has_sub_title',
			[
				'label' => __('Has Sub Title?', 'streamit-extensions'),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'no',
				'yes' => __('yes', 'streamit-extensions'),
				'no' => __('no', 'streamit-extensions'),
			]
		);

		$this->add_control(
			'section_sub_title',
			[
				'label' => __('Section Sub Title', 'streamit-extensions'),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => __('Section Sub Title', 'streamit-extensions'),
				'condition' => ['has_sub_title'=>'yes'],
			]
		);

		$this->add_control(
			'has_description',
			[
				'label' => __('Has Description?', 'streamit-extensions'),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'no',
				'yes' => __('yes', 'streamit-extensions'),
				'no' => __('no', 'streamit-extensions'),
			]
		);

		$this->add_control(
			'description',
			[
				'label' => __('Description', 'streamit-extensions'),
				'type' => Controls_Manager::TEXTAREA,
				'dynamic' => [
					'active' => true,
				],
				'placeholder' => __('Enter Title Description', 'streamit-extensions'),
				'default' => __('Lorem Ipsum is simply dummy text of the printing and typesetting industry.', 'streamit-extensions'),
				'condition' => ['has_description' => 'yes']
			]
		);

		$this->add_control(
			'title_style',
			[
				'label'      => __('Title Style', 'streamit-extensions'),
				'type'       => Controls_Manager::SELECT,
				'default'    => 'iq-title-default',
				'options'    => [
					'iq-title-default'          => __('Default', 'streamit-extensions'),
					'iq-title-white'          => __('White', 'streamit-extensions'),
					'big-title'          => __('Big Texture', 'streamit-extensions'),
				],
			]
		);

		$this->add_control(
			'title_image',
			[
				'label' => esc_html__('Choose Title Image', 'streamit-extensions'),
				'type' => Controls_Manager::MEDIA,
				'condition' => ['title_style' => 'big-title']
			]
		);

		$this->add_control(
			'title_tag',
			[
				'label'      => __('Title Tag', 'streamit-extensions'),
				'type'       => Controls_Manager::SELECT,
				'default'    => 'h4',
				'options'    => [
					'h1'          => __('h1', 'streamit-extensions'),
					'h2'          => __('h2', 'streamit-extensions'),
					'h3'          => __('h3', 'streamit-extensions'),
					'h4'          => __('h4', 'streamit-extensions'),
					'h5'          => __('h5', 'streamit-extensions'),
					'h6'          => __('h6', 'streamit-extensions'),
				],
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label' => __('Alignment', 'streamit-extensions'),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'text-left' => [
						'title' => __('Left', 'streamit-extensions'),
						'icon' => 'eicon-text-align-left',
					],
					'text-center' => [
						'title' => __('Center', 'streamit-extensions'),
						'icon' => 'eicon-text-align-center',
					],
					'text-right' => [
						'title' => __('Right', 'streamit-extensions'),
						'icon' => 'eicon-text-align-right',
					]
				]
			]
		);

		$this->end_controls_section();

		require 'style.php';
	}

	protected function render()
	{
		require 'render.php';
	}
}
