<?php

use Elementor\Controls_Manager;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Typography;

$this->start_controls_section(
    'section_icon_style',
    [
        'label' => __('Icon', 'streamit-extensions'),
        'tab' => Controls_Manager::TAB_STYLE,
        'condition' => ['layout' => 'modern'],
    ]
);

$this->start_controls_tabs('icon_tabs');
$this->start_controls_tab(
    'tabs_search_icon_style_normal',
    [
        'label' => __('Normal', 'streamit-extensions'),
    ]
);

$this->add_control(
    'icon_color',
    [
        'label' => __('Choose color <br> <span style="color: #5bc0de"> (Note : working only for icon) </span>', 'streamit-extensions'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .search_count .btn-search i ,{{WRAPPER}} .search_count .btn-search svg , {{WRAPPER}} .search_count .btn-search svg path' => 'fill: {{VALUE}}; color: {{VALUE}};'
        ],
    ]
);

$this->end_controls_tab();

$this->start_controls_tab(
    'tabs_search_icon_style_hover',
    [
        'label' => __('Hover', 'streamit-extensions'),
    ]
);

$this->add_control(
    'icon_hover_color',
    [
        'label' => __('Choose color <br> <span style="color: #5bc0de"> (Note : working only for icon) </span>', 'streamit-extensions'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .search_count .btn-search:hover svg , {{WRAPPER}} .search_count .btn-search:hover i' => 'fill: {{VALUE}}; color: {{VALUE}};',
        ],
    ]
);

$this->end_controls_tab();
$this->end_controls_tabs();

$this->add_responsive_control(
    'icon_size',
    [
        'label' => __('Icon Size', 'streamit-extensions'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', 'em', '%'],
        'range' => [
            'px' => [
                'min' => 0,
                'max' => 1000,
                'step' => 5,
            ],
            '%' => [
                'min' => 0,
                'max' => 100,
            ],
        ],
        'selectors' => [
            '{{WRAPPER}} .search_count .btn-search svg , {{WRAPPER}} .search_count .btn-search i' => 'font-size: {{SIZE}}{{UNIT}};',
        ],
    ]
);

$this->add_responsive_control(
    'icon_width',
    [
        'label' => __('Width', 'streamit-extensions'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', 'em', '%'],
        'range' => [
            'px' => [
                'min' => 0,
                'max' => 1000,
                'step' => 5,
            ],
            '%' => [
                'min' => 0,
                'max' => 100,
            ],
        ],
        'selectors' => [
            '{{WRAPPER}} .search_count .btn-search svg , {{WRAPPER}} .search_count .btn-search i' => 'width: {{SIZE}}{{UNIT}};',
        ],
    ]
);

$this->add_responsive_control(
    'icon_height',
    [
        'label' => __('Height', 'streamit-extensions'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', 'em', '%'],
        'range' => [
            'px' => [
                'min' => 0,
                'max' => 1000,
                'step' => 5,
            ],
            '%' => [
                'min' => 0,
                'max' => 100,
            ],
        ],
        'selectors' => [
            '{{WRAPPER}} .search_count .btn-search svg , {{WRAPPER}} .search_count .btn-search i' => 'height: {{SIZE}}{{UNIT}};line-height: {{SIZE}}{{UNIT}};',
        ],
    ]
);

$this->end_controls_section();

$this->start_controls_section(
    'section_search_title_style',
    [
        'label' => __('Title', 'streamit-extensions'),
        'tab' => Controls_Manager::TAB_STYLE,
        'condition' => ['layout' => 'modern', 'use_search_Text' => 'yes'],
    ]
);

$this->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name' => 'search_typography',
        'label' => __('Typography', 'streamit-extensions'),
        'selector' => '{{WRAPPER}} .search-text',
    ]
);

$this->start_controls_tabs('title_tabs');

$this->start_controls_tab(
    'title_color_tab_normal',
    [
        'label' => __('Normal', 'streamit-extensions'),
    ]
);

$this->add_control(
    'title_normal_color',
    [
        'label' => __('Color', 'streamit-extensions'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .search-text' => 'color: {{VALUE}};',
        ],
    ]
);
$this->end_controls_tab();

$this->start_controls_tab(
    'title_color_tab_hover',
    [
        'label' => __('Hover', 'streamit-extensions'),
    ]
);

$this->add_control(
    'title_hover_color',
    [
        'label' => __('Color', 'streamit-extensions'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .btn-search:hover .search-text' => 'color: {{VALUE}};',
        ],
    ]
);
$this->end_controls_tab();
$this->end_controls_tabs();
$this->end_controls_section();

$this->start_controls_section(
    'section_modern_style',
    [
        'label' => __('Modern', 'streamit-extensions'),
        'tab' => Controls_Manager::TAB_STYLE,
        'condition' => ['layout' => 'modern'],
    ]
);

$this->add_control(
    'modern_icon_color',
    [
        'label' => __('Icon Color', 'streamit-extensions'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .search-form .search-submit svg,{{WRAPPER}} .search-form .search-submit i,{{WRAPPER}} button.btn-search-close svg, {{WRAPPER}} button.btn-search-close i' => 'color: {{VALUE}};',
            '{{WRAPPER}} .search__form::after' => 'background-color: {{VALUE}};',
        ],
    ]
);

$this->add_control(
    'modern_text_color',
    [
        'label' => __('Text Color', 'streamit-extensions'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .search-form input' => 'color: {{VALUE}};',
        ],
    ]
);

$this->add_control(
    'modern_placeholder_color',
    [
        'label' => __('Placeholder Color', 'streamit-extensions'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .search_wrap .search-form input::placeholder' => 'color: {{VALUE}};',
        ],
    ]
);

$this->add_group_control(
    Group_Control_Background::get_type(),
    [
        'name' => 'data_background',
        'label' => __('Background', 'streamit-extensions'),
        'types' => ['classic', 'gradient'],
        'selector' => '{{WRAPPER}} .search',
    ]
);

$this->end_controls_section();

$this->start_controls_section(
    'section_search_box_style',
    [
        'label' => __('Search Box', 'streamit-extensions'),
        'tab' => Controls_Manager::TAB_STYLE,
        'condition' => ['layout' => 'default'],
    ]
);

$this->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name' => 'search_text_typography',
        'label' => __('Search text typography', 'streamit-extensions'),
        'selector' => '{{WRAPPER}} .search-form-default .search_form_wrap .search-form .form-search .search__input',
    ]
);

$this->add_control(
    'default_text_color',
    [
        'label' => __('Text Color', 'streamit-extensions'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .search__form input' => 'color: {{VALUE}};',
        ],
    ]
);

$this->add_control(
    'default_placeholder_color',
    [
        'label' => __('Placeholder Color', 'streamit-extensions'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .search__form input::placeholder' => 'color: {{VALUE}} !important',
        ],
    ]
);

$this->add_group_control(
    Group_Control_Background::get_type(),
    [
        'name' => 'default_data_background',
        'label' => __('Background', 'streamit-extensions'),
        'types' => ['classic', 'gradient'],
        'selector' => '{{WRAPPER}} .search_wrap.search-form-default .search-form input',
    ]
);

$this->add_control(
    'searchbox_padding',
    [
        'label' => __('Padding', 'streamit-extensions'),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', 'em', '%'],
        'selectors' => [
            '{{WRAPPER}}  .search_wrap.search-form-default .search_form_wrap .form-search input' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$this->add_control(
    'searchbox_border_style',
    [
        'label' => __('Border Style', 'streamit-extensions'),
        'type' => Controls_Manager::SELECT,
        'default' => 'solid',
        'options' => [
            'solid'  => __('Solid', 'streamit-extensions'),
            'dashed' => __('Dashed', 'streamit-extensions'),
            'dotted' => __('Dotted', 'streamit-extensions'),
            'double' => __('Double', 'streamit-extensions'),
            'outset' => __('outset', 'streamit-extensions'),
            'groove' => __('groove', 'streamit-extensions'),
            'ridge' => __('ridge', 'streamit-extensions'),
            'inset' => __('inset', 'streamit-extensions'),
            'hidden' => __('hidden', 'streamit-extensions'),
            'none' => __('none', 'streamit-extensions'),
        ],
        'selectors' => [
            '{{WRAPPER}} .search_wrap.search-form-default .search_form_wrap .form-search input' => 'border-style: {{VALUE}} !important;',
        ],
    ]
);

$this->add_control(
    'searchbox_border_color',
    [
        'label' => __('Border Color', 'streamit-extensions'),
        'condition' => [
            'searchbox_border_style!' => 'none',
        ],
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .search_wrap.search-form-default .search_form_wrap .form-search input' => 'border-color: {{VALUE}} !important;',
        ],
    ]
);

$this->add_control(
    'searchbox_border_width',
    [
        'label' => __('Border Width', 'streamit-extensions'),
        'condition' => [
            'searchbox_border_style!' => 'none',
        ],
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', 'em', '%'],
        'selectors' => [
            '{{WRAPPER}} .search_wrap.search-form-default .search_form_wrap .form-search input' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
        ],
    ]
);

$this->add_control(
    'searchbox_border_radius',
    [
        'label' => __('Border Radius', 'streamit-extensions'),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', 'em', '%'],
        'selectors' => [
            '{{WRAPPER}} .search_wrap.search-form-default .search_form_wrap .form-search input' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$this->end_controls_section();

$this->start_controls_section(
    'section_search_box_btn',
    [
        'label' => __('Search Button', 'streamit-extensions'),
        'tab' => Controls_Manager::TAB_STYLE,
        'condition' => ['layout' => 'default'],
    ]
);

$this->add_control(
    'default_icon_color',
    [
        'label' => __('Icon Color', 'streamit-extensions'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .search_wrap.search-form-default .search-form .search-submit svg,{{WRAPPER}} .search_wrap.search-form-default .search-form .search-submit svg path,{{WRAPPER}} .search_wrap.search-form-default .search-form .search-submit i' => 'color: {{VALUE}};fill: {{VALUE}};',
        ],
    ]
);

$this->add_control(
    'default_icon_bg_color',
    [
        'label' => __('Button Bg Color', 'streamit-extensions'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .search_wrap.search-form-default .search-form .search-submit ' => 'background-color:{{VALUE}}',
        ],
    ]
);

$this->add_control(
    'btn-size',
    [
        'label' => esc_html__('Button Size', 'streamit-extensions'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em'],
        'range' => [
            'px' => [
                'min' => 0,
                'max' => 500,
                'step' => 1,
            ],
            '%' => [
                'min' => 0,
                'max' => 100,
            ],
            'em' => [
                'min' => 0,
                'max' => 100,
            ],
        ],
        'default' => [
            'unit' => 'px',
            'size' => 50,
        ],
        'selectors' => [
            '{{WRAPPER}} .search_wrap.search-form-default .search_form_wrap .form-search button' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
        ],
    ]
);

$this->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name' => 'search_btn_typography',
        'label' => __('Search Button Yypography', 'streamit-extensions'),
        'selector' => '{{WRAPPER}} .search-form-default .search_form_wrap .search-form .form-search .search-submit',
    ]
);

$this->end_controls_section();
