<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;

$post_type = '';
$unique_id = esc_html(uniqid('search-form-'));

$settings = $this->get_settings();

$form = $settings['layout'] == 'default' ? 'search-form-default' : '';

?>

<div class="search_wrap <?php echo esc_attr($form) ?> search_style_<?php echo esc_attr($settings['style']); ?> search-animate-<?php echo esc_attr($settings['type_animation']); ?>">
    <div class="search_form_wrap">
        <?php if ($settings['layout'] == 'modern') { ?>
            <div class="search_count">
                <a href="javascript:void(0);" class="btn-search">
                    <?php if ($settings['use_search_Text'] == 'yes' && $settings['use_search_position'] == 'before' && !empty($settings['search_text'])) {
                        echo '<span class="search-text">' . esc_html($settings['search_text']) . '</span>';
                    }
                    if ($settings['show_search_icon'] == "yes") {
                        Icons_Manager::render_icon($settings['search_icon'], ['aria-hidden' => 'true']);
                    }

                    if ($settings['use_search_Text'] == 'yes' && $settings['use_search_position'] == 'after' && !empty($settings['search_text'])) {
                        echo '<span class="search-text">' . esc_html($settings['search_text']) . '</span>';
                    } ?>
                </a>

                <div class="streamit-search">
                    <button class="btn btn-search-close btn--search-close" aria-label="Close search form">
                        <i class="fa fa-times"></i>
                    </button>

                    <form method="get" class="search-form search__form" id="searchform" action="<?php echo esc_url(home_url('/')); ?>">
                        <div class="form-search">
                            <input type="search" id="wp-block-search__input-1" class="search-field search__input" name="s" value="<?php echo get_search_query(); ?>" placeholder=" <?php echo esc_attr($settings['search_placeholder']); ?>" />
                            <button type="submit" class="search-submit"><i class="fa fa-search" aria-hidden="true"></i></button>
                        </div>
                    </form>
                </div>
            </div>
        <?php } else { ?>
            <form method="get" class="search-form search__form" id="searchform" action="<?php echo esc_url(home_url('/')); ?>">
                <div class="form-search align-<?php echo  esc_attr($settings['align']); ?>">
                    <input type="search" id="wp-block-search__input-1" class="search-field search__input" name="s" value="<?php echo get_search_query(); ?>" placeholder=" <?php echo esc_attr($settings['search_placeholder']); ?>" />
                    <?php if (isset($settings['post_types']) && !empty($settings['post_types'])) {
                        if (in_array($settings['post_types'], array('movie', 'tv_show', 'episode', 'video'))) { ?>
                            <input type="hidden" name="ajax_search" value="true" />
                        <?php } ?>
                        <input type="hidden" name="post_type" value="<?php echo esc_html($settings['post_types']); ?>" />
                    <?php } ?>

                    <button type="submit" class="search-submit">
                        <?php if ($settings['show_search_icon'] == "yes") {
                            Icons_Manager::render_icon($settings['search_icon'], ['aria-hidden' => 'true']);
                        } ?>
                    </button>
                </div>
            </form>
        <?php } ?>
    </div>
</div>