<?php

namespace Iqonic\Elementor\Elements\Search;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit;

class Widget extends Widget_Base
{
    public function get_name()
    {
        return 'iqonic_search';
    }

    public function get_title()
    {
        return __('Layouts: Search', 'streamit-extensions');
    }

    public function get_categories()
    {
        return ['iqonic-layouts-extension'];
    }

    public function get_icon()
    {
        return 'eicon-search';
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'section_iqonic_layouts_search',
            [
                'label' => __('Layouts: Search', 'streamit-extensions'),
            ]
        );

        $this->add_control(
            'layout',
            [
                'label'      => __('Layout', 'streamit-extensions'),
                'type'       => Controls_Manager::SELECT,
                'default'    => 'default',
                'options'    => [
                    'default'   => __('Default', 'streamit-extensions'),
                    'modern'    => __('Modern', 'streamit-extensions'),
                ],
            ]
        );

        $this->add_control(
            'use_search_Text',
            [
                'label'      => __('Use Search Text', 'streamit-extensions'),
                'type'       => Controls_Manager::SELECT,
                'default'    => 'yes',
                'options'    => [
                    'yes'   => __('Yes', 'streamit-extensions'),
                    'no'    => __('No', 'streamit-extensions'),
                ],
                'condition' => ['layout' => 'modern']
            ]
        );

        $this->add_control(
            'use_search_position',
            [
                'label'      => __('Text Position', 'streamit-extensions'),
                'type'       => Controls_Manager::SELECT,
                'default'    => 'after',
                'options'    => [
                    'before'   => __('Before Icon', 'streamit-extensions'),
                    'after'    => __('After Icon', 'streamit-extensions'),
                ],
                'condition' => [
                    'layout' => 'modern',
                    'use_search_Text' => 'yes'
                ],
            ]
        );

        $this->add_control(
            'search_text',
            [
                'label' => __('Search Text', 'streamit-extensions'),
                'type' => Controls_Manager::TEXT,
                'label_block' => false,
                'default' => __('Search', 'streamit-extensions'),
                'condition' => [
                    'layout' => 'modern',
                    'use_search_Text' => 'yes'
                ],
            ]
        );

        $this->add_control(
            'search_placeholder',
            [
                'label' => __('Placeholder', 'streamit-extensions'),
                'type' => Controls_Manager::TEXT,
                'label_block' => false,
                'default' => __('Search Website', 'streamit-extensions'),
                'condition' => [
                    'use_search_Text' => 'yes'
                ],
                'condition' => [
                    'layout' => 'default',
                ],
            ]
        );

        $this->add_responsive_control(
            'align',
            [
                'label' => __('Alignment', 'streamit-extensions'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __('Left', 'streamit-extensions'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'right' => [
                        'title' => __('Right', 'streamit-extensions'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'left',
            ]
        );

        $this->add_control(
            'show_search_icon',
            [
                'label' => __('Show Search Icon', 'streamit-extensions'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Show', 'streamit-extensions'),
                'label_off' => __('Hide', 'streamit-extensions'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'search_icon',
            [
                'label' => __('Icon', 'text-domain'),
                'type' => Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fa fa-search',
                    'library' => 'solid',
                ],
                'condition' => [
                    'show_search_icon' => 'yes'
                ],
            ]
        );

        $this->add_control(
            'post_types',
            [
                'label' => __('Search in post types', 'streamit-extensions'),
                'label_block' => false,
                'type' => Controls_Manager::SELECT2,
                'options' => function_exists('iqonic_addons_get_list_posts_types') ? iqonic_addons_get_list_posts_types() : array(),
                'multiple' => false,
                'default' => ''
            ]
        );

        $this->add_control(
            'style',
            [
                'label'      => __('Search Color scheme', 'streamit-extensions'),
                'type'       => Controls_Manager::SELECT,
                'default'    => 'default',
                'options'    => [
                    'default'   => __('Default', 'streamit-extensions'),
                    'light'    => __('Light', 'streamit-extensions'),
                    'dark'    => __('Dark', 'streamit-extensions'),
                ],
                'condition' => ['layout' => 'modern'],
            ]
        );

        $this->add_control(
            'type_animation',
            [
                'label'      => __('Animation', 'streamit-extensions'),
                'type'       => Controls_Manager::SELECT,
                'default'    => 'default',
                'options'    => [
                    'default'   => __('Default', 'streamit-extensions'),
                    'top'    => __('Top', 'streamit-extensions'),
                    'left'    => __('Left', 'streamit-extensions'),
                    'right'    => __('Right', 'streamit-extensions'),
                ],
                'condition' => ['layout' => 'modern'],
            ]
        );

        $this->end_controls_section();

        require 'style.php';
    }

    protected function render()
    {
        require 'render.php';
    }
}
