<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;

$settings = $this->get_settings();

$this->add_render_attribute('slider', 'data-nav', $settings['nav-arrow']);
$this->add_render_attribute('slider', 'data-items', $settings['desk_number']);
$this->add_render_attribute('slider', 'data-items-laptop', $settings['lap_number']);
$this->add_render_attribute('slider', 'data-items-laptop-lg', $settings['lap_number']);
$this->add_render_attribute('slider', 'data-items-tab', $settings['tab_number']);
$this->add_render_attribute('slider', 'data-items-mobile', $settings['mob_number']);
$this->add_render_attribute('slider', 'data-items-mobile-sm', $settings['mob_number']);
$this->add_render_attribute('slider', 'data-autoplay', $settings['autoplay']);
$this->add_render_attribute('slider', 'data-autoplay-speed', $settings['autoplay_speed']);
$this->add_render_attribute('slider', 'data-loop', $settings['infinite']);
$this->add_render_attribute('slider', 'data-speed', $settings['speed']);

$category = '';
if (!empty($settings['woo_category'])) {
	foreach ($settings['woo_category'] as $element) {
		$category .= $element . ",";
	}
	$category = "category=" . '"' . rtrim($category, ",") . '"';
}

if (!$settings['show_catalog']) {
	remove_action('woocommerce_before_shop_loop', 'woocommerce_catalog_ordering', 30);
	add_action('woocommerce_before_shop_loop', function () { //Add Adction closing div of the Sorting 
		echo "</div>";
	}, 999);
}

remove_filter('wc_get_template_part', 'streamit_wc_template_part', 99);
add_filter(
	'wc_get_template_part',
	function ($template, $slug, $name) {
		$template = get_template_part('template-parts/wocommerce/entry');
		return $template;
	},
	10,
	3
);
remove_all_actions('woocommerce_shortcode_before_' . $settings['product_type'] . '_loop');

if ($this->get_settings()['view_all_switch'] === 'yes' || !empty($this->get_settings()['product_slider_title'])) {
	add_action(
		'woocommerce_shortcode_before_' . $settings['product_type'] . '_loop',
		function () {
			if ($this->get_settings()['view_all_switch'] === 'yes') {
				$view_all = '';
				$this->add_render_attribute('iq_class', 'class', 'iq-view-all');
				if ($this->get_settings()['use_custom_link_viewall'] == 'yes') {
					if ($this->get_settings()['view_all_custom_link']['url']) {
						$url = $this->get_settings()['view_all_custom_link']['url'];
						$this->add_render_attribute('iq_class', 'href', esc_url($url));

						if ($this->get_settings()['view_all_custom_link']['is_external']) {
							$this->add_render_attribute('iq_class', 'target', '_blank');
						}

						if ($this->get_settings()['view_all_custom_link']['nofollow']) {
							$this->add_render_attribute('iq_class', 'rel', 'nofollow');
						}
						$url = '';
					}
					$view_all_text = esc_html($this->get_settings()['use_custom_link_text']);
					$view_all = '<a ' . $this->get_render_attribute_string('iq_class') . '">' . $view_all_text . '</a>';
				} else {
					$view_all_text = get_option('streamit_options')['streamit_viewall_text'];
					$cat = '';
					if (!empty($this->get_settings()['woo_category'])) {
						$cat = '&cat=' . implode(',', $this->get_settings()['woo_category']);
					}
					$view_all = '<a class="iq-view-all" href="' . esc_url(get_page_link(get_option('streamit_options')['streamit_viewall_link'])) . '?type=product&title=' . $this->get_settings()['product_slider_title'] . '&p_type=' . esc_attr($this->get_settings()['product_type'] . $cat) . '">' . esc_html__('Want More?', SE_TEXT_DOMAIN) . '</a>';
				}
			} ?>

		<div class="iq-main-header d-flex align-items-center justify-content-between">
			<h4 class="main-title">
				<?php echo $this->get_settings()['product_slider_title']; ?>
			</h4>
			<?php echo isset($view_all) ? wp_kses_post($view_all) : ''; ?>
		</div>
<?php
		},
		999
	);
} ?>

<div class="woocommerce iq-woocommerce-product-slider " <?php echo $this->get_render_attribute_string('slider') ?>>
	<?php echo do_shortcode('[' . $settings['product_type'] . ' per_page="' . $settings['woo_per_page'] . ' " ' . $category . ' order="' . $settings['woo_order'] . '" paginate="false" class="product-grid-style "]  '); ?>
</div>