<?php

namespace Elementor;

use WP_Query;

if (!defined('ABSPATH')) exit;

$category = '';

$settings = $this->get_settings_for_display();

if (!empty($settings['woo_category'])) {
	foreach ($settings['woo_category'] as $element) {
		$category .= $element . ",";
	}
	$category = "category=" . '"' . rtrim($category, ",") . '"';
}

if ($settings['show_pagination'] == 'yes') {
	$pagination = 'paginate="true"';
} else {
	$pagination = 'paginate="false"';
}

if (!$settings['show_catalog']) {
	remove_action('woocommerce_before_shop_loop', 'woocommerce_catalog_ordering', 30);
	add_action('woocommerce_before_shop_loop', function () {
		echo "</div>";
	}, 999);
}

remove_all_filters('wc_get_template_part');
add_filter(
	'wc_get_template_part',
	function ($template, $slug, $name) {
		if ($this->get_settings()['woo_column'] == 'list') {
			$template = get_template_part('template-parts/wocommerce/entry-listing');
		} else {
			$template = get_template_part('template-parts/wocommerce/entry');
		}
		return $template;
	},
	10,
	3
);

remove_all_actions('woocommerce_after_shop_loop');
add_action('woocommerce_after_shop_loop',  array($this, 'streamit_widget_loadmore'), 99);
add_filter('woocommerce_shortcode_products_query', function ($args) {
	$this->product_query = $args;
	$this->max_page = (new WP_Query($this->product_query))->max_num_pages;
	wp_reset_postdata();

	return $args;
});

remove_all_actions('woocommerce_shortcode_before_' . $settings['product_type'] . '_loop');

if ($this->get_settings()['view_all_switch'] === 'yes' || !empty($this->get_settings()['product_grid_title'])) {
	add_action(
		'woocommerce_shortcode_before_' . $settings['product_type'] . '_loop',
		function () {
			if ($this->get_settings()['view_all_switch'] === 'yes') {
				$this->add_render_attribute('iq_class', 'class', 'iq-view-all');

				if ($this->get_settings()['use_custom_link_viewall'] == 'yes') {
					if ($this->get_settings()['view_all_custom_link']['url']) {
						$url = $this->get_settings()['view_all_custom_link']['url'];
						$this->add_render_attribute('iq_class', 'href', esc_url($url));

						if ($this->get_settings()['view_all_custom_link']['is_external']) {
							$this->add_render_attribute('iq_class', 'target', '_blank');
						}

						if ($this->get_settings()['view_all_custom_link']['nofollow']) {
							$this->add_render_attribute('iq_class', 'rel', 'nofollow');
						}
					}
					$view_all_text = esc_html($this->get_settings()['use_custom_link_text']);
					$view_all = '<a ' . $this->get_render_attribute_string('iq_class') . '">' . $view_all_text . '</a>';
				} else {
					$view_all_text = get_option('streamit_options')['streamit_viewall_text'];
					$cat = '';
					if (!empty($this->get_settings()['woo_category'])) {
						$cat = '&cat=' . implode(',', $this->get_settings()['woo_category']);
					}
					$view_all = '<a class="iq-view-all" href="' . esc_url(get_page_link(get_option('streamit_options')['streamit_viewall_link'])) . '?type=product&p_type=' . esc_html($this->get_settings()['product_type'] . '&title=' . esc_html($this->get_settings()['product_grid_title']) . $cat) . '">' . esc_html__('Want More?', SE_TEXT_DOMAIN) . '</a>';
				}
			} ?>

		<div class="iq-main-header d-flex align-items-center justify-content-between">
			<h4 class="main-title">
				<?php echo $this->get_settings()['product_grid_title']; ?>
			</h4>
			<?php echo  isset($view_all) ? wp_kses_post($view_all) : ''; ?>
		</div>
<?php
		},
		999
	);
}

$class = $settings['woo_column'] == 'list' ?  'product-list-style' : 'product-grid-style'; ?>

<div class="woocommerce iq-woocommerce">
	<div class="woof_results_by_ajax" data-shortcode="woof_products is_ajax=1">
		<?php echo do_shortcode('[' . $settings['product_type'] . ' per_page="' . $settings['woo_per_page'] . '" columns="' . $settings['woo_column'] . '" ' . $category . ' order="' . $settings['woo_order'] . '" ' . $pagination . ' class="' . $class . '" is_ajax=1 ]'); ?>
	</div>
</div>