<?php

namespace Iqonic\Elementor\Elements\Products;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;

if (!defined('ABSPATH')) exit;

class Widget extends Widget_Base
{
	public $product_query;
	public $max_page;

	public function get_name()
	{
		return 'iqonic_products';
	}

	public function get_title()
	{
		return __('WooCommerce Products', 'streamit-extensions');
	}

	public function get_categories()
	{
		return ['streamit-extension'];
	}

	public function get_icon()
	{
		return 'eicon-products';
	}

	protected function register_controls()
	{
		$this->start_controls_section(
			'section_blog',
			[
				'label' => __('Product Grid', 'streamit-extensions'),
			]
		);

		$this->add_control(
			'product_grid_title',
			[
				'label' => __('Title', 'streamit-extensions'),
				'type' => Controls_Manager::TEXT,
				'default' => __('Title', 'streamit-extensions'),
				'label_block' => true,
			]
		);

		$this->add_control(
			'product_type',
			[
				'label'      => __('Select Product', 'streamit-extensions'),
				'type'       => Controls_Manager::SELECT,
				'default'    => 'products',
				'options'    => [
					'featured_products' 	=> __('Feature Product', 'streamit-extensions'),
					'recent_products' 		=> __('Recent Product', 'streamit-extensions'),
					'sale_products'   		=> __('Sale Product', 'streamit-extensions'),
					'best_selling_products' => __('Best Selling Product', 'streamit-extensions'),
					'top_rated_products'    => __('Top Rated Product', 'streamit-extensions'),
					'products'          	=> __('All Products', 'streamit-extensions'),
				],
			]
		);

		$this->add_control(
			'woo_column',
			[
				'label'      => __('Column', 'streamit-extensions'),
				'type'       => Controls_Manager::SELECT,
				'options'    => [
					'list'          => __('Listing', 'streamit-extensions'),
					'2'          => __('2 Columns', 'streamit-extensions'),
					'3'          => __('3 Columns', 'streamit-extensions'),
					'4'          => __('4 Columns', 'streamit-extensions'),
					'5'          => __('5 Columns', 'streamit-extensions'),
				],
				'default'    => '4',
			]
		);

		$this->add_control(
			'woo_order',
			[
				'label'   => __('Order By', 'streamit-extensions'),
				'type'    => Controls_Manager::SELECT,
				'default' => 'ASC',
				'options' => [
					'DESC' => esc_html__('Descending', 'streamit-extensions'),
					'ASC' => esc_html__('Ascending', 'streamit-extensions')
				],
			]
		);

		$this->add_control(
			'woo_per_page',
			[
				'label' => __('Per Page', 'streamit-extensions'),
				'type' => Controls_Manager::NUMBER,
				'min' => -1,
				'step' => 1,
				'default' => 10,
			]
		);

		$this->add_control(
			'view_all_switch',
			[
				'label' => __('Use View All Button ?', 'streamit-extensions'),
				'type' => Controls_Manager::SWITCHER,
				'yes' => __('Yes', 'streamit-extensions'),
				'no' => __('No', 'streamit-extensions'),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'use_custom_link_viewall',
			[
				'label' => __('Use View All custom link ?', 'streamit-extensions'),
				'type' => Controls_Manager::SWITCHER,
				'yes' => __('Yes', 'streamit-extensions'),
				'no' => __('No', 'streamit-extensions'),
				'return_value' => 'yes',
				'default' => 'no',
				'condition' => ['view_all_switch' => 'yes'],
			]
		);

		$this->add_control(
			'use_custom_link_text',
			[
				'label' => __('Custom Link Text', 'streamit-extensions'),
				'type' => Controls_Manager::TEXT,
				'default' => __('Link Text', 'streamit-extensions'),
				'label_block' => true,
				'condition' => [
					'use_custom_link_viewall' => 'yes',
					'view_all_switch' => 'yes'
				],
			]
		);

		$this->add_control(
			'view_all_custom_link',
			[
				'label' => __('Custom link', 'streamit-extensions'),
				'type' => Controls_Manager::URL,
				'placeholder' => __('https://your-link.com', 'streamit-extensions'),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
				'condition' => [
					'use_custom_link_viewall' => 'yes',
					'view_all_switch' => 'yes'
				],
			]
		);


		$this->add_control(
			'show_pagination',
			[
				'label' => __('Show Pagination', 'streamit-extensions'),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __('Show', 'streamit-extensions'),
				'label_off' => __('Hide', 'streamit-extensions'),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_catalog',
			[
				'label' => __('Show Catalog ordering', 'streamit-extensions'),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __('Show', 'streamit-extensions'),
				'label_off' => __('Hide', 'streamit-extensions'),
				'return_value' => 'yes',
				'default' => 'yes',
				'condition' => ['show_pagination' => 'yes'],
			]
		);

		$this->add_control(
			'pagination',
			[
				'label'   => __('Show Pagintion/Loadmore/Infinite', 'streamit-extensions'),
				'type'    => Controls_Manager::SELECT,
				'default' => 'loadmore',
				'label_block' => true,
				'options' => [
					'yes' => esc_html__('Pagination', 'streamit-extensions'),
					'loadmore' => esc_html__('Loadmore', 'streamit-extensions'),
					'infinite' => esc_html__('Infinite Scroll', 'streamit-extensions')
				],

			]
		);

		$this->add_control(
			'more_text',
			[
				'label' => __('Load More button text', 'streamit-extensions'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __('Load More', 'streamit-extensions'),
				'label_block' => true,
				'condition' => ['pagination' => 'loadmore']
			]
		);

		$this->add_control(
			'loading_text',
			[
				'label' => __('Loading button text', 'streamit-extensions'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __('Loading...', 'streamit-extensions'),
				'label_block' => true,
				'condition' => ['pagination' => 'loadmore']
			]
		);

		$this->add_control(
			'woo_category',
			[
				'label' => __('Display Product From Specific Category', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT2,
				'label_block' => true,
				'multiple' => true,
				'options' => isset($_REQUEST['editor_post_id']) ? iqonic_get_taxonomies("product_cat") : [],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_title_style',
			[
				'label' => esc_html__(' Heading ', 'streamit-extensions'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => esc_html__('Typography', 'streamit-extensions'),
				'selector' => '{{WRAPPER}} .iq-woocommerce .iq-main-header  .main-title',
			]
		);

		$this->add_control(
			'title_color',
			[
				'label' => esc_html__('Color', 'streamit-extensions'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}}  .iq-woocommerce .iq-main-header  .main-title' => 'color:{{VALUE}}',
				],
			]
		);

		$this->add_control(
			'title_hover_color',
			[
				'label' => esc_html__('Hover Color', 'streamit-extensions'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}}  .iq-woocommerce .iq-main-header  .main-title:hover' => 'color:{{VALUE}}',
				],
			]
		);

		$this->add_responsive_control(
			'title_margin',
			[
				'label' => esc_html__('Margin', 'streamit-extensions'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors' => [
					'{{WRAPPER}} .iq-woocommerce .iq-main-header' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'title_padding',
			[
				'label' => esc_html__('Padding', 'streamit-extensions'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors' => [
					'{{WRAPPER}} .iq-woocommerce .iq-main-header' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_product_style',
			[
				'label' => esc_html__('Product ', 'streamit-extensions'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'product_margin',
			[
				'label' => esc_html__('Margin', 'streamit-extensions'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors' => [
					'{{WRAPPER}} .iq-woocommerce .streamit-sub-product' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'product_padding',
			[
				'label' => esc_html__('Padding', 'streamit-extensions'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors' => [
					'{{WRAPPER}} .iq-woocommerce .streamit-sub-product' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_product_content_style',
			[
				'label' => esc_html__('Product Content Box', 'streamit-extensions'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'product_content_padding',
			[
				'label' => esc_html__('Padding', 'streamit-extensions'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors' => [
					'{{WRAPPER}} .iq-woocommerce .streamit-sub-product .product-caption' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_product_title_style',
			[
				'label' => esc_html__('Product Content', 'streamit-extensions'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'product_title_typography',
				'label' => esc_html__('Title Typography', 'streamit-extensions'),
				'selector' => '{{WRAPPER}} .iq-woocommerce .streamit-sub-product .product-caption .woocommerce-loop-product__title',
			]
		);

		$this->add_control(
			'product_title_color',
			[
				'label' => esc_html__('Title Color', 'streamit-extensions'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}}  .iq-woocommerce .streamit-sub-product .product-caption .woocommerce-loop-product__title > a' => 'color:{{VALUE}}',
				],
			]
		);

		$this->add_control(
			'product_hover_title_color',
			[
				'label' => esc_html__(' Title Hover Color', 'streamit-extensions'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}}  .iq-woocommerce .streamit-sub-product .product-caption .woocommerce-loop-product__title:hover > a' => 'color:{{VALUE}}',
				],
			]
		);

		$this->add_responsive_control(
			'product_title_margin',
			[
				'label' => esc_html__('Product Title Margin', 'streamit-extensions'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors' => [
					'{{WRAPPER}} .iq-woocommerce .streamit-sub-product .product-caption .woocommerce-loop-product__title ' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'product_price_margin',
			[
				'label' => esc_html__('Product Price Margin', 'streamit-extensions'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors' => [
					'{{WRAPPER}} .iq-woocommerce .streamit-sub-product .product-caption .price-detail' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'product_rating_margin',
			[
				'label' => esc_html__('Product Rating Margin', 'streamit-extensions'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors' => [
					'{{WRAPPER}} .iq-woocommerce .streamit-sub-product .product-caption .container-rating' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();
	}

	protected function render()
	{
		require 'render.php';
	}

	public function streamit_widget_loadmore()
	{
		if ($this->max_page <= 1)
			return; ?>
		<input type="hidden" name="per_per_paged" class="per_per_paged" value='<?php echo  $this->get_settings()['woo_per_page'] ?>'>
		<input type="hidden" class="page_no" name="product_page_no" value='1'>
		<input type="hidden" class="max_no_page" name="max_no_page" value='<?php echo $this->max_page ?>'>
		<input type="hidden" class="product_ajax_query" name="product_query" value='<?php echo json_encode($this->product_query) ?>'>

<?php
		if ($this->get_settings()['pagination'] == "loadmore") {

			echo '<a class="streamit_loadmore_product btn btn-hover iq-button" tabindex="0" data-text="' . $this->get_settings()['more_text'] . '" data-loading-text="' . $this->get_settings()['loading_text'] . '"><span>' . $this->get_settings()['more_text'] . '</span></a>';
		} elseif ($this->get_settings()['pagination'] == "infinite") {

			echo '<div class="loader-wheel-container"></div>';
		} else {
			get_template_part('template-parts/wocommerce/pagination');
		}
	}
}
