<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;

$id_int 	= rand(10, 100);
$settings 	= $this->get_settings();
$tabs 		= $settings['tabs'];

$this->add_render_attribute('slider', 'data-nav', 			 $settings['nav-arrow']);
$this->add_render_attribute('slider', 'data-autoplay', 		 $settings['autoplay']);
$this->add_render_attribute('slider', 'data-autoplay-speed', $settings['autoplay_speed']);
$this->add_render_attribute('slider', 'data-infinite', 		 $settings['infinite']);
$this->add_render_attribute('slider', 'data-speed', 		 $settings['speed']);
$this->add_render_attribute('slider', 'data-dots', 			 $settings['pagination']); ?>

<div id="product" class="iq-main-slider p-0 iq-rtl-direction iq-product-banner-slider">
	<div id="<?php echo esc_attr('product-slider-' . $id_int); ?>" data-rand="<?php echo esc_attr('product-slider-' . $id_int); ?>" class="product-slider slider m-0 p-0" <?php echo $this->get_render_attribute_string('slider'); ?>>
		<?php foreach ($tabs as $index => $item) {
			if ($item['link_type'] == 'dynamic') {
				if ($item['link_by'] == 'category') {
					$this->add_render_attribute('btn_shop', 'href', get_term_link($item['dynamic_link_by_cat'], 'product_cat'));
				} else {
					$product = get_page_by_path($item['dynamic_link'], OBJECT, 'product');
					$this->add_render_attribute('btn_shop', 'href', get_permalink(isset($product->ID) ? $product->ID : 0));
				}
			} else {
				$this->add_render_attribute('btn_shop', 'href', $item['link']['url']);
			} ?>

			<a <?php echo $this->get_render_attribute_string('btn_shop') ?>>
				<div class="elementor-repeater-item-<?php echo  esc_attr($item['_id']) ?> slide slick-bg streamit-align-" style="background-image:url('')">
					<?php echo \Elementor\Group_Control_Image_Size::get_attachment_image_html($item, 'full', 'slider_image'); ?>
				</div>
			</a>
			<?php $this->remove_render_attribute('btn_shop', 'href');
		} ?>
	</div>
</div>