<?php

namespace Iqonic\Elementor\Elements\Product_Banner_Slider;

use Elementor\Utils;
use Elementor\Plugin;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit;

class Widget extends Widget_Base
{
	public function get_name()
	{
		return 'iq_product_banner_slider';
	}

	public function get_title()
	{
		return esc_html__('Product Banner Slider', 'streamit-extensions');
	}

	public function get_categories()
	{
		return ['streamit-extension'];
	}

	public function get_icon()
	{
		return 'eicon-slider-3d';
	}

	protected function register_controls()
	{
		$this->start_controls_section(
			'section_zhyghasgahs',
			[
				'label' => __('Product Banner Slider', 'streamit-extensions'),
			]
		);

		$this->add_control(
			'play_now_text',
			[
				'label' => __('Shop Now Text', 'streamit-extensions'),
				'type' => Controls_Manager::TEXT,
				'default' => __('Shop Now', 'streamit-extensions'),
				'label_block' => true,
				'condition' => ['show_view_all_btn' => ['yes']]
			]
		);

		$repeater = new Repeater();
		$repeater->add_control(
			'slider_image',
			[
				'label' => __('Slider Image', 'streamit-extensions'),
				'type' => Controls_Manager::MEDIA,
				'dynamic' => [
					'active' => true,
				],
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);

		$repeater->add_control(
			'link_type',
			[
				'label' => __('Link Type', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT,
				'default' => 'custom',
				'options' => [
					'dynamic' => __('Dynamic', 'streamit-extensions'),
					'custom' => __('Custom', 'streamit-extensions'),
				],
			]
		);

		$repeater->add_control(
			'link_by',
			[
				'label' => esc_html__('Select Category Or product', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT,
				'default' => 'solid',
				'options' => [
					'category'  => esc_html__('Category', 'streamit-extensions'),
					'product' => esc_html__('Product', 'streamit-extensions'),
				],
				'condition' => [
					'link_type' => 'dynamic',
				],
			]
		);

		$repeater->add_control(
			'dynamic_link',
			[
				'label' => esc_html__('Product List', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT,
				'return_value' => 'true',
				'multiple' => true,
				'condition' => [
					'link_type' => 'dynamic',
					'link_by' => 'product'
				],
				'options' => isset($_REQUEST['editor_post_id']) && function_exists('iq_custom_post_data') ? iq_custom_post_data("product", 'slug') : array(),
			]
		);

		$repeater->add_control(
			'dynamic_link_by_cat',
			[
				'label' => esc_html__('Category List', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT,
				'return_value' => 'true',
				'multiple' => true,
				'condition' => [
					'link_type' => 'dynamic',
					'link_by' => 'category'
				],
				'options' => isset($_REQUEST['editor_post_id']) && function_exists('iqonic_get_taxonomies') ? iqonic_get_taxonomies('product_cat') : array(),
			]
		);

		$repeater->add_control(
			'link',
			[
				'label' => esc_html__('Link', 'streamit-extensions'),
				'type' => Controls_Manager::URL,
				'dynamic' => [
					'active' => true,
				],
				'placeholder' => esc_html__('https://your-link.com', 'streamit-extensions'),
				'default' => [
					'url' => '#',
				],
				'condition' => ['link_type' => 'custom']
			]
		);

		$this->add_control(
			'tabs',
			[
				'label' => __('Item List', 'streamit-extensions'),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_slick_control',
			[
				'label' => __('Slider Control', 'streamit-extensions'),
			]
		);

		$this->add_control(
			'autoplay',
			[
				'label' => __('Autoplay', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT,
				'default' => 'false',
				'options' => [
					'true' => __('True', 'streamit-extensions'),
					'false' => __('False', 'streamit-extensions'),
				],
			]
		);

		$this->add_control(
			'autoplay_speed',
			[
				'label' => __('Autoplay Speed', 'streamit-extensions'),
				'type' => Controls_Manager::TEXT,
				'label_block' => false,
				'condition' => ['autoplay' => 'true'],
				'default' => '5000',
			]
		);

		$this->add_control(
			'infinite',
			[
				'label' => __('Infinite', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT,
				'default' => 'true',
				'options' => [
					'true' => __('True', 'streamit-extensions'),
					'false' => __('False', 'streamit-extensions'),
				],
			]
		);

		$this->add_control(
			'speed',
			[
				'label' => __('Speed', 'streamit-extensions'),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => '500',
			]
		);

		$this->add_control(
			'nav-arrow',
			[
				'label' => __('Arrow', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT,
				'default' => 'true',
				'options' => [
					'true' => __('True', 'streamit-extensions'),
					'false' => __('False', 'streamit-extensions'),
				],
			]
		);

		$this->add_control(
			'pagination',
			[
				'label' => __('Pagination', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT,
				'default' => 'false',
				'options' => [
					'true' => __('True', 'streamit-extensions'),
					'false' => __('False', 'streamit-extensions'),
				],
			]
		);

		$this->add_control(
			'icon_color',
			[
				'label' => __('Icon Color', 'streamit-extensions'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .iq-product-banner-slider .slick-arrow' => '--active: {{VALUE}};--border: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_banner_style',
			[
				'label' => __('Main', 'streamit-extensions'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'main_padding',
			[
				'label' => __('Padding', 'streamit-extensions'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors' => [
					'{{WRAPPER}} .iq-main-slider .slider-inner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
				],
			]
		);

		$this->add_responsive_control(
			'main_margin',
			[
				'label' => __('Margin', 'streamit-extensions'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors' => [
					'{{WRAPPER}} .iq-main-slider .slider-inner' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} ;',
				],
			]
		);

		$this->end_controls_section();
	}

	protected function render()
	{
		require 'render.php';
		if (Plugin::$instance->editor->is_edit_mode()) { ?>
			<script>
				(function(jQuery) {
					callBannerSlider(jQuery('.iq-product-banner-slider .product-slider'));
				})(jQuery);
			</script>
<?php
		}
	}
}
