<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;

$html = $active = $link_id = '';
$table_row = $header = $footer = $body = [];

$settings = $this->get_settings();
if (isset($settings['iq_is_active']) && !empty($settings['iq_is_active'])) {
    $this->add_render_attribute('active_data', 'data-active', $settings['iq_is_active']);
    $active = $settings['iq_is_active'];
}

$args = array(
    'post_type'         => 'pricing',
    'post_status'       => 'publish',
    'suppress_filters' => true,
);

$term_by = 'name';
if (isset($settings['select_price_todisplay']) && !empty($settings['select_price_todisplay'])) {
    $args['post__in'] = $settings['select_price_todisplay'];
}
if (isset($settings['select_pricecategory_todisplay']) && !empty($settings['select_pricecategory_todisplay'])) {
    $term_by = 'slug';
    $price_cat = $settings['select_pricecategory_todisplay'];
} else {
    $price_cat = iq_get_custom_taxonomy('pricing_categories', array(), 'id');
}

$loop = query_posts($args);
$cat = $price_cat;
foreach ($cat as $key => $val) {
    if ($term_by == 'name') {
        $body[$key] = [];
    } else {
        $body[$val] = [];
    }
}
if (have_posts()) {
    while (have_posts()) {
        the_post();
        $is_external = '';
        $meta = get_post_meta(get_the_ID(), '', true);
        $header[] = [
            "title" => get_the_title(),
            "period" => !empty($meta['name_period'][0]) ? $meta['name_period'][0] : '',
            "price" => !empty($meta['name_price'][0]) ? $meta['name_price'][0] : '',
            "discount" => !empty($meta['name_discount'][0]) ? $meta['name_discount'][0] : '',
            "paid_sub_ids" => !empty($meta['name_paid_sub_id'][0]) ? $meta['name_paid_sub_id'][0] : ''

        ];

        if (isset($meta['name_pricing_link'][0]) && $meta['name_pricing_link'][0] == 'yes') {
            $link_id = $meta['name_pricing_redirect_link'][0];
            $footer[] = [
                "btn_link" => !empty($meta['name_pricing_redirect_link'][0]) ? (get_permalink($meta['name_pricing_redirect_link'][0]) . '?subscription_plan=' . $meta['name_paid_sub_id'][0]) : '#',
                "is_external" => $is_external,
            ];
        } else {
            $link_id = isset($meta['name_pricing_custom_link'][0]) ? $meta['name_pricing_custom_link'][0]  : '';
            if (!empty($meta['name_pricing_custom_link_type'][0]) && $meta['name_pricing_custom_link_type'][0] == 'yes') {
                $is_external = 'target=_blank rel=nofollow';
            }
            $footer[] = [
                "btn_link" => !empty($meta['name_pricing_custom_link'][0]) ? $meta['name_pricing_custom_link'][0] : '#',
                "is_external" => $is_external,
            ];
        }
        foreach ($cat as $key => $val) {
            if ($term_by == 'slug') {
                $key = $val;
            }
            $body[$key][] = !empty($meta[$key][0]) ? $meta[$key][0] : '';
        }
    }
    wp_reset_postdata();
}

$style2 = 'iq-pricing-card';
$text_align = 'text-center';
if ($settings['price_layout'] === 'style2') {
    $style2 = 'iq-pricing-card-two';
    $text_align = 'text-left';
}

?>
<?php if ($settings['price_layout'] === 'style1' || $settings['price_layout'] === 'style2') { ?>
    <div class="<?php echo esc_attr($style2); ?>">
        <div class="table-responsive iq-pricing pt-2">
            <table id="my-table" class="table" <?php echo $this->get_render_attribute_string('active_data') ?>>
                <thead>
                    <tr>
                        <th class="text-center iq-price-head"></th>
                        <?php
                        foreach ($header as $head) {
                            $class_active = str_replace(' ', '-', strtolower($head['title'])); ?>
                            <th class="text-center iq-price-head <?php echo esc_html($class_active); ?>">
                                <div class="iq-price-box">
                                    <?php if ($settings['price_layout'] === 'style1') { ?>
                                        <<?php echo $settings['title_tag']; ?> class="iq-price-rate">
                                            <?php echo esc_attr($head['price']); ?>
                                            <small> / <?php echo esc_attr($head['period']); ?></small>
                                        </<?php echo esc_attr($settings['title_tag']); ?>>
                                        <?php
                                        if (!empty($head['discount'])) {
                                            $args = ['discount_code' =>  $head['discount'], 'subscription_plan' =>  $head['paid_sub_ids'], 'calculate_discounted_amount' => ''];
                                            do_action_ref_array('iqonic_price_add_discount_box', array(&$args));
                                        }
                                        ?>
                                    <?php } ?>
                                    <span class="type"><?php echo esc_attr($head['title']); ?></span>
                                </div>
                            </th>
                        <?php } ?>
                    </tr>
                </thead>
                
                <tbody>
                    <?php foreach ($cat as $key => $cat_list) {
                        $category_details = get_term_by($term_by, $cat_list, 'pricing_categories');
                        $c_id = $category_details->term_id;
                        $key = $category_details->slug;
                        $type = get_term_meta($c_id, 'name_cat_type', true);
                        $type = !empty($type) ? $type : 'checkbox'; ?>
                        <tr>
                            <th class="<?php echo esc_attr($text_align) ?>" scope="row"> <?php echo esc_attr($category_details->name); ?></th>
                            <?php foreach ($header as $index => $val) { ?>
                                <td class="text-center iq-child-cell">
                                    <?php
                                    switch ($type) {
                                        case 'checkbox':
                                            if ($body[$key][$index] === 'yes')
                                                echo '<i class="' . $settings['icon_for_true']['value'] . '"></i>';
                                            else
                                                echo '<i class="' . $settings['icon_for_false']['value'] . '"></i>';
                                            break;
                                        case 'text':
                                        default:
                                            echo esc_html($body[$key][$index]);
                                            break;
                                    } ?>
                                </td>
                            <?php } ?>
                        </tr>
                    <?php } ?>
                    <?php if ($settings['price_layout'] === 'style1') { ?>
                        <tr>
                            <th class="text-center iq-price-footer"></th>
                            <?php
                            foreach ($footer as $key => $foot) { ?>
                                <td class="text-center iq-price-footer">
                                    <?php if (!empty($settings['pricing_btn_text'])) { ?>
                                        <div class="align-items-center r-mb-23" data-animation-in="fadeInUp" data-delay-in="1.3">
                                            <a href="<?php echo esc_url(add_query_arg(array('discount_code' => $header[$key]['discount']), $foot['btn_link'])); ?>" <?php echo esc_html($foot['is_external']); ?> class="btn btn-hover iq-button"><?php echo esc_html($settings['pricing_btn_text']); ?></a>
                                        </div>
                                    <?php } ?>
                                </td>
                            <?php } ?>
                        </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
        <?php if ($settings['price_layout'] === 'style2') { ?>
            <div class="iq-price-bottom">
                <?php if ($settings['show_plan'] == 'yes') { ?>
                    <div class="iq-select-price row">
                        <?php
                        $count = 12;
                        $header_arr_count = count($header);
                        $bootstrap_col = array(2 => 6, 3 => 4, 4 => 3, 5 => 2);
                        if ($header_arr_count >= 2  && $header_arr_count <= 5) {
                            $count = $bootstrap_col[$header_arr_count];
                        }

                        foreach ($header as $head) {
                            $class_active = str_replace(' ', '-', strtolower($head['title']));
                            $active_class = '';
                            if ($active === $class_active) {
                                $active_class = 'active';
                            } ?>
                            <div class="col-lg-<?php echo esc_attr($count); ?> col-4">
                                <div class="iq-price-rate-wrap <?php echo esc_attr($active_class); ?>" data-paid-id="<?php echo esc_attr($head['paid_sub_ids']) ?>">
                                    <?php
                                    if (!empty($head['discount'])) {
                                        $args = ['discount_code' =>  $head['discount'], 'subscription_plan' =>  $head['paid_sub_ids'], 'calculate_discounted_amount' => ''];
                                        do_action_ref_array('iqonic_price_add_discount_box', array(&$args));
                                    } ?>

                                    <div class="iq-price-label">
                                        <span class="type"><?php echo esc_attr($head['title']); ?></span>
                                        <<?php echo esc_attr($settings['title_tag']); ?> class="iq-price-rate">
                                            <span class="iq-actual-price <?php echo esc_attr(isset($args['calculate_discounted_amount']) && !empty($args['calculate_discounted_amount']) ? "has-discount" : "") ?>" data-price="<?php echo str_replace('$', '', $head['price']) ?>"><?php echo esc_html($head['price']) ?></span>
                                            <?php
                                            if (!empty($head['discount'])  && isset($args['calculate_discounted_amount'])) {
                                                if ($active === $class_active) {
                                                    $active_subcription_price = $args['calculate_discounted_amount'];
                                                    $active_subcription_period = $head['period'];
                                                }
                                                printf("%s %s %s", "<span class='iq-discount-price'data-discount-price='" . esc_attr($args['calculate_discounted_amount']) . "' >", esc_attr($args['calculate_discounted_amount']), "</span>");
                                            }
                                            ?>
                                            <small class="iq-period" data-period="<?php echo esc_attr($head['period']); ?>"> / <?php echo esc_attr($head['period']); ?></small>
                                        </<?php echo esc_attr($settings['title_tag']); ?>>
                                    </div>
                                </div>
                            </div>
                        <?php
                        } ?>
                    </div>
                    <?php
                }

                if (!empty($settings['pricing_btn_text'])) {
                    if ($settings['use_link_type'] == 'custom') {
                        if (!empty($settings['use_custom_link']['url'])) {
                            $link_id = $settings['use_custom_link']['url'];
                        } else {
                            $link_id = '';
                        }
                        if ($settings['use_custom_link']['is_external']) {
                            $is_external .= ' target=_blank';
                        }

                        if ($settings['use_custom_link']['nofollow']) {
                            $is_external .= ' rel=nofollow';
                        } ?>

                        <div class="align-items-center r-mb-23" data-animation-in="fadeInUp" data-delay-in="1.3">
                            <a href="<?php echo esc_url($link_id); ?>" <?php echo esc_attr($is_external); ?> class="btn btn-hover iq-button"><?php echo esc_html($settings['pricing_btn_text']); ?></a>
                        </div>
                    <?php
                    } else {
                    ?>
                        <div class="align-items-center r-mb-23" data-animation-in="fadeInUp" data-delay-in="1.3">
                            <a href="<?php echo esc_url(get_permalink($link_id)); ?>" class="btn btn-hover iq-button secondary-btn"><?php echo esc_html($settings['pricing_btn_text']); ?></a>
                        </div>
                    <?php
                    }
                    ?>
                <?php } ?>
            </div>
        <?php } ?>

        <?php wp_reset_postdata(); ?>
    </div>

<?php } ?>

<?php if ($settings['price_layout'] === 'style3') { ?>
    <div class="iq-pricing-card-three">
        <div class="row">
            <div class="col-sm-4 col-6 price-head align-self-end pr-0">
                <div>
                    <?php
                    foreach ($cat as $key => $cat_list) {
                        $category_details = get_term_by($term_by, $cat_list, 'pricing_categories');
                        $c_id = $category_details->term_id;
                        $key = $category_details->slug;
                        $type = get_term_meta($c_id, 'name_cat_type', true);
                        $type = !empty($type) ? $type : 'checkbox'; ?>
                        <span class="price-title"><?php echo esc_attr($category_details->name); ?></span>
                    <?php
                    } ?>
                </div>

            </div>
            <div class="col-sm-8 col-6">
                <div class="row">
                    <?php foreach ($header as $_key => $head) {
                        $class_active = str_replace(' ', '-', strtolower($head['title']));
                        $active_class = '';
                        if ($active === $class_active) {
                            $active_class = 'active';
                        } ?>

                        <div class="col-4 col-md-4 iq-price-head <?php echo esc_attr($active_class) ?>" id="<?php echo esc_attr($head['title']) ?>">
                            <div class="text-center iq-child-cell iq-price-head">
                                <div class="iq-price-box">
                                    <span class="type"><?php echo esc_attr($header[$_key]['title']); ?></span>
                                </div>
                            </div>
                            <?php
                            foreach ($cat as $key => $cat_list) {
                                $category_details = get_term_by($term_by, $cat_list, 'pricing_categories');
                                $c_id = $category_details->term_id;
                                $key = $category_details->slug;
                                $type = get_term_meta($c_id, 'name_cat_type', true);
                                $type = !empty($type) ? $type : 'checkbox';
                                foreach ($header as $index => $val) {
                                    if ($_key == $index) { ?>
                                        <div class="text-center iq-child-cell">
                                            <?php
                                            switch ($type) {
                                                case 'checkbox':
                                                    if ($body[$key][$index] === 'yes')
                                                        echo '<i class="' . $settings['icon_for_true']['value'] . '"></i>';
                                                    else
                                                        echo '<i class="' . $settings['icon_for_false']['value'] . '"></i>';
                                                    break;
                                                case 'text':
                                                default:
                                                    echo esc_html($body[$key][$index]);
                                                    break;
                                            }
                                            ?>
                                        </div>
                                    <?php } ?>
                                <?php } ?>
                            <?php } ?>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
        <div class="iq-price-bottom">
            <?php if ($settings['show_plan'] == 'yes') { ?>
                <div class="iq-select-price row">
                    <?php
                    $active_subcription_period;
                    $active_subcription_price;

                    $active_subcription;
                    $active_subcription_coupon;

                    foreach ($header as $head) {
                        $class_active = str_replace(' ', '-', strtolower($head['title']));
                        $active_class = '';
                        if ($active === $class_active) {
                            $active_class = 'active';
                            $active_subcription = $head['paid_sub_ids'];
                            $active_subcription_coupon = isset($head['discount']) ? $head['discount'] : false;
                        } ?>

                        <div class="col-4">
                            <div class="iq-price-rate-wrap <?php echo esc_attr($active_class); ?>" data-target="#<?php echo esc_attr($head['title']); ?>" data-paid-id="<?php echo esc_attr($head['paid_sub_ids']) ?>">
                                <div class="iq-price-label">
                                    <?php
                                    if (!empty($head['discount'])) {
                                        $args = ['discount_code' =>  $head['discount'], 'subscription_plan' =>  $head['paid_sub_ids'], 'calculate_discounted_amount' => ''];
                                        do_action_ref_array('iqonic_price_add_discount_box', array(&$args));
                                    } ?>

                                    <span class="type"><?php echo esc_attr($head['title']); ?></span>
                                    <<?php echo esc_attr($settings['title_tag']); ?> class="iq-price-rate">
                                        <span class="iq-actual-price <?php echo esc_attr(isset($args['calculate_discounted_amount']) && !empty($args['calculate_discounted_amount']) ? "has-discount" : "") ?>" data-price="<?php echo str_replace('$', '', $head['price']) ?>"><?php echo esc_html($head['price']) ?></span>
                                        <?php
                                        if (!empty($head['discount'])  && isset($args['calculate_discounted_amount'])) {
                                            if ($active === $class_active) {
                                                $active_subcription_price = $args['calculate_discounted_amount'];
                                                $active_subcription_period = $head['period'];
                                            }
                                            printf("%s %s %s", "<span class='iq-discount-price'data-discount-price='" . esc_attr($args['calculate_discounted_amount']) . "' >", esc_attr($args['calculate_discounted_amount']), "</span>");
                                        } ?>

                                        <small class="iq-period" data-period="<?php echo esc_attr($head['period']); ?>"> / <?php echo esc_attr($head['period']); ?></small>
                                    </<?php echo esc_attr($settings['title_tag']); ?>>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                </div>
            <?php } ?>
            <div class="row">
                <div class="col-lg-12">
                    <?php
                    $pricing_btn_text = is_null($active_subcription_price) && is_null($active_subcription_period) ?  $settings['iq_pricing_btn_for_free_plan'] : str_replace(["{{price}}", "{{period}}"], [$active_subcription_price, $active_subcription_period], $settings['pricing_btn_text']);
                    extract($this->iq_get_prcing_link($link_id, $settings['use_link_type'], $settings['use_custom_link'], '', array('subscription_plan' => $active_subcription, 'discount_code' => $active_subcription_coupon)));
                    ?>
                    <input type="hidden" name="iq_subcription_btn_text" value='<?php echo json_encode(array('free' => $settings['iq_pricing_btn_for_free_plan'], 'other' => $settings['pricing_btn_text'])) ?>'>
                    <div class="align-items-center r-mb-23" data-animation-in="fadeInUp" data-delay-in="1.3">

                        <a id="iq-subscribe-btn" href="<?php echo esc_url($permalink); ?>" <?php echo esc_attr($is_external); ?> class="btn btn-hover d-block iq-button "><?php echo esc_html(trim($pricing_btn_text)); ?></a>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php
}