<?php

namespace Iqonic\Elementor\Elements\Pricing_Plan;

use Elementor\Plugin;
use Elementor\Controls_Manager;
use Elementor\Widget_Base;

if (!defined('ABSPATH')) exit;
class Widget extends Widget_Base
{

	public function get_name()
	{
		return 'iqonic_price';
	}

	public function get_title()
	{
		return esc_html__('Pricing Plan', 'streamit-extensions');
	}

	public function get_categories()
	{
		return ['streamit-extension'];
	}

	public function get_icon()
	{
		return 'eicon-price-table';
	}

	protected function register_controls()
	{
		$this->start_controls_section(
			'section_style',
			[
				'label' => __('Pricing Style', 'streamit-extensions'),
			]
		);

		$this->add_control(
			'price_layout',
			[
				'label' 		=> __('Select Pricing Plan Style', 'streamit-extensions'),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::SELECT,
				'options' => [
					'style1' => __("Style 1", SE_TEXT_DOMAIN),
					'style2' => __("Style 2", SE_TEXT_DOMAIN),
					'style3' => __("Style 3", SE_TEXT_DOMAIN),
				],
				'default'     => 'style1',
				'description' => __('Select pricing layouts', 'streamit-extensions')
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section',
			[
				'label' => __('Pricing Plan', 'streamit-extensions'),
			]
		);

		$this->add_control(
			'select_price_todisplay',
			[
				'label' => __('Select Plans to display', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT2,
				'label_block' => true,
				'multiple' => true,
				'options' => isset($_REQUEST['editor_post_id']) ? iq_custom_post_data('pricing', false) : [],
			]
		);

		$this->add_control(
			'select_pricecategory_todisplay',
			[
				'label' => __('Select Plans to Category display', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT2,
				'label_block' => true,
				'multiple' => true,
				'options' => isset($_REQUEST['editor_post_id']) ? iq_get_custom_taxonomy('pricing_categories', array(), 'id') : [],
			]
		);

		$this->add_control(
			'pricing_btn_text',
			[
				'label' => __('Pricing Button Text', 'streamit-extensions'),
				'type' => Controls_Manager::TEXT,
				'default' => __('Subscribe', 'streamit-extensions'),
				'label_block' => true,
				'description' => esc_html__('In Pricing Plan Style 3 You can Restucture your Subcribe button using {{price}} And {{period}} variable', 'streamit-extensions')
			]
		);

		$this->add_control(
			'iq_pricing_btn_for_free_plan',
			[
				'label' => __('Pricing Button Text For Free Plan', 'streamit-extensions'),
				'type' => Controls_Manager::TEXT,
				'default' => __('Subscribe For Free', 'streamit-extensions'),
				'label_block' => true,
				'condition' => ['price_layout' => 'style3']
			]
		);

		$this->add_control(
			'show_plan',
			[
				'label' => __('Show Plan ?', 'streamit-extensions'),
				'type' => Controls_Manager::SWITCHER,
				'yes' => __('Yes', 'streamit-extensions'),
				'no' => __('No', 'streamit-extensions'),
				'return_value' => 'yes',
				'default' => 'yes',
				'condition' => ['price_layout' => 'style2']
			]
		);

		$this->add_control(
			'iq_is_active',
			[
				'label' => __('Active plan', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT,
				'label_block' => true,
				'multiple' => true,
				'options' => isset($_REQUEST['editor_post_id']) ? iq_custom_post_data('pricing', true) : [],
				'conditions' => [
					'relation' => 'or',
					'terms' => [
						[
							'terms' => [
								[
									'name' => 'price_layout',
									'operator' => '==',
									'value' => 'style2'
								],
								[
									'name' => 'show_plan',
									'operator' => '==',
									'value' => 'yes'
								]
							]
						],
						[
							'terms' => [
								[
									'name' => 'price_layout',
									'operator' => '==',
									'value' => 'style1'
								]
							]
						],
						[
							'terms' => [
								[
									'name' => 'price_layout',
									'operator' => '==',
									'value' => 'style3'
								]
							]
						]
					]
				],
			]
		);

		$this->add_control(
			'icon_for_true',
			[
				'label' => __('Select icon for yes', 'streamit-extensions'),
				'type' => Controls_Manager::ICONS,
				'fa4compatibility' => 'icon',
				'default' => [
					'value' => 'fas fa-star'

				],
				'label_block' => false,
				'skin' => 'inline',
			]
		);

		$this->add_control(
			'icon_for_false',
			[
				'label' => __('Select icon for no', 'streamit-extensions'),
				'type' => Controls_Manager::ICONS,
				'fa4compatibility' => 'icon',
				'default' => [
					'value' => 'fas fa-star'

				],
				'label_block' => false,
				'skin' => 'inline',
			]
		);

		$this->add_control(
			'title_tag',
			[
				'label'      => __('Price Tag', 'streamit-extensions'),
				'type'       => Controls_Manager::SELECT,
				'default'    => 'h4',
				'options'    => [
					'h1'          => __('h1', 'streamit-extensions'),
					'h2'          => __('h2', 'streamit-extensions'),
					'h3'          => __('h3', 'streamit-extensions'),
					'h4'          => __('h4', 'streamit-extensions'),
					'h5'          => __('h5', 'streamit-extensions'),
					'h6'          => __('h6', 'streamit-extensions'),
				],
			]
		);

		$this->add_control(
			'use_link_type',
			[
				'label' => __('Link Type', 'streamit-extensions'),
				'type'       => Controls_Manager::SELECT,
				'options'    => [
					'dynamic'          => __('Dynamic', 'streamit-extensions'),
					'custom'          => __('Custom', 'streamit-extensions'),
				],
				'default' => 'dynamic',
				'condition' => ['price_layout' => ['style2', 'style3']],
			]
		);

		$this->add_control(
			'use_custom_link',
			[
				'label' => __('Custom link', 'streamit-extensions'),
				'type' => Controls_Manager::URL,
				'placeholder' => __('https://your-link.com', 'streamit-extensions'),
				'condition' => [
					'use_link_type' => 'custom',
					'price_layout' =>  ['style2', 'style3']
				],
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
			]
		);

		$this->end_controls_section();
	}

	protected function render()
	{
		if (is_plugin_active("paid-member-subscriptions/index.php"))
			add_action('iqonic_price_add_discount_box', array($this, 'iqonic_price_add_discount_box'), 10, 2);

		require 'render.php';

		if (Plugin::$instance->editor->is_edit_mode()) { ?>
			<script>
				(function(jQuery) {
					callPricing();
				})(jQuery);
			</script>
		<?php
		}
	}

	private function iq_get_prcing_link($link, $use_link_type, $use_custom_link, $is_external = '', $args = array())
	{
		if ($use_link_type == 'custom') {
			if (!empty($use_custom_link['url'])) {
				$link = $use_custom_link['url'];
			} else {
				$link = '';
			}
			if ($use_custom_link['is_external']) {
				$is_external .= ' target=_blank';
			}

			if ($use_custom_link['nofollow']) {
				$is_external .= ' rel=nofollow';
			}
		} else {
			$link = get_permalink($link);
		}
		return [
			'permalink' => add_query_arg($args, $link),
			'is_external' => $is_external
		];
	}

	public function iqonic_price_add_discount_box(&$args)
	{
		$get_discount = pms_in_get_discount_by_code($args['discount_code']);
		if (!$get_discount || !in_array($args['subscription_plan'], explode(',', $get_discount->subscriptions)))
			return;

		$subcription_price = pms_get_subscription_plan($args['subscription_plan'])->price;
		$args['calculate_discounted_amount'] = pms_in_calculate_discounted_amount($subcription_price, $get_discount);
		?>
		<div class="iq-pricing-discount" data-discount-code="<?php echo isset($args['discount_code']) ? esc_html($args['discount_code']) : ''; ?>">
			<?php
			$discount_price = sprintf("%s %d", $get_discount->type == 'percent' ? __('Off', 'streamit-extensions') : __('Save', 'streamit-extensions'), $get_discount->amount);
			$discount_price .= $get_discount->type == 'percent' ? '%' : '$';
			echo esc_html($discount_price);
			?>
		</div>
<?php
	}
}
