<?php

$badge          = false;
$meta           = get_post_meta($post_id);
$run_time       = isset($meta['_movie_run_time']) ? $meta['_movie_run_time'][0] : '';

if ($is_badges_enable) {
    $is_post_restricted = pmpro_has_membership_access($post_id) === false;
    $badge              = ($is_post_restricted) ? streamit_premium_bage_svg() : false;
}

$image_alt = get_the_title($post_id);

if ($settings['image_style'] == "landscape") {
    $slider_image = ($is_grid)
        ? wp_get_attachment_image_src(get_post_thumbnail_id($post_id), $thumbnail_size)[0]
        : wp_get_attachment_image_src(get_post_thumbnail_id($post_id), "medium_large")[0];
} else {
    $slider_image = streamit_get_portrait_image($post_id);
}

if ($is_ajax_enable && isset($lazy_load) && !empty($lazy_load)) {
    $img_class      = ' iqonic-lazy';
    $lazy_image     = get_cards_lazy_load_image();

    $original_image = $slider_image;
    $slider_image   = $lazy_image;
    $srcset         = "data-srcset=" . $original_image . "";
} else {
    $img_class  = '';
    $srcset     = '';
} ?>

<li class="slide-items <?php echo esc_attr($col); ?>">
    <div class="block-images position-relative">
        <div class="img-box">
            <?php if ($badge) {
                echo "<img class='streamit-badges' src=" . $badge . " alt=" . esc_attr__("Premium", SE_TEXT_DOMAIN) . ">";
            } ?>
            <a href="<?php echo get_the_permalink($post_id); ?>"></a>
            <img src="<?php echo esc_url($slider_image) ?>" class="img-fluid <?php echo esc_attr($img_class); ?>" alt="<?php echo esc_attr($image_alt); ?>" <?php echo esc_attr($srcset); ?>>
        </div>

        <div class="card-description with-opacity">
            <div class="cart-content">
                <div class="content-left">
                    <h5 class="iq-title">
                        <a href="<?php echo get_the_permalink($post_id); ?>">
                            <?php echo get_the_title($post_id); ?>
                        </a>
                    </h5>

                    <div class="movie-time d-flex align-items-center my-2 ">
                        <span class="movie-time-text font-normal">
                            <?php echo esc_html($run_time); ?>
                        </span>
                    </div>
                </div>
            </div>
        </div>

        <!-- 2nd -->
        <div class="card-description with-transition">
            <div class="cart-content">
                <div class="content-left">
                    <h5 class="iq-title">
                        <a href="<?php echo get_the_permalink($post_id); ?>">
                            <?php echo get_the_title($post_id); ?>
                        </a>
                    </h5>

                    <div class="movie-time d-flex align-items-center my-2 ">
                        <span class="movie-time-text font-normal"><?php echo esc_html($run_time); ?></span>
                    </div>
                </div>

                <?php if (isset($streamit_options['streamit_display_watchlist']) && $streamit_options['streamit_display_watchlist'] == 'yes') { ?>
                    <div class="watchlist">
                        <?php if (!is_user_logged_in()) :
                            if (isset($streamit_options['streamit_signin_link'])) :
                                $iqonic_signin_link = get_page_link($streamit_options['streamit_signin_link']); ?>
                                <a class="watch-list-not" href="<?php echo esc_url($iqonic_signin_link); ?>">
                                    <span><i class="mr-1 fas fa-plus"></i></span>
                                    <span class='watchlist-label'>
                                        <?php echo esc_html__("Watchlist", SE_TEXT_DOMAIN); ?>
                                    </span>
                                </a>
                            <?php
                            endif;
                        else :
                            $watchlist_label =  esc_html__("Watchlist", SE_TEXT_DOMAIN); ?>
                            <a class="w-cards watch-list" rel="<?php echo esc_attr($post_id); ?>" data-label=<?php echo esc_attr($watchlist_label); ?>>
                                <?php echo add_to_watchlist($post_id); ?>
                                <span class='watchlist-label'> <?php echo esc_html($watchlist_label); ?> </span>
                            </a>
                        <?php endif; ?>
                    </div>
                <?php } ?>
            </div>
        </div>
        <!-- 2nd-over -->

        <div class="block-social-info">
            <ul class="list-inline p-0 m-0 music-play-lists">
                <?php if (isset($streamit_options['streamit_display_social_icons']) && $streamit_options['streamit_display_social_icons'] == 'yes') : ?>
                    <li class="share">
                        <span><i class="fas fa-share-alt"></i></span>
                        <div class="share-wrapper">
                            <div class="share-boxs">
                                <svg width="15" height="40" class="share-shape" viewBox="0 0 15 40" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M14.8842 40C6.82983 37.2868 1 29.3582 1 20C1 10.6418 6.82983 2.71323 14.8842 0H0V40H14.8842Z" fill="#191919" />
                                </svg>
                                <div class=" overflow-hidden">
                                    <a href="https://www.facebook.com/sharer?u=<?php echo get_the_permalink($post_id); ?>" target="_blank" rel="noopener noreferrer" class="share-ico"><i class="fab fa-facebook-f"></i></a>
                                    <a href="http://twitter.com/intent/tweet?text=<?php echo get_the_title($post_id); ?>&url=<?php echo get_the_permalink($post_id); ?>" target="_blank" rel="noopener noreferrer" class="share-ico"><svg xmlns="http://www.w3.org/2000/svg" fill="white" width="18" height="18" viewBox="0 0 512 512"><path d="M389.2 48h70.6L305.6 224.2 487 464H345L233.7 318.6 106.5 464H35.8L200.7 275.5 26.8 48H172.4L272.9 180.9 389.2 48zM364.4 421.8h39.1L151.1 88h-42L364.4 421.8z"></path></svg></a>
                                    <a href="#" data-link='<?php echo get_the_permalink($post_id); ?>' class="share-ico iq-copy-link"><i class="fas fa-link"></i></a>
                                </div>
                            </div>
                        </div>
                    </li>
                <?php endif; ?>

                <?php if (class_exists('WpUlikeInit') && isset($streamit_options['streamit_display_like']) && $streamit_options['streamit_display_like'] == 'yes') : ?>
                    <li>
                        <div class="iq-like-btn">
                            <?php echo do_shortcode('[wp_ulike for="movie" id="' . esc_attr($post_id) . '" style="wpulike-heart"]'); ?>
                        </div>
                    </li>
                <?php endif; ?>
            </ul>
            <div class="hover-buttons">
                <a href="<?php echo get_the_permalink($post_id); ?>" class="btn btn-hover iq-button">
                    <i class="fa fa-play mr-1" aria-hidden="true"></i>
                </a>
            </div>
        </div>
    </div>
</li>