<?php

namespace Iqonic\Elementor\Elements\Popular;

use Elementor\Plugin;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit;

class Widget extends Widget_Base
{
	public function get_name()
	{
		return 'iqonic_popular';
	}

	public function get_title()
	{
		return esc_html__('Iqonic Popular', SE_TEXT_DOMAIN);
	}

	public function get_categories()
	{
		return ['streamit-extension'];
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve heading widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon()
	{
		return 'eicon-slider-push';
	}

	protected function register_controls()
	{
		$this->start_controls_section(
			'section_Team',
			[
				'label' => __('Popular', SE_TEXT_DOMAIN),
			]
		);

		$this->add_control(
			'post_type',
			[
				'label'      => __('Select Post Type to Show', SE_TEXT_DOMAIN),
				'type'       => Controls_Manager::SELECT,
				'options'    => [
					'movie' => __('Movie', SE_TEXT_DOMAIN),
					'tv_show' => __('TV Show', SE_TEXT_DOMAIN),
					'video' => __('Video', SE_TEXT_DOMAIN),
				],
				'default'    => 'movie',
				'label_block' => true,
			]
		);

		$this->add_control(
			'section_title',
			[
				'label' => __('Title', SE_TEXT_DOMAIN),
				'type' => Controls_Manager::TEXT,
				'default' => __('Title', SE_TEXT_DOMAIN),
				'label_block' => true,
			]
		);

		$this->add_control(
			'title_tag',
			[
				'label'      => __('Title Tag', SE_TEXT_DOMAIN),
				'type'       => Controls_Manager::SELECT,
				'options'    => [
					'h1'          => __('h1', SE_TEXT_DOMAIN),
					'h2'          => __('h2', SE_TEXT_DOMAIN),
					'h3'          => __('h3', SE_TEXT_DOMAIN),
					'h4'          => __('h4', SE_TEXT_DOMAIN),
					'h5'          => __('h5', SE_TEXT_DOMAIN),
					'h6'          => __('h6', SE_TEXT_DOMAIN),
				],
				'default'    => 'h4',
			]
		);

		$this->add_control(
			'slider_start',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);

		$this->add_control(
			'slider_type',
			[
				'label' 	=> __('Style', SE_TEXT_DOMAIN),
				'type' 		=> Controls_Manager::SELECT,
				'options' 	=> [
					'slider' 	=> __('Slider', SE_TEXT_DOMAIN),
					'grid' 		=> __('Grid', SE_TEXT_DOMAIN)
				],
				'default' 	=> 'slider'

			]
		);

		$this->add_control(
			'popular_grid_style',
			[
				'label'     => __('Grid', SE_TEXT_DOMAIN),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'1'          => __('One', SE_TEXT_DOMAIN),
					'2'          => __('Two', SE_TEXT_DOMAIN),
					'3'          => __('Three', SE_TEXT_DOMAIN),
					'4'          => __('Four', SE_TEXT_DOMAIN),
					'5'          => __('Five', SE_TEXT_DOMAIN),
					'6'          => __('Six', SE_TEXT_DOMAIN),
				],
				'default'   => '4',
				'condition'	=> ['slider_type' => 'grid']
			]
		);

		$this->add_control(
			'image_style',
			[
				'label' 	=> __('Image style', SE_TEXT_DOMAIN),
				'type' 		=> Controls_Manager::SELECT,
				'options' 	=> [
					'landscape' 	=> __('Landscape', SE_TEXT_DOMAIN),
					'portrait' 		=> __('Portrait', SE_TEXT_DOMAIN)
				],
				'default' 	=> 'portrait'
			]
		);

		$this->add_control(
			'show_title',
			[
				'label' 		=> __('Show Title', 'streamit-extensions'),
				'type' 			=> Controls_Manager::SWITCHER,
				'yes' 			=> __('Yes', 'streamit-extensions'),
				'no' 			=> __('No', 'streamit-extensions'),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);

		$this->add_control(
			'enable_premium_badges',
			[
				'label' 		=> __('Enable Premium Badges', SE_TEXT_DOMAIN),
				'type' 			=> Controls_Manager::SWITCHER,
				'yes' 			=> __('Yes', SE_TEXT_DOMAIN),
				'no' 			=> __('No', SE_TEXT_DOMAIN),
				'return_value' 	=> 'yes',
				'default' 		=> 'no',
			]
		);

		$this->add_control(
			'enable_ajax',
			[
				'label' 		=> __('Enable Ajax', SE_TEXT_DOMAIN),
				'type' 			=> Controls_Manager::SWITCHER,
				'yes' 			=> __('Yes', SE_TEXT_DOMAIN),
				'no' 			=> __('No', SE_TEXT_DOMAIN),
				'return_value' 	=> 'yes',
				'default' 		=> 'no',
			]
		);

		$this->add_control(
			'view_all_switch',
			[
				'label' => __('Use View All Button ?', SE_TEXT_DOMAIN),
				'type' => Controls_Manager::SWITCHER,
				'yes' => __('Yes', SE_TEXT_DOMAIN),
				'no' => __('No', SE_TEXT_DOMAIN),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'use_custom_link_viewall',
			[
				'label' => __('Use View All custom link ?', SE_TEXT_DOMAIN),
				'type' => Controls_Manager::SWITCHER,
				'yes' => __('Yes', SE_TEXT_DOMAIN),
				'no' => __('No', SE_TEXT_DOMAIN),
				'return_value' => 'yes',
				'default' => 'no',
				'condition' => ['view_all_switch' => 'yes'],
			]
		);

		$this->add_control(
			'use_custom_link_text',
			[
				'label' => __('Custom Link Text', SE_TEXT_DOMAIN),
				'type' => Controls_Manager::TEXT,
				'default' => __('Link Text', SE_TEXT_DOMAIN),
				'label_block' => true,
				'condition' => [
					'use_custom_link_viewall' => 'yes',
					'view_all_switch' => 'yes'
				],
			]
		);

		$this->add_control(
			'view_all_custom_link',
			[
				'label' => __('Custom link', SE_TEXT_DOMAIN),
				'type' => Controls_Manager::URL,
				'placeholder' => __('https://your-link.com', SE_TEXT_DOMAIN),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
				'condition' => [
					'use_custom_link_viewall' => 'yes',
					'view_all_switch' => 'yes'
				],
			]
		);

		$this->add_control(
			'post_control_start',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);

		$this->add_control(
			'pagination_start',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);

		$this->add_control(
			'pagination',
			[
				'label'   => __('Pagination type', SE_TEXT_DOMAIN),
				'type'    => Controls_Manager::SELECT,
				'default' => 'loadmore',
				'options' => [
					'yes' 		=> esc_html__('Pagination', SE_TEXT_DOMAIN),
					'loadmore' 	=> esc_html__('Loadmore', SE_TEXT_DOMAIN),
					'infinite' 	=> esc_html__('Infinite Scroll', SE_TEXT_DOMAIN),
					'no' 		=> esc_html__('No Pagination', SE_TEXT_DOMAIN),
				],
				'condition' => ['slider_type' => 'grid']
			]
		);

		$this->add_control(
			'more_text',
			[
				'label' 		=> __('Button text', SE_TEXT_DOMAIN),
				'type' 			=> Controls_Manager::TEXT,
				'default' 		=> __('Load More', SE_TEXT_DOMAIN),
				'label_block' 	=> true,
				'condition' 	=> ['slider_type' => 'grid', 'pagination' => 'loadmore']
			]
		);

		$this->add_control(
			'loading_text',
			[
				'label' 		=> __('Loading button text', SE_TEXT_DOMAIN),
				'type' 			=> Controls_Manager::TEXT,
				'default' 		=> __('Loading...', SE_TEXT_DOMAIN),
				'label_block' 	=> true,
				'condition' 	=> ['slider_type' => 'grid', 'pagination' => 'loadmore']
			]
		);

		$this->add_responsive_control(
			'posts_per_page',
			[
				'label' => __('Posts Per Page', SE_TEXT_DOMAIN),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'unit' => '%',
					'size' => 10,
				]
			]
		);

		$this->end_controls_section();
		$this->start_controls_section(
			'slick_control_section',
			[
				'label' => __('Slider Control', SE_TEXT_DOMAIN),
			]
		);

		require STREAMIT_EXTENSION_PLUGIN_PATH . '/includes/Elementor/Controls/slick-control.php';

		$this->end_controls_section();
	}

	protected function render()
	{
		require 'render.php';
		if (Plugin::$instance->editor->is_edit_mode()) { ?>
			<script>
				(function(jQuery) {
					callSlickSlider(jQuery('.favorites-slider'));
				})(jQuery)
			</script>
<?php
		}
	}
}
