<?php

$terms      = get_the_terms($post_id, 'person_cat');
$title      = get_the_title($post_id);
$image_alt  = $title . '-image';

$slider_image = ($is_grid)
    ? wp_get_attachment_image_src(get_post_thumbnail_id($post_id), $thumbnail_size)[0]
    : wp_get_attachment_image_src(get_post_thumbnail_id($post_id), "medium_large")[0];

if (is_array($slider_image))
    $slider_image = $slider_image[0];

if (isset($lazy_load) && !empty($lazy_load)) {
    $img_class      = ' iqonic-lazy';
    $lazy_image     = get_lazy_load_image();

    $original_image = $slider_image;
    $slider_image   = $lazy_image;
    $srcset         = "data-srcset=" . $original_image . "";
} else {
    $img_class  = '';
    $srcset     = '';
} ?>

<archive class="<?php echo esc_attr($col); ?>">
    <div class=" position-relative">
        <div class="cast-images position-relative d-flex">
            <img src="<?php echo esc_url($slider_image) ?>" class="img-fluid <?php echo esc_attr($img_class); ?>" alt="<?php echo esc_attr($image_alt); ?>" <?php echo esc_attr($srcset); ?>>
        </div>

        <div class="iq-cast-body">
            <div class="iq-person-heading">
                <h6 class="iq-title">
                    <a href="<?php echo get_the_permalink($post_id); ?>"><?php echo esc_html($title) ?></a>
                </h6>

                <div class="iq-person-cats">
                    <?php for ($i = 0; $i < 2 && isset($terms[$i]); $i++) {
                        echo "<span class='iq-person-cat-item'>";
                        echo esc_html($terms[$i]->name);
                        echo "</span>";
                    } ?>
                </div>
            </div>
        </div>
    </div>
</archive>