<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;

$current_page       = 1;
$temp_settings      = '';
$can_be_loaded      = false;
$rand               = rand(10, 100);
$args = $tax_query  = $taxargs = array();

$settings       = $this->get_settings();
$is_grid        = ($settings['slider_type'] == 'grid');
$count          = $settings['posts_per_page']['size'];
$loadmore_btn   = 'person-cards-load-btn-' . $rand;
$paged          = (get_query_var('paged')) ? get_query_var('paged') : 1;
$lazy_load      = $settings['enable_lazy_load_images'] == "yes" ? " iqonic-lazy-load-images" : "";

$args = array(
    'post_type'      => 'person',
    'post_status'    => 'publish',
    'paged'          => $paged,
    'posts_per_page' => $count,
    'order'          => $settings['order'],
    'fields'         => 'ids'
);

if (!empty($settings['iq_select_persons'])) {
    $args['post__in'] = $settings['iq_select_persons'];
}

if (!empty($settings['iq_person_category'])) {
    $tax_query['taxonomy']  = 'person_cat';
    $tax_query['field']     = 'slug';
    $tax_query['terms']     = $settings['iq_person_category'];
    $tax_query['operator']  = 'IN';
    array_push($taxargs, $tax_query);
}

if (!empty($settings['iq_person_tag'])) {
    $tax_query['taxonomy']  = 'person_tag';
    $tax_query['field']     = 'slug';
    $tax_query['terms']     = $settings['iq_person_tag'];
    $tax_query['operator']  = 'IN';
    array_push($taxargs, $tax_query);
}

if (!empty($tax_query)) {
    $args['tax_query']              = $taxargs;
    $args['tax_query']['relation']  = 'OR';
}

$wp_query = new \WP_Query($args);
$post_ids = $wp_query->posts;

if (!$is_grid) {
    $align = 'favorites-slider ';
    $col   = 'slide-item iq-persons col-12';

    $this->add_render_attribute('slider', 'data-nav',               $settings['nav-arrow']);
    $this->add_render_attribute('slider', 'data-items',             $settings['desk_number']);
    $this->add_render_attribute('slider', 'data-items-laptop',      $settings['lap_number']);
    $this->add_render_attribute('slider', 'data-items-tab',         $settings['tab_number']);
    $this->add_render_attribute('slider', 'data-items-mobile',      $settings['mob_number']);
    $this->add_render_attribute('slider', 'data-items-mobile-sm',   $settings['mob_number']);
    $this->add_render_attribute('slider', 'data-autoplay',          $settings['autoplay']);
    $this->add_render_attribute('slider', 'data-autoplay-speed',    $settings['autoplay_speed']);
    $this->add_render_attribute('slider', 'data-infinite',          $settings['infinite']);
    $this->add_render_attribute('slider', 'data-speed',             $settings['speed']);
} else {
    $align = 'favorites-grid';
    $grid_style = [
        '1' =>
        [
            "class"         => "col-12 iq-persons",
            "landscape"     => "full"
        ],
        '2' => [
            "class"         => "col-lg-6 col-md-6 col-sm-6 iq-persons",
            "landscape"     => "large"
        ],
        '3' => [
            "class"         => "col-lg-4 col-md-4 col-sm-6 iq-persons",
            "landscape"     => "medium_large"
        ],
        '4' => [
            "class"         => "col-xl-3 col-lg-4 col-md-4 col-sm-6 col-6 iq-persons",
            "landscape"     => "medium_large"
        ],
        '6' => [
            "class"         => "col-xl-2 col-lg-3 col-md-3 col-sm-4 col-6 iq-persons",
            "landscape"     => "medium_large"
        ],
    ];

    $total_pages       = $wp_query->max_num_pages;
    $can_be_loaded     = ($total_pages > 1) ? true : false;

    $col            = $grid_style[$settings['person_grid_style']]["class"];
    $thumbnail_size = $grid_style[$settings['person_grid_style']]['landscape'];

    $temp_settings = [
        'is_grid'           => $is_grid,
        'col'               => $col,
        'thumbnail_size'    => $thumbnail_size,
        'lazy_load'         => $lazy_load
    ];
}

if ($wp_query->post_count > 4) $align .= 'iq-rtl-direction';
if (isset($settings['nav-arrow-style']) && $settings['nav-arrow-style'] == 'style-2') $align .= ' iq-arrow-2'; ?>

<div class="iq_person-contents favorites-contens streamit_datapass_person iq-ajax-content <?php echo esc_attr($lazy_load); ?>" data-options="<?php echo esc_attr($settings['pagination']); ?>" data-can-beloaded="<?php echo esc_attr($can_be_loaded); ?>">
    <?php if (!empty($post_ids)) :
        $title_tag = 'h4';
        $slider_title = $settings['slider_title'];
        echo streamit_get_shortcode_title($slider_title, $title_tag, false); ?>
    <?php endif; ?>

    <div class="<?php echo esc_html($align); ?> archive list-grid list-inline row p-0 mb-0 row" <?php echo $this->get_render_attribute_string('slider'); ?>>
        <?php if ($wp_query->have_posts()) {
            foreach ($post_ids as $post_id) {
				require trailingslashit(plugin_dir_path(__FILE__)) . 'template.php';
            }
            wp_reset_postdata();
        } ?>
    </div>

    <?php if ($is_grid && $can_be_loaded && $settings['pagination'] == 'yes') {
        streamit_get_numbers_pagination($total_pages);
    } elseif ($is_grid && $can_be_loaded && $settings['pagination'] == 'infinite' && $total_pages > 1) {
        echo '<div class="loader-wheel-container"></div>';
    } ?>
</div>

<?php if ($can_be_loaded) { ?>
    <div class="loader-wheel-container">
        <?php if ($is_grid && $settings['pagination'] == 'loadmore' && $total_pages > 1) : ?>
            <div class="<?php echo esc_attr($loadmore_btn); ?>">
                <div class="btn btn-hover iq-button">
                    <span><?php echo !empty($settings['more_text']) ? esc_html($settings['more_text']) : '' ?></span>
                </div>
            </div>
        <?php endif;

        if ($is_grid && $settings['pagination'] == "yes") {
            $current_page  = max(1, get_query_var('paged')) - 1;
        }

        $pagination_args = [
            'action'            => 'loadmore_person',
            'current_page'      => $current_page,
            'total_pages'       => $total_pages,
            'loadmore_btn'      => $loadmore_btn,
            'loading_text'      => $settings['loading_text'],
            'query_args'        => $args,
            'temp_settings'     => $temp_settings,
            'posts_per_page'    => $count,
        ];

        streamit_get_pagination_args($pagination_args); ?>
    </div>
<?php }
