<?php

namespace Iqonic\Elementor\Elements\Persons;

use Elementor\Plugin;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit;

class Widget extends Widget_Base
{
	public function get_name()
	{
		return 'Iq_Persons';
	}

	public function get_title()
	{
		return esc_html__('Persons', 'streamit-extensions');
	}

	public function get_categories()
	{
		return ['streamit-extension'];
	}

	public function get_icon()
	{
		return 'eicon-person';
	}

	protected function register_controls()
	{
		$this->start_controls_section(
			'section_persons',
			[
				'label' => __('Persons', 'streamit-extensions'),
			]
		);

		$this->add_control(
			'slider_title',
			[
				'label' => __('Title', 'streamit-extensions'),
				'type' => Controls_Manager::TEXT,
				'default' => __('Title', 'streamit-extensions'),
				'label_block' => true,
			]
		);

		$this->add_control(
			'slider_type',
			[
				'label' => __('Style', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT,
				'label_block' => true,
				'multiple' => true,
				'options' => [
					'slider' => __('Slider', 'streamit-extensions'),
					'grid' => __('Grid', 'streamit-extensions')
				],
				'default' => 'slider'
			]
		);

		$this->add_control(
			'enable_lazy_load_images',
			[
				'label'         => __('Lazy Load Images', 'streamit-extensions'),
				'type'          => Controls_Manager::SWITCHER,
				'yes'           => __('Yes', 'streamit-extensions'),
				'no'            => __('No', 'streamit-extensions'),
				'return_value'  => 'yes',
				'default'       => 'no',
			]
		);

		$this->add_control(
			'person_grid_style',
			[
				'label'      => __('Persons Grid', 'streamit-extensions'),
				'type'       => Controls_Manager::SELECT,
				'default'    => '4',
				'options'    => [
					'1'            => __('One', 'streamit-extensions'),
					'2'          => __('Two', 'streamit-extensions'),
					'3'          => __('Three', 'streamit-extensions'),
					'4'          => __('Four', 'streamit-extensions'),
					'6'          => __('Six', 'streamit-extensions'),
				],
				'condition' => ['slider_type' => 'grid']
			]
		);

		$this->add_control(
			'iq_select_persons',
			[
				'label' => __('Select Persons', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT2,
				'label_block' => true,
				'multiple' => true,
				'options' => isset($_REQUEST['editor_post_id']) ? iq_custom_post_data('person', false) : [],
			]
		);

		$this->add_control(
			'iq_person_category',
			[
				'label' => __('Display Specific Categories', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT2,
				'label_block' => true,
				'multiple' => true,
				'options' => isset($_REQUEST['editor_post_id']) ? iq_get_custom_taxonomy('person_cat') : [],
			]
		);

		$this->add_control(
			'iq_person_tag',
			[
				'label' => __('Display Specific Tags', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT2,
				'label_block' => true,
				'multiple' => true,
				'options' => isset($_REQUEST['editor_post_id']) ? iq_get_custom_taxonomy('person_tag') : [],
			]
		);

		$this->add_control(
			'order',
			[
				'label'   => __('Order By', 'streamit-extensions'),
				'type'    => Controls_Manager::SELECT,
				'default' => 'ASC',
				'options' => [
					'DESC' => esc_html__('Descending', 'streamit-extensions'),
					'ASC' => esc_html__('Ascending', 'streamit-extensions')
				],
				'condition' => ['post_view_type' => ['none', 'upcoming']],
			]
		);

		$this->add_control(
			'pagination',
			[
				'label'   => __('Show Pagintion/Loadmore/Infinite', 'streamit-extensions'),
				'type'    => Controls_Manager::SELECT,
				'default' => 'loadmore',
				'label_block' => true,
				'options' => [
					'yes' => esc_html__('Pagination', 'streamit-extensions'),
					'loadmore' => esc_html__('Loadmore', 'streamit-extensions'),
					'infinite' => esc_html__('Infinite Scroll', 'streamit-extensions'),
					'no' => esc_html__('No Pagination', 'streamit-extensions'),
				],
				'condition' => ['slider_type' => 'grid']
			]
		);

		$this->add_control(
			'more_text',
			[
				'label' => __('Load More button text', 'streamit-extensions'),
				'type' => Controls_Manager::TEXT,
				'default' => __('Load More', 'streamit-extensions'),
				'label_block' => true,
				'condition' => ['slider_type' => 'grid', 'pagination' => 'loadmore']
			]
		);

		$this->add_control(
			'loading_text',
			[
				'label' => __('Loading button text', 'streamit-extensions'),
				'type' => Controls_Manager::TEXT,
				'default' => __('Loading...', 'streamit-extensions'),
				'label_block' => true,
				'condition' => ['slider_type' => 'grid', 'pagination' => 'loadmore']
			]
		);

		$this->add_responsive_control(
			'posts_per_page',
			[
				'label' => __('Posts Per Page', 'streamit-extensions'),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'unit' => '%',
					'size' => 10,
				]
			]
		);

		$this->end_controls_section();
		$this->start_controls_section(
			'slick_control_section',
			[
				'label' => __('Slider Control', 'streamit-extensions'),
				'condition' => ['slider_type' => ['slider']],
			]
		);

		require STREAMIT_EXTENSION_PLUGIN_PATH . '/includes/Elementor/Controls/slick-control.php';

		$this->end_controls_section();
	}

	protected function render()
	{
		require 'render.php';

		if (Plugin::$instance->editor->is_edit_mode()) { ?>
			<script>
				(function(jQuery) {
					callSlickSlider(jQuery('.favorites-slider'));
					personAjaxHandler();
				})(jQuery)
			</script>
<?php
		}
	}
}
