<?php

namespace Elementor;

global $pmpro_currency_symbol, $pmpro_currencies, $pmpro_currency, $current_user, $streamit_options;

$settings = $this->get_settings();

$repeater = $settings['tabs'];

$active_plan_class  = '';
$is_user_logged_in  = is_user_logged_in();
$pmpro_plan_id      = $settings['pmp_pricing_plan_id'];

$level = function_exists('pmpro_getLevel') ? pmpro_getLevel($settings['pmp_pricing_plan_id']) : '';

if (empty($level)) return;

$period             = $level->cycle_period;
$period_number      = $level->cycle_number;
$is_plan_free       = pmpro_isLevelFree($level);
$pmpro_product_id   = get_pmpro_membership_level_meta($pmpro_plan_id, "_plan_product_id", true);

if (is_plugin_active("pmpro-woocommerce/pmpro-woocommerce.php") && !empty($pmpro_product_id)) {
    $gateway = "woocommerce_payment_gateway";
} else {
    $gateway = '';
}

if ($period_number == 0 && $period == "Day") {
    $period_text = esc_html__('Month', SE_TEXT_DOMAIN);
} else {
    //$period_text = $period_number . ' ' . $period;
    $period_text = $period;
}

if (!empty($pmpro_currencies[$pmpro_currency]) && is_array($pmpro_currencies[$pmpro_currency])) {
    if (isset($pmpro_currencies[$pmpro_currency]['symbol'])) {
        $pmpro_currency_symbol = $pmpro_currencies[$pmpro_currency]['symbol'];
    } else {
        $pmpro_currency_symbol = '';
    }
}

$pmpro_currency_symbol = apply_filters("streamit_pmpro_currency_symbol", $pmpro_currency_symbol);

$initial_payment = $level->initial_payment;
$billing_amount = $level->billing_amount;

$expiration_number = $level->expiration_number;
$expiration_period = $level->expiration_period;

$user_level = pmpro_getSpecificMembershipLevelForUser($current_user->ID, $level->id);
$has_level  = !empty($user_level);

if ($has_level) {
    //if it's a one-time-payment level, offer a link to renew
    if (pmpro_isLevelExpiringSoon($user_level) && $level->allow_signups) {
        if ($gateway == "woocommerce_payment_gateway") {
            if ($is_plan_free) {
                $pmpro_checkout_page_link = pmpro_url("checkout", "?level=" . $level->id, "https");
            } else {
                $pmpro_checkout_page_link = get_page_link($settings['pmp_registration_page']) . '?plan_id=' . $pmpro_plan_id . '&product_id=' . $pmpro_product_id;
            }
        } else {
            $pmpro_checkout_page_link = esc_url(pmpro_url("checkout", "?level=" . $level->id, "https"));
        }
    } else {
        $pmpro_checkout_page_link   = esc_url(pmpro_url("account"));
        $account_page_text          = esc_html($settings['account_exists']);
        $active_plan                = esc_html__("Active", SE_TEXT_DOMAIN);
        $active_plan_class          = "membership-active";
    }
} else {
    if ($gateway == "woocommerce_payment_gateway") {
        if ($is_plan_free) {
            $pmpro_checkout_page_link = pmpro_url("checkout", "?level=" . $level->id, "https");
        } else {
            $pmpro_checkout_page_link = get_page_link($settings['pmp_registration_page']) . '?plan_id=' . $pmpro_plan_id . '&product_id=' . $pmpro_product_id;
        }
    } else {
        $pmpro_checkout_page_link = esc_url(pmpro_url("checkout", "?level=" . $level->id, "https"));
    }
}

if (!$has_level && $settings['show_discount_code'] == "yes" && !empty($settings['discount_code']) && function_exists('pmpro_checkDiscountCode') && pmpro_checkDiscountCode($settings['discount_code'])) {
    $pmpro_checkout_page_link .= '&discount_code=' . $settings['discount_code'];
} ?>

<div class="streamit-pmp-pricing-plans-wrapper <?php echo esc_attr($active_plan_class); ?>" id="pmpro_levels_table" data-gateway="<?php echo esc_attr($gateway) ?>" data-plan_id="<?php echo esc_attr($pmpro_plan_id); ?>" data-product_id="<?php echo esc_attr($settings['pmp_attach_woo_product']); ?>" data-redirect_url="<?php echo esc_url($pmpro_checkout_page_link); ?>">
    <?php if ($settings['show_discount_banner'] == "yes") { ?>
        <div class="pricing-plan-discount">
            <span class="plan-offer"> <?php echo esc_html($settings['discount_text']); ?> </span>
        </div>
    <?php } ?>

    <div class="pricing-plan-header">
        <?php if (!empty($settings['image']['url'])) {
            echo '<img class="img-fluid" src="' . esc_url($settings['image']['url']) . '" alt="">';
        } ?>

        <div class="plan-wrapper">
            <h4 class="plan-name"><?php echo esc_html($level->name) ?></h4>

            <?php if (isset($active_plan) && !empty($active_plan)) { ?>
                <span class="active-plan"><?php echo esc_html($active_plan) ?></span>
            <?php } ?>
        </div>
        <div class="plan-meta-details">
            <div class="plan-period">
                <?php if ($settings['show_sale_price'] == "yes") { ?>
                    <span class="sale-price">
                        <?php echo esc_html($pmpro_currency_symbol);
                        echo esc_html($settings['sale_price']); ?>
                    </span>
                <?php } ?>

                <?php if ($initial_payment > 0) { ?>
                    <span class="main-price">
                        <?php echo esc_html($pmpro_currency_symbol);
                        echo esc_html($initial_payment); ?>
                    </span>
                <?php }

                if ($billing_amount !== $initial_payment) {
                    echo '<span class="streamit-billing_amount">';
                    esc_html_e('Now and ', 'streamit-extensions');
                    echo esc_html($pmpro_currency_symbol);
                    echo esc_html($billing_amount);
                    echo '</span>';
                } ?>

                <?php if ($initial_payment > 0) { ?>
                    <span class="plan-date-pack">/ <?php echo esc_html($period_text); ?></span>
                <?php } ?>
            </div>

            <?php if (function_exists('pmprosd_getDelay')) {
                $trial_period = (int)pmprosd_getDelay($settings['pmp_pricing_plan_id']);
                if (!empty($trial_period)) { ?>
                    <div class="trail-period">
                        <?php echo esc_html__(sprintf("%d Day(s) Trial Period.", $trial_period), SE_TEXT_DOMAIN); ?>
                    </div>
            <?php }
            } ?>

            <div class="plan_expiration">
                <?php if ($settings['show_expiration'] == "yes" && $expiration_number > 0 && $expiration_period != '') {
                    echo esc_html__(sprintf("Membership expires after %d %s", $expiration_number, $expiration_period), SE_TEXT_DOMAIN);
                } ?>
            </div>
        </div>
    </div>

    <div class="wrap-details-pricing">
        <?php if ($settings['show_description'] == "yes") { ?>
            <div class="plan_description">
                <?php if (!empty($level->description)) {
                    echo esc_html($level->description);
                } ?>
            </div>
        <?php }

        if ($level->allow_signups !== '1') {
            echo esc_html__("Signup has been disabled for this plan", SE_TEXT_DOMAIN);
        } else { ?>
            <div class="pricing-plan-description">
                <ul>
                    <?php foreach ($repeater as $repeater_data) { ?>
                        <li>
                            <i class="<?php echo esc_attr($repeater_data['tab_icon']['value']) ?>"></i>
                            <span class="plan-dec"> <?php echo esc_html($repeater_data['plan_description']); ?> </span>
                        </li>
                    <?php } ?>
                </ul>
            </div>

            <div class="pricing-plan-footer">
                <?php $additional_discount = '';

                if ($streamit_options['show_additional_discount'] == "yes") {
                    $date = date('m/d/Y');

                    if (!empty($streamit_options['additional_discount_price_start_date']) && !empty($streamit_options['additional_discount_price_end_date'])) {
                        if ($date >= $streamit_options['additional_discount_price_start_date'] && $date <= $streamit_options['additional_discount_price_end_date']) {
                            $additional_discount .= $streamit_options['additional_discount_price'];
                        }
                    }
                }

                if (isset($account_page_text) && !empty($account_page_text)) {
                    $value = $account_page_text;
                } else {
                    $value = esc_html__("Select ", SE_TEXT_DOMAIN) . $level->name;
                } ?>

                <?php if ($gateway == "woocommerce_payment_gateway") { ?>
                    <a class="pmpro_pricing_plan" href="<?php echo esc_url($pmpro_checkout_page_link); ?>" method="POST">
                        <button name="select_pmpro_plan" class="btn btn-hover iq-button w-100">
                            <?php echo esc_html($value); ?>
                        </button>

                        <input type="hidden" name="original_price" value="<?php echo esc_attr($pmpro_currency_symbol . $initial_payment); ?>">
                        <input type="hidden" name="additional_discount" value="<?php echo esc_attr($additional_discount); ?>">
                    </a>
                <?php
                } else { ?>
                    <form name="pmpro_pricing_plan" action="<?php echo esc_url($pmpro_checkout_page_link); ?>" method="POST">
                        <button name="select_pmpro_plan" class="btn btn-hover iq-button w-100">
                            <?php echo esc_html($value); ?>
                        </button>

                        <input type="hidden" name="original_price" value="<?php echo esc_attr($pmpro_currency_symbol . $initial_payment); ?>">
                        <input type="hidden" name="additional_discount" value="<?php echo esc_attr($additional_discount); ?>">
                    </form>
                <?php } ?>

            </div>
        <?php } ?>
    </div>
</div>