<?php

namespace Iqonic\Elementor\Elements\PMP_Pricing;

use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit;

class Widget extends Widget_Base
{
	public function get_name()
	{
		return 'iq_pmp_pricing';
	}

	public function get_title()
	{
		return esc_html__('PMP Pricing Plan', 'streamit-extensions');
	}

	public function get_categories()
	{
		return ['streamit-extension'];
	}

	public function get_icon()
	{
		return 'eicon-price-plan';
	}

	protected function register_controls()
	{
		$this->start_controls_section(
			'section_persons',
			[
				'label' => __('PMP Pricing Plan', 'streamit-extensions'),
			]
		);

		$this->add_control(
			'pmp_pricing_plan_id',
			[
				'label'      => __('Select PMP Pricing Plan To Display', 'streamit-extensions'),
				'label_block' => true,
				'type'       => Controls_Manager::SELECT,
				'options'    => isset($_REQUEST['editor_post_id']) ? streamit_pmp_subscription_plan_list() : [],
			]
		);

		if (is_plugin_active("pmpro-woocommerce/pmpro-woocommerce.php")) {
			$this->add_control(
				'pmp_registration_page',
				[
					'label'      	=> __('Select Regisration Page For Guest Users', 'streamit-extensions'),
					'label_block' 	=> true,
					'type'       	=> Controls_Manager::SELECT,
					'options' 		=> isset($_REQUEST['editor_post_id']) ? iq_custom_post_data('page', false, true) : [],
				]
			);
		}

		$this->add_control(
			'show_discount_code',
			[
				'label'      => __('Apply Discount Code Directly At Checkout', 'streamit-extensions'),
				'type'       => Controls_Manager::SWITCHER,
				'label_on'   => __("Yes", 'streamit-extensions'),
				'label_off'   => __("No", 'streamit-extensions'),
			]
		);

		$this->add_control(
			'discount_code',
			[
				'label'      => __('Select Discount Code', 'streamit-extensions'),
				'label_block' => true,
				'type'       => Controls_Manager::SELECT,
				'options'    => isset($_REQUEST['editor_post_id']) ? streamit_pmp_discount_code_list() : [],
				'condition'   => [
					'show_discount_code' => 'yes'
				]
			]
		);

		$this->add_control(
			'show_sale_price',
			[
				'label'      => __('Show Sale Price', 'streamit-extensions'),
				'type'       => Controls_Manager::SWITCHER,
				'label_on'   => __("Yes", 'streamit-extensions'),
				'label_off'   => __("No", 'streamit-extensions'),
			]
		);

		$this->add_control(
			'sale_price',
			[
				'label'      => __('Enter Sale Price', 'streamit-extensions'),
				'type'       => Controls_Manager::TEXT,
				'condition'   => [
					'show_sale_price' => 'yes'
				]
			]
		);

		$this->add_control(
			'show_discount_banner',
			[
				'label'      => __('Show Discount Banner', 'streamit-extensions'),
				'type'       => Controls_Manager::SWITCHER,
				'label_on'   => __("Yes", 'streamit-extensions'),
				'label_off'   => __("No", 'streamit-extensions'),
			]
		);

		$this->add_control(
			'discount_text',
			[
				'label'      => __('Enter Discount Text', 'streamit-extensions'),
				'type'       => Controls_Manager::TEXT,
				'default'	 => __("Save 20%", 'streamit-extensions'),
				'condition'   => [
					'show_discount_banner' => 'yes'
				]
			]
		);

		$this->add_control(
			'show_description',
			[
				'label'      => __('Show Description', 'streamit-extensions'),
				'type'       => Controls_Manager::SWITCHER,
				'label_on'   => __("Yes", 'streamit-extensions'),
				'label_off'   => __("No", 'streamit-extensions'),
			]
		);

		$this->add_control(
			'show_expiration',
			[
				'label'      => __('Show Expiration Information (if any)', 'streamit-extensions'),
				'type'       => Controls_Manager::SWITCHER,
				'label_on'   => __("Yes", 'streamit-extensions'),
				'label_off'   => __("No", 'streamit-extensions'),
			]
		);

		$this->add_control(
			'account_exists',
			[
				'label'      => __('Text to display when account already exists with the selected plan', 'streamit-extensions'),
				'type'       => Controls_Manager::TEXT,
				'label_block' => true,
				'default'	 => __("My Account", SE_TEXT_DOMAIN),
			]
		);

		$this->add_control(
			'image',
			[
				'label' => __('Choose Image', 'streamit-extensions'),
				'type' => Controls_Manager::MEDIA,
				'dynamic' => [
					'active' => true,
				],
			]
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'tab_icon',
			[
				'label' => __('Select Icon', 'streamit-extensions'),
				'type' => Controls_Manager::ICONS,
				'fa4compatibility' => 'icon',
				'default' => [
					'value' => 'fas fa-check'
				],
			]
		);

		$repeater->add_control(
			'plan_description',
			[
				'default' => __('It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout.', 'streamit-extensions'),
				'placeholder' => __('Tab Content', 'streamit-extensions'),
				'type' => Controls_Manager::TEXTAREA,
				'show_label' => false,
			]
		);

		$this->add_control(
			'tabs',
			[
				'label' => __('Tabs Items', 'streamit-extensions'),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'plan_description' => __('Lorem ipsum', 'streamit-extensions'),
					]
				],
				'title_field' => '{{{ plan_description }}}',
			]
		);

		$this->end_controls_section();
	}

	protected function render()
	{
		require 'render.php';
	}
}
