<?php

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;

$this->start_controls_section(
    'section_menu_style',
    [
        'label' => __('Menu', 'streamit-extensions'),
        'tab' => Controls_Manager::TAB_STYLE,
        'condition' => ['layout' => 'default'],
    ]
);

$this->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name' => 'mobile_typography',
        'label' => __('Typography', 'streamit-extensions'),
        'selector' => '{{WRAPPER}} .sf-menu > li > a,{{WRAPPER}} .streamit-mobile-menu.vertical-menu-layout .navbar-nav>li>a ',
    ]
);

$this->add_control(
    'streamit_menu_height',
    [
        'label' => __('Height', 'streamit-extensions'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'vh'],
        'range' => [
            'px' => [
                'min' => 0,
                'max' => 1000,
            ],
            '%' => [
                'min' => 0,
                'max' => 100,
            ],
            'vh' => [
                'min' => 0,
                'max' => 100,
            ],
        ],
        'condition' => ['direction' => 'vertical'],
        'selectors' => [
            '{{WRAPPER}} .verticle-mn' => 'height: {{SIZE}}{{UNIT}};',
        ],
    ]
);

$this->add_responsive_control(
    'menu_align',
    [
        'label' => __('Alignment', 'streamit-extensions'),
        'type' => Controls_Manager::CHOOSE,
        'options' => [
            'left'    => [
                'title' => __('Left', 'streamit-extensions'),
                'icon' => 'eicon-text-align-left',
            ],
            'center' => [
                'title' => __('Center', 'streamit-extensions'),
                'icon' => 'eicon-text-align-center',
            ],
            'right' => [
                'title' => __('Right', 'streamit-extensions'),
                'icon' => 'eicon-text-align-right',
            ],
        ],
        'default' => 'left',
        'selectors' => [
            '{{WRAPPER}} .widget-nav-menu .menu-main-menu-container .navbar-nav,{{WRAPPER}} .streamit-menu-wrapper.mobile-menu .navbar ' => 'text-align: {{VALUE}}',
            '{{WRAPPER}} .widget-nav-menu nav.navbar .iq-menu' => 'text-align: {{VALUE}}',

        ],
    ]
);

$this->start_controls_tabs('menu_tabs');
$this->start_controls_tab(
    'tabs_menujeBef122kCfHObvih40638',
    [
        'label' => __('Normal', 'streamit-extensions'),
    ]
);

$this->add_control(
    'text_color',
    [
        'label' => __('Choose color', 'streamit-extensions'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .sf-menu > li > a,{{WRAPPER}} .streamit-mobile-menu.vertical-menu-layout .navbar-nav>li>a,{{WRAPPER}} .streamit-mobile-menu.vertical-menu-layout .navbar-nav li>.toggledrop i'  => 'color: {{VALUE}};'
        ],
    ]
);

$this->end_controls_tab();

$this->start_controls_tab(
    'tabs_menuaJ0C3kdUtggtL5G4tW12awyR',
    [
        'label' => __('Active/Hover', 'streamit-extensions'),
    ]
);

$this->add_control(
    'text_hover_color',
    [
        'label' => __('Choose color', 'streamit-extensions'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .sf-menu li:hover > a,{{WRAPPER}} .sf-menu li.current-menu-ancestor > a,{{WRAPPER}} .sf-menu  li.current-menu-item > a ,{{WRAPPER}} .streamit-mobile-menu.vertical-menu-layout .navbar-nav li.current-menu-item>.toggledrop i,{{WRAPPER}} .streamit-mobile-menu.vertical-menu-layout .navbar-nav li.current-menu-item>a,{{WRAPPER}} .streamit-mobile-menu.vertical-menu-layout .navbar-nav li .sub-menu li:hover>a,{{WRAPPER}} .streamit-mobile-menu.vertical-menu-layout .navbar-nav li:hover>.toggledrop i,{{WRAPPER}} .streamit-mobile-menu.vertical-menu-layout .navbar-nav li:hover>a,{{WRAPPER}} .streamit-mobile-menu.vertical-menu-layout ul>li.current-menu-ancestor>.toggledrop i,{{WRAPPER}} .streamit-mobile-menu.vertical-menu-layout ul>li.current-menu-ancestor>a,{{WRAPPER}} .streamit-mobile-menu.vertical-menu-layout ul li .sub-menu li.current-menu-item>a,{{WRAPPER}} .streamit-mobile-menu.vertical-menu-layout ul li .sub-menu li.menu-item.current-menu-ancestor>a ,
            {{WRAPPER}} .sf-menu li.sfHover>a' => 'color: {{VALUE}};'
        ],
    ]
);


$this->end_controls_tab();
$this->end_controls_tabs();

$this->add_responsive_control(
    'menu_parent_padding',
    [
        'label' => __('Padding', 'streamit-extensions'),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors' => [
            '{{WRAPPER}}  .sf-menu > li, {{WRAPPER}} .streamit-full-menu .navbar-nav > li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$this->add_responsive_control(
    'menu_parent_margin',
    [
        'label' => __('Margin', 'streamit-extensions'),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors' => [
            '{{WRAPPER}}  .sf-menu > li, {{WRAPPER}} .streamit-full-menu .navbar-nav > li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$this->end_controls_section();

$this->start_controls_section(
    'section_border4tW12awyR',
    [
        'label' => __('Border', 'streamit-extensions'),
        'tab' => Controls_Manager::TAB_STYLE,
        'condition' => [
            'layout' => 'default',
            'hover_effect' => 'top-border'
        ]
    ]
);

$this->add_control(
    'streamit_menu_border_color',
    [
        'label' => __('Border Color', 'streamit-extensions'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .menu-hover-top-border .sf-menu > li > a::before' => 'background: {{VALUE}};',
        ],
    ]
);

$this->add_control(
    'streamit_menu_border_width',
    [
        'label' => __('Border Height', 'streamit-extensions'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', '%'],
        'range' => [
            'px' => [
                'min' => 0,
                'max' => 1000,
            ],
            '%' => [
                'min' => 0,
                'max' => 100,
            ],
        ],
        'selectors' => [
            '{{WRAPPER}} .menu-hover-top-border .sf-menu > li > a::before' => 'height: {{SIZE}}{{UNIT}};',
        ],

    ]
);
$this->end_controls_section();

$this->start_controls_section(
    'section_background4tW12awyR',
    [
        'label' => __('Background', 'streamit-extensions'),
        'tab' => Controls_Manager::TAB_STYLE,
        'condition' => [
            'layout' => 'default',
            'hover_effect' => 'background'
        ]
    ]
);

$this->add_control(
    'streamit_menu_bg_color',
    [
        'label' => __('Background Color', 'streamit-extensions'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .menu-hover-background .sf-menu > li:hover > a,{{WRAPPER}} .menu-hover-background .sf-menu li.current-menu-ancestor > a,{{WRAPPER}} .menu-hover-background .sf-menu li.current-menu-item > a' => 'background: {{VALUE}} !important;',
        ],
    ]
);

$this->end_controls_section();

$this->start_controls_section(
    'section_submenu_style',
    [
        'label' => __('Sub Menu', 'streamit-extensions'),
        'tab' => Controls_Manager::TAB_STYLE,
        'condition' => [
            'direction' => 'horizontal',
        ]
    ]
);

$this->add_group_control(
    Group_Control_Background::get_type(),
    [
        'name' => 'submenu_bg_background',
        'label' => __('Submenu Background', 'streamit-extensions'),
        'types' => ['classic', 'gradient'],
        'selector' => '{{WRAPPER}} .sf-menu ul.sub-menu',
    ]
);

$this->add_responsive_control(
    'submenu_parent_padding',
    [
        'label' => __('Padding', 'streamit-extensions'),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%'],
        'selectors' => [
            '{{WRAPPER}}  .sf-menu ul.sub-menu' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$this->add_control(
    'section_vl8vK4162c',
    [
        'label' => __('Inner Menu', 'streamit-extensions'),
        'type' => Controls_Manager::HEADING,
        'separator' => 'before',
    ]
);

$this->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name' => 'submenu_typography',
        'label' => __('Typography', 'streamit-extensions'),
        'selector' => '{{WRAPPER}} .sf-menu ul.sub-menu a ,{{WRAPPER}} .streamit-mobile-menu.vertical-menu-layout .navbar-nav li .sub-menu li a',
    ]
);

$this->start_controls_tabs('submenu_tabs');
$this->start_controls_tab(
    'tabs_submenujeBef1kCfHObvih40638',
    [
        'label' => __('Normal', 'streamit-extensions'),
    ]
);

$this->add_control(
    'submenu_text_color',
    [
        'label' => __('Choose color', 'streamit-extensions'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .sf-menu ul.sub-menu a,{{WRAPPER}} .streamit-mobile-menu.vertical-menu-layout .navbar-nav li .sub-menu li a,{{WRAPPER}} .streamit-mobile-menu.vertical-menu-layout .navbar-nav li li>.toggledrop i'  => 'color: {{VALUE}};'
        ],
    ]
);

$this->add_control(
    'streamit_submenu_bg_color',
    [
        'label' => __('Background Color', 'streamit-extensions'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .sf-menu ul.sub-menu li' => 'background: {{VALUE}};',
        ],
    ]
);

$this->end_controls_tab();

$this->start_controls_tab(
    'tabs_submenuaJ0C3kdUtg5G4tW12awyR',
    [
        'label' => __('Active/Hover', 'streamit-extensions'),
    ]
);

$this->add_control(
    'submenu_text_hover_color',
    [
        'label' => __('Choose color', 'streamit-extensions'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .sf-menu .sub-menu li.sfHover>a, {{WRAPPER}} .sf-menu  .sub-menu li:hover>a, {{WRAPPER}} .sf-menu .sub-menu li.current-menu-ancestor>a,{{WRAPPER}} .sf-menu .sub-menu li.current-menu-item>a,{{WRAPPER}} .sf-menu ul.sub-menu>li.menu-item.current-menu-parent>a,{{WRAPPER}} .sf-menu ul .sub-menu li.current-menu-parent>a,{{WRAPPER}} .sf-menu ul li .sub-menu li.current-menu-item>a ,{{WRAPPER}} .streamit-mobile-menu.vertical-menu-layout .navbar-nav  .sub-menu li.current-menu-item > .toggledrop i,{{WRAPPER}} .streamit-mobile-menu.vertical-menu-layout .navbar-nav  .sub-menu li.current-menu-item > a,{{WRAPPER}} .streamit-mobile-menu.vertical-menu-layout .navbar-nav li .sub-menu li:hover > a,{{WRAPPER}} .streamit-mobile-menu.vertical-menu-layout .navbar-nav li:hover > .toggledrop i,{{WRAPPER}} .streamit-mobile-menu.vertical-menu-layout .navbar-nav li:hover > a,{{WRAPPER}} .streamit-mobile-menu.vertical-menu-layout ul > li.current-menu-ancestor > .toggledrop i,{{WRAPPER}} .streamit-mobile-menu.vertical-menu-layout ul > li.current-menu-ancestor > a,{{WRAPPER}} .streamit-mobile-menu.vertical-menu-layout ul li .sub-menu li.current-menu-item > a,{{WRAPPER}} .streamit-mobile-menu.vertical-menu-layout ul li .sub-menu li.menu-item.current-menu-ancestor > a' => 'color: {{VALUE}};'
        ],
    ]
);

$this->add_control(
    'streamit_submenu_hover_bg_color',
    [
        'label' => __('Background Color', 'streamit-extensions'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .sf-menu ul.sub-menu li:hover,{{WRAPPER}} .sf-menu ul.sub-menu li.current-menu-item' => 'background: {{VALUE}};'
        ],
    ]
);

$this->end_controls_tab();
$this->end_controls_tabs();

$this->add_responsive_control(
    'submenu_padding',
    [
        'label' => __('Padding', 'streamit-extensions'),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors' => [
            '{{WRAPPER}}  .sf-menu ul.sub-menu li ,{{WRAPPER}} .streamit-mobile-menu.vertical-menu-layout .navbar-nav li .sub-menu li a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$this->add_responsive_control(
    'submenu_margin',
    [
        'label' => __('Margin', 'streamit-extensions'),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors' => [
            '{{WRAPPER}}  .sf-menu ul.sub-menu li ,{{WRAPPER}} .streamit-mobile-menu.vertical-menu-layout .navbar-nav li .sub-menu li a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);
$this->end_controls_section();

$this->start_controls_section(
    'section_icon_style',
    [
        'label' => __('Icon', 'streamit-extensions'),
        'tab' => Controls_Manager::TAB_STYLE,
        'condition' => ['layout' => 'burger'],
    ]
);

$this->add_control(
    'icon_color',
    [
        'label' => __('Choose color <br> <span style="color: #5bc0de"> (Note : working only for icon) </span>', 'streamit-extensions'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .menu-btn svg ,{{WRAPPER}} .menu-btn svg path,{{WRAPPER}} .menu-btn i' => 'fill: {{VALUE}}; color: {{VALUE}};'
        ],
        'condition' => ['use_custom_icon' => 'yes'],
    ]
);

$this->add_control(
    'default_icon_color',
    [
        'label' => __('Choose color', 'streamit-extensions'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .menu-btn .line' => 'background-color: {{VALUE}};'
        ],
        'condition' => ['use_custom_icon!' => 'yes'],
    ]
);

$this->add_responsive_control(
    'icon_size',
    [
        'label' => __('Icon Size', 'streamit-extensions'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', '%'],
        'range' => [
            'px' => [
                'min' => 0,
                'max' => 1000,
                'step' => 5,
            ],
            '%' => [
                'min' => 0,
                'max' => 100,
            ],
        ],
        'selectors' => [
            '{{WRAPPER}} .menu-btn svg,{{WRAPPER}} .menu-btn i' => 'font-size: {{SIZE}}{{UNIT}};',
        ],
        'condition' => ['use_custom_icon' => 'yes'],
    ]
);

$this->end_controls_section();

$this->start_controls_section(
    'section_burger_menu_style',
    [
        'label' => __('Menu', 'streamit-extensions'),
        'tab' => Controls_Manager::TAB_STYLE,
        'condition' => ['layout' => 'burger'],
    ]
);

$this->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name' => 'burger_mobile_typography',
        'label' => __('Typography', 'streamit-extensions'),
        'selector' => '{{WRAPPER}} .streamit-mobile-menu .navbar-nav > li > a',
    ]
);

$this->add_control(
    'burger_text_color',
    [
        'label' => __('Menu color', 'streamit-extensions'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .streamit-mobile-menu .navbar-nav > li > a,{{WRAPPER}} .streamit-mobile-menu .navbar-nav li > .toggledrop i'  => 'color: {{VALUE}};'
        ],
    ]
);

$this->add_control(
    'burger_text_hover_color',
    [
        'label' => __('Menu Hover color', 'streamit-extensions'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .streamit-mobile-menu .navbar-nav li.current-menu-item > .toggledrop i,{{WRAPPER}} .streamit-mobile-menu .navbar-nav li.current-menu-item > a,{{WRAPPER}} .streamit-mobile-menu .navbar-nav li .sub-menu li:hover > a,{{WRAPPER}} .streamit-mobile-menu .navbar-nav li:hover > .toggledrop i,{{WRAPPER}} .streamit-mobile-menu .navbar-nav li:hover > a,{{WRAPPER}} .streamit-mobile-menu ul > li.current-menu-ancestor > .toggledrop i,{{WRAPPER}} .streamit-mobile-menu ul > li.current-menu-ancestor > a,{{WRAPPER}} .streamit-mobile-menu ul li .sub-menu li.current-menu-item > a,{{WRAPPER}} .streamit-mobile-menu ul li .sub-menu li.menu-item.current-menu-ancestor > a' => 'color: {{VALUE}};'
        ],
    ]
);

$this->add_control(
    'section_1vK4162c',
    [
        'label' => __('Sub Menu', 'streamit-extensions'),
        'type' => Controls_Manager::HEADING,
        'separator' => 'before',
    ]
);

$this->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name' => 'burger_submobile_typography',
        'label' => __('Sub Menu Typography', 'streamit-extensions'),
        'selector' => '{{WRAPPER}} .streamit-mobile-menu .navbar-nav li .sub-menu li a',
    ]
);

$this->add_control(
    'burger_subenu_text_hover_color',
    [
        'label' => __('Sub Menu color', 'streamit-extensions'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .streamit-mobile-menu .navbar-nav li .sub-menu li a ,{{WRAPPER}} .streamit-mobile-menu .navbar-nav li .sub-menu li svg' => 'color: {{VALUE}};'
        ],
    ]
);

$this->end_controls_section();
