<?php

namespace Elementor;

use Elementor\Plugin;
use Iqonic_Layouts\Classes\Iqonic_Walker_Nav_Menu;


if (!defined('ABSPATH')) exit;

$vertical_menu = $align = '';
$settings = $this->get_settings();

$menu = ["theme_location" => "primary"];
if ($settings['location'] === 'select' && !empty($settings['menu'])) {
    $menu = ["menu" => $settings['menu']];
} else {
    $menu = ["theme_location" => $settings['location']];
}

if ($settings['layout'] === 'default' && $settings['direction'] === 'vertical') {
    $vertical_menu = ' vertical-menu-layout';
    $vertical_menu .= !empty($settings['design_style']) ? ' menu-' . $settings['design_style'] : '';
}

if ($settings['layout'] == 'default' && $settings['direction'] === 'horizontal') {
    $align .= 'menu-hover-' . $settings['hover_effect'];
    if ($settings['use_more'] === 'yes') {
        $align .= ' has-more-menu-attr';
        $this->add_render_attribute('more', 'data-text', $settings['more_text']);
        $this->add_render_attribute('more', 'data-items', $settings['more_item']);
    }
}

$align .= ($settings['menu_align'] == 'center') ? ' menu-align-center' : '';

if (Plugin::$instance->editor->is_edit_mode()) {
    $align .= ' is_preview';
} ?>

<div class="widget-nav-menu <?php echo esc_attr($align); ?>">
    <?php
    if ($settings['layout'] === 'burger') { ?>
        <button class="navbar-toggler custom-toggler ham-toggle" type="button">
            <span class="menu-btn d-inline-block">
                <?php if ($settings['use_custom_icon'] == 'yes') {
                    Icons_Manager::render_icon($settings['selected_icon'], ['aria-hidden' => 'true']);
                } else { ?>
                    <span class="lines one"></span>
                    <span class="lines two"></span>
                    <span class="lines three"></span>
                <?php } ?>
            </span>
        </button>

        <div class="streamit-mobile-menu streamit-navigation-burger">
            <nav class="streamit-menu-wrapper mobile-menu">
                <div class="navbar">
                    <?php get_template_part('template-parts/header/default-header/header', 'logo', ['custom_logo' => isset($settings['responsive_logo']['url']) ? $settings['responsive_logo']['url'] : null]); ?>
                    <button class="navbar-toggler custom-toggler ham-toggle" type="button">
                        <span class="close_btn">
                            <span class="menu_close_icon"><i class="fa fa-times" aria-hidden="true"></i></span>
                        </span>
                    </button>
                </div>

                <div class="c-collapse">
                    <div class="menu-new-wrapper row align-items-center">
                        <div class="menu-scrollbar verticle-mn yScroller col-lg-12">
                            <div class="streamit-full-menu">
                                <?php
                                $args = array_merge($menu, array(
                                    'menu_class' => 'navbar-nav top-menu',
                                ));
                                wp_nav_menu($args); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </nav><!-- #site-navigation -->
        </div>
        <?php } else {
        if ($settings['direction'] === 'vertical') { ?>
            <div class="streamit-mobile-menu streamit-navigation-burger menu-open <?php echo esc_attr($vertical_menu); ?>">
                <nav class="streamit-menu-wrapper mobile-menu">
                    <div class="navbar">
                        <div class="menu-new-wrapper row align-items-center">
                            <div class="menu-scrollbar verticle-mn yScroller col-lg-12">
                                <div class="streamit-full-menu">
                                    <?php
                                    $args = array_merge($menu, array(
                                        'menu_class'    => 'navbar-nav top-menu',
                                    ));
                                    wp_nav_menu($args);
                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </nav><!-- #site-navigation -->
            </div>
        <?php } else {  ?>
            <nav class="navbar deafult-header nav-widget navbar-light p-0 header-default-menu<?php echo esc_attr($vertical_menu); ?>" aria-label="<?php esc_attr_e('Widget menu', 'streamit-extensions'); ?>" <?php echo $this->get_render_attribute_string('more'); ?>>
                <div class="menu-all-pages-container widget-menu-container">
                    <?php
                    $args = array_merge($menu, array(
                        'menu_class'    => 'sf-menu sf-js-enabled sf-arrows iq-menu',
                        'walker'        => new Iqonic_Walker_Nav_Menu(),
                    ));
                    wp_nav_menu($args); ?>
                </div>
            </nav>
    <?php }
    } ?>
</div>
<?php
