<?php

namespace Iqonic\Elementor\Elements\Navigation;

use Elementor\Plugin;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit;

class Widget extends Widget_Base
{
    public function get_name()
    {
        return 'iqonic_navigation';
    }

    public function get_title()
    {
        return __('Navigation Menu', 'streamit-extensions');
    }

    public function get_categories()
    {
        return ['iqonic-layouts-extension'];
    }

    public function get_icon()
    {
        return 'eicon-nav-menu';
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'section_header',
            [
                'label' => __('Navigation', 'streamit-extensions'),
            ]
        );

        $this->add_control(
            'layout',
            [
                'label'      => __('Layout', 'streamit-extensions'),
                'type'       => Controls_Manager::SELECT,
                'default'    => 'default',
                'options'    => [
                    'default'   => __('Default', 'streamit-extensions'),
                    'burger'    => __('Burger', 'streamit-extensions'),
                ],
            ]
        );

        $this->add_control(
            'direction',
            [
                'label'      => __('Direction', 'streamit-extensions'),
                'type'       => Controls_Manager::SELECT,
                'default'    => 'horizontal',
                'options'    => [
                    'horizontal'    => __('Horizontal', 'streamit-extensions'),
                    'vertical'      => __('Vertical', 'streamit-extensions'),
                ],
                'condition' => ['layout' => 'default']
            ]
        );

        $this->add_control(
            'design_style',
            [
                'label'      => __('Hover Effect', 'streamit-extensions'),
                'type'       => Controls_Manager::SELECT,
                'default'    => 'style-one',
                'options'    => [
                    'style-one'       => __('Style 1', 'streamit-extensions'),
                    'style-two'    => __('None', 'streamit-extensions'),
                ],
                'condition' => ['layout' => 'default', 'direction' => 'vertical']
            ]
        );

        $this->add_control(
            'location',
            [
                'label'      => __('Location', 'streamit-extensions'),
                'type'       => Controls_Manager::SELECT,
                'default'    => 'select',
                'options'    => function_exists('layout_get_nav_menus') ? layout_get_nav_menus('location') : '',
            ]
        );

        $this->add_control(
            'menu',
            [
                'label'     => __('Menu', 'streamit-extensions'),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'select',
                'options'   => function_exists('layout_get_nav_menus') ? layout_get_nav_menus() : "",
                'condition' => ['location' => 'select']
            ]
        );

        $this->add_control(
            'hover_effect',
            [
                'label'      => __('Hover Effect', 'streamit-extensions'),
                'type'       => Controls_Manager::SELECT,
                'default'    => 'default',
                'options'    => [
                    'default'       => __('Style 1', 'streamit-extensions'),
                    'background'    => __('Style 2', 'streamit-extensions'),
                ],
                'condition' => ['layout' => 'default', 'direction' => 'horizontal']
            ]
        );

        $this->add_control(
            'use_more',
            [
                'label'      => __('Use More', 'streamit-extensions'),
                'type'       => Controls_Manager::SELECT,
                'default'    => 'yes',
                'options'    => [
                    'yes'   => __('Yes', 'streamit-extensions'),
                    'no'    => __('No', 'streamit-extensions'),
                ],
                'condition' => ['layout' => 'default', 'direction' => 'horizontal']
            ]
        );

        $this->add_control(
            'more_text',
            [
                'label' => __('More Text', 'streamit-extensions'),
                'type' => Controls_Manager::TEXT,
                'dynamic' => [
                    'active' => true,
                ],
                'label_block' => true,
                'default' => __('More', 'streamit-extensions'),
                'condition' => ['layout' => 'default', 'direction' => 'horizontal', 'use_more' => 'yes'],
            ]
        );

        $this->add_control(
            'more_item',
            [
                'label' => __('Items', 'streamit-extensions'),
                'type' => Controls_Manager::TEXT,
                'dynamic' => [
                    'active' => true,
                ],
                'label_block' => true,
                'description' => __('Show Number of Lists use More Text', 'streamit-extensions'),
                'default' => __('5', 'streamit-extensions'),
                'condition' => ['layout' => 'default', 'direction' => 'horizontal', 'use_more' => 'yes'],
            ]
        );

        $this->add_control(
            'use_custom_icon',
            [
                'label'      => __('Use Custom Icon', 'streamit-extensions'),
                'type'       => Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'your-plugin'),
                'label_off' => __('No', 'your-plugin'),
                'return_value' => 'yes',
                'default' => 'no',
                'condition' => ['layout' => 'burger']
            ]
        );

        $this->add_control(
            'selected_icon',
            [
                'label' => __('Icon', 'streamit-extensions'),
                'type' => Controls_Manager::ICONS,
                'fa4compatibility' => 'icon',
                'default' => [
                    'value' => 'fas fa-line'
                ],
                'condition' => ['layout' => 'burger', 'use_custom_icon' => 'yes'],
            ]
        );

        $this->add_control(
            'responsive_logo',
            [
                'label' => esc_html__('Add Responsove Logo', 'streamit-extensions'),
                'type' => Controls_Manager::MEDIA,
                'condition' => ['layout' => 'burger'],
            ]
        );

        $this->end_controls_section();

        require 'style.php';
    }

    protected function render()
    {
        require 'render.php';
        if (Plugin::$instance->editor->is_edit_mode()) { ?>
            <script>
                (function(jQuery) {
                    jQuery(document).ready(function(e) {
                        if (jQuery('.streamit-mobile-menu').length > 0) {
                            jQuery('nav.mobile-menu .sub-menu').css('display', 'none ');
                            jQuery('nav.mobile-menu #top-menu li .dropdown').hide();
                            jQuery('nav.mobile-menu .sub-menu').prev().prev().addClass('submenu');
                            jQuery('nav.mobile-menu .sub-menu').before('<span class="toggledrop"><i class="fas fa-angle-down"></i></span>');

                            jQuery('nav.mobile-menu .widget i,nav.mobile-menu .top-menu i').on('click', function() {
                                jQuery(this).next('.children, .sub-menu').slideToggle();
                            });
                            jQuery('nav.mobile-menu #top-menu .menu-item .toggledrop').off('click');
                            jQuery('nav.mobile-menu .menu-item .toggledrop').on('click', function(e) {
                                e.preventDefault();
                                if (!jQuery(this).closest('ul').parent('li').find('.toggledrop').hasClass('active')) {
                                    jQuery('.menu-style-one nav.mobile-menu .menu-item .sub-menu,nav.mobile-menu .menu-item .children').slideUp();
                                    jQuery('.menu-style-two nav.mobile-menu .menu-item .sub-menu,nav.mobile-menu .menu-item .children').hide();
                                    jQuery('nav.mobile-menu .menu-item .toggledrop').removeClass('active');
                                }
                                jQuery(this).next('.children, .sub-menu').slideToggle();
                                jQuery(this).toggleClass('active');
                            });
                        }

                    });
                })(jQuery);
            </script>
<?php
        }
    }
}
