<?php

namespace Iqonic\Elementor\Elements\Movie_Tab;

use Elementor\Plugin;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit;

class Widget extends Widget_Base
{
	public function get_name()
	{
		return 'Iq_Movie_Tab';
	}

	public function get_title()
	{
		return esc_html__('Movie Tab', 'streamit-extensions');
	}

	public function get_categories()
	{
		return ['streamit-extension'];
	}

	public function get_icon()
	{
		return 'eicon-tabs';
	}

	protected function register_controls()
	{
		$this->start_controls_section(
			'section_Team',
			[
				'label' => __('Movie Banner', 'streamit-extensions'),
			]
		);

		$this->add_control(
			'trending_top_img',
			[
				'label' => __('Trending Order Image', 'streamit-extensions'),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => STREAMIT_EXTENSION_PLUGIN_URL . '/includes/Elementor/assets/img/placeholder.jpg',
				],
			]
		);

		$this->add_control(
			'enable_lazy_load_images',
			[
				'label' => __('Lazy Load Images', 'streamit-extensions'),
				'type' => Controls_Manager::SWITCHER,
				'yes' 			=> __('Yes', 'streamit-extensions'),
				'no' 			=> __('No', 'streamit-extensions'),
				'return_value' 	=> 'yes',
				'default' 		=> 'no',
			]
		);

		$this->add_control(
			'show_title',
			[
				'label'   => __('Show Title', 'streamit-extensions'),
				'type'    => Controls_Manager::SELECT,
				'default' => 'yes',
				'options' => [
					'yes' => esc_html__('Yes', 'streamit-extensions'),
					'no' => esc_html__('No', 'streamit-extensions')
				],
			]
		);

		$this->add_control(
			'title_text',
			[
				'label' => __('Title Text', 'streamit-extensions'),
				'type' => Controls_Manager::TEXT,
				'default' => __('Trending', 'streamit-extensions'),
				'label_block' => true,
				'condition' => ['show_title' => ['yes']]
			]
		);

		$this->add_control(
			'show_no_movie',
			[
				'label' => __('Show Number Of Movies ', 'streamit-extensions'),
				'type' => Controls_Manager::NUMBER,
				'default' => __('6', 'streamit-extensions'),
				'min' => __('-1', 'streamit-extensions'),
				'max' => wp_count_posts('movie')->publish,
			]
		);

		$this->add_control(
			'tab_text_overview',
			[
				'label' => __('Overview Tab Text', 'streamit-extensions'),
				'type' => Controls_Manager::TEXT,
				'default' => __('Overview', 'streamit-extensions'),
				'label_block' => true,
			]
		);

		$this->add_control(
			'tab_text_similar',
			[
				'label' => __('Similar Like This Tab Text', 'streamit-extensions'),
				'type' => Controls_Manager::TEXT,
				'default' => __('Similar Like This', 'streamit-extensions'),
				'label_block' => true,
			]
		);

		$this->add_control(
			'view_logo',
			[
				'label' => __('Show logo?', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT,
				'default' => 'block',
				'options' => [
					'block' => esc_html__('Yes', 'streamit-extensions'),
					'none' => esc_html__('No', 'streamit-extensions')
				],
			]
		);

		$this->add_control(
			'view_all_starring',
			[
				'label' => __('Show Starring?', 'streamit-extensions'),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'block',
				'options' => [
					'block' => esc_html__('Yes', 'streamit-extensions'),
					'none' => esc_html__('No', 'streamit-extensions')
				],
			]
		);

		$this->add_control(
			'show_no_starring',
			[
				'type' => Controls_Manager::NUMBER,
				'label' => esc_html__('Starring Count', 'streamit-extensions'),
				'placeholder' => esc_html__('Show Number of Starring', 'streamit-extensions'),
				'min' => -1,
				'default' => -1,
				'condition' => ['view_all_starring' => ['block']]
			]
		);

		$this->add_control(
			'view_all_genres',
			[
				'label' => __('Show Genres?', 'streamit-extensions'),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'block',
				'options' => [
					'block' => esc_html__('Yes', 'streamit-extensions'),
					'none' => esc_html__('No', 'streamit-extensions')
				],
			]
		);

		$this->add_control(
			'show_no_genres',
			[
				'type' => Controls_Manager::NUMBER,
				'label' => esc_html__('Genres Count', 'streamit-extensions'),
				'placeholder' => esc_html__('Show Number of Genres', 'streamit-extensions'),
				'min' => -1,
				'default' => -1,
				'condition' => ['view_all_genres' => ['block']]
			]
		);

		$this->add_control(
			'view_all_tag',
			[
				'label' => __('Show Tags?', 'streamit-extensions'),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'block',
				'options' => [
					'block' => esc_html__('Yes', 'streamit-extensions'),
					'none' => esc_html__('No', 'streamit-extensions')
				],
			]
		);

		$this->add_control(
			'show_no_tags',
			[
				'type' => Controls_Manager::NUMBER,
				'label' => esc_html__('Tags Count', 'streamit-extensions'),
				'placeholder' => esc_html__('Show Number of Tags', 'streamit-extensions'),
				'min' => -1,
				'default' => -1,
				'condition' => ['view_all_tag' => ['block']]
			]
		);

		$this->end_controls_section();
	}

	protected function render()
	{
		require 'render.php';
		if (Plugin::$instance->editor->is_edit_mode()) { ?>
			<script>
				(function(jQuery) {
					callTabSlider();
					callOwl();
				})(jQuery);
			</script>
<?php
		}
	}
}
