<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;

global $streamit_options;

$rand 				= rand(10, 100);
$slider_title 		= $view_all = $view_cat = $col = $lazy_load = $ajax_load = '';
$args = $tax_query 	= $taxargs = array();

$current_page 			= '1';
$can_be_loaded 			= false;
$post_type 				= 'movie';
$loadmore_btn 			= "movie-load-btn-" . $rand;

$settings 				= $this->get_settings();

$is_grid 				= $settings['slider_type'] == 'grid';
$options_streamit_load 	= $is_grid ? $settings['pagination'] : "";

$post_filter			= $settings['post_view_type'];
$is_ajax_enable			= $settings['enable_ajax'] == "yes";
$paged 					= (get_query_var('paged')) ? get_query_var('paged') : 1;

if (isset($settings['slider_title'])) {
	$slider_title 		= $settings['slider_title'];
	$slider_title_key  	= str_replace(" ", "_", $slider_title);
	$title_option 		= $slider_title_key;
	$view_cat 			= '&title=' . $title_option;
}

if (!empty($settings['iq_movie_genre'])) {
	$tax_query['taxonomy'] 	= 'movie_genre';
	$tax_query['field'] 	= 'slug';
	$tax_query['terms'] 	= $settings['iq_movie_genre'];
	$tax_query['operator'] 	= 'IN';
	$option_value 			= implode(',', $settings['iq_movie_genre']);
	$view_cat 				.= '&genres=' . $option_value;
	array_push($taxargs, $tax_query);
}

if (!empty($settings['iq_movie_tag'])) {
	$tax_query['taxonomy'] 	= 'movie_tag';
	$tax_query['field'] 	= 'slug';
	$tax_query['terms'] 	= $settings['iq_movie_tag'];
	$tax_query['operator'] 	= 'IN';
	$option_value 			= implode(',', $settings['iq_movie_tag']);
	$view_cat 				.= '&tags=' . $option_value;
	array_push($taxargs, $tax_query);
}


if ($settings['post_view_type'] !== 'none') {
	$view_cat .= '&filter=' . $settings['post_view_type'];
}

if ($settings['view_all_switch'] === 'yes') {
	$this->add_render_attribute('iq_class', 'class', 'iq-view-all');
	if ($settings['use_custom_link_viewall'] == 'yes') {
		if ($settings['view_all_custom_link']['url']) {
			$url = $settings['view_all_custom_link']['url'];
			$this->add_render_attribute('iq_class', 'href', esc_url($url));

			if ($settings['view_all_custom_link']['is_external']) {
				$this->add_render_attribute('iq_class', 'target', '_blank');
			}

			if ($settings['view_all_custom_link']['nofollow']) {
				$this->add_render_attribute('iq_class', 'rel', 'nofollow');
			}
		}
		$view_all_text 	= esc_html($settings['use_custom_link_text']);
		$view_all 		= '<a ' . $this->get_render_attribute_string('iq_class') . '">' . $view_all_text . '</a>';
	} else {
		$view_all_text 			= $streamit_options['streamit_viewall_text'];
		$settings['show_title'] = $settings['show_title'] == "yes" ? "show" : "hide";
		$view_all 				= '<a class="iq-view-all" href="' . esc_url(get_page_link($streamit_options['streamit_viewall_link'])) . '?type=movies' . esc_html($view_cat) . '?show_title=' . $settings['show_title'] . '">' . esc_html($view_all_text) . '</a>';
	}
}

$args = array(
	'post_type'         => 'movie',
	'post_status'       => 'publish',
	'paged' 			=> $paged,
	'posts_per_page'	=> $settings['posts_per_page']['size'],
	"suppress_filters"	=> true,
	'fields'			=> 'ids'
);

if (empty($settings['iq_select_movies']) && $settings['post_view_type'] === 'most_liked') {
	$args['post__in'] 	= iq_get_most_liked('movie');
	$args['orderby'] 	= 'post__in';
}
if (empty($settings['iq_select_movies']) && $settings['post_view_type'] === 'most_viewd') {
	$args['meta_key'] 	= 'post_views_count';
	$args['orderby']    = 'meta_value_num';
	$args['order']      = 'DESC';
}

if (empty($settings['iq_select_movies']) && $settings['post_view_type'] === 'rand') {
	$args['orderby']    = 'rand';
}

if (!empty($settings['post_view_type']) && $settings['post_view_type'] !== 'none') {
	if ($settings['post_view_type'] === 'latest') {
		$args['orderby'] 	= 'publish_date';
		$args['order'] 		= 'DESC';
	}
}

if (!empty($settings['order']) && $settings['post_view_type'] === 'none') {
	$args['order'] = $settings['order'];
}
if (!empty($settings['order']) && $settings['post_view_type'] === 'upcoming') {
	$args['order'] = $settings['order'];
	$args['meta_query'] = array(
		array(
			'key'     => 'name_upcoming',
			'value'   => '"yes"',
			'compare' => 'LIKE'
		)
	);
} else {
	$args['meta_query'] = array(
		array(
			'key'     => 'name_upcoming',
			'value'   => '',
			'compare' => '=='
		)
	);
}

if (!empty($settings['order']) && $settings['post_view_type'] === 'alphabetic') {
	$args['orderby'] 	= 'title';
	$args['order'] 		= $settings['order'];
}

if (!empty($taxargs)) {
	$args['tax_query'] 				= $taxargs;
	$args['tax_query']['relation'] 	= 'OR';
}

if (!empty($settings['iq_select_movies'])) {
	$args['post__in'] = $settings['iq_select_movies'];
}

$wp_query 		= new \WP_Query($args);

$post_ids		= $wp_query->posts;
$count 			= $wp_query->post_count;
$total_pages 	= $wp_query->max_num_pages;

if ($is_ajax_enable) {
	$current_page 	= '0';
	$can_be_loaded 	= true;
	$ajax_load 		= 'ajax_load';
	$lazy_load 		= " iqonic-lazy-load-images";
}

$this->add_render_attribute('main-container', 'data-options', 		$options_streamit_load);
$this->add_render_attribute('main-container', 'class', 				$lazy_load);
$this->add_render_attribute('main-container', 'class', "iq-ajax-content favorites-contens streamit_datapass_movie");

if (!$is_grid) {
	$col 			= '';
	$is_grid 		=  false;
	$thumbnail_size = "full";

	$this->add_render_attribute('slider-ul', 'class', 					'favorites-slider');
	$this->add_render_attribute('slider-ul', 'data-nav', 				$settings['nav-arrow']);
	$this->add_render_attribute('slider-ul', 'data-items', 				$settings['desk_number']);
	$this->add_render_attribute('slider-ul', 'data-items-laptop', 		$settings['lap_number']);
	$this->add_render_attribute('slider-ul', 'data-items-tab', 			$settings['tab_number']);
	$this->add_render_attribute('slider-ul', 'data-items-mobile', 		$settings['mob_number']);
	$this->add_render_attribute('slider-ul', 'data-items-mobile-sm', 	$settings['mob_number']);
	$this->add_render_attribute('slider-ul', 'data-autoplay', 			$settings['autoplay']);
	$this->add_render_attribute('slider-ul', 'data-autoplay-speed', 	$settings['autoplay_speed']);
	$this->add_render_attribute('slider-ul', 'data-loop', 				$settings['infinite']);
	$this->add_render_attribute('slider-ul', 'data-speed', 				$settings['speed']);

	if ($wp_query->post_count > 4)
		$this->add_render_attribute('slider-ul', 'class', 'iq-rtl-direction');
	if (isset($settings['nav-arrow-style']) && $settings['nav-arrow-style'] == "style-2")
		$this->add_render_attribute('slider-ul', 'class', 'iq-arrow-2');
} else {
	$this->add_render_attribute('main-container', 'class', "watchlist-contens");
	$this->add_render_attribute('slider-ul', 'class', "favorites-grid");

	$grid_style = [
		'1' => ["col" => "col-12 wl-child", "img_size" => "full"],
		'2' => ["col" => "col-lg-6 col-md-6 col-sm-6 wl-child", "img_size" => "large"],
		'3' => ["col" => "col-lg-4 col-md-4 col-sm-6 wl-child", "img_size" => "medium_large"],
		'4' => ["col" => "col-xl-3 col-lg-4 col-md-4 col-sm-6 col-6 wl-child", "img_size" => "medium_large"],
	];

	$can_be_loaded 	= ($is_ajax_enable || $total_pages > 1) ? true : false;
	$col			= $grid_style[$settings['movie_grid_style']]["col"];
	$thumbnail_size = $grid_style[$settings['movie_grid_style']]["img_size"];
}

$temp_settings  = [
	'col'				=> $col,
	'is_grid'			=> $is_grid,
	'thumbnail_size'	=> $thumbnail_size,
	'play_now_text'		=> $settings['play_now_text'],
	'is_ajax_enable'	=> $is_ajax_enable,
	'lazy_load'			=> $lazy_load,
];

$this->add_render_attribute('main-container', 'data-can-beloaded', 	$can_be_loaded);
$this->add_render_attribute('slider-ul', 'class', "list-grid list-inline row p-0 mb-0"); ?>

<div <?php echo $this->get_render_attribute_string('main-container'); ?>>
	<?php if (!empty($post_ids)) :
		$title_tag = 'h4';
		echo streamit_get_shortcode_title($slider_title, $title_tag, $view_all); ?>
	<?php endif; ?>

	<ul <?php echo $this->get_render_attribute_string('slider-ul'); ?>>
		<?php if (!$is_ajax_enable && $wp_query->have_posts()) {
			foreach ($post_ids as $post_id) {
				require trailingslashit(plugin_dir_path(__FILE__)) . 'template.php';
			}
			wp_reset_postdata();
		} else {
			for ($i = 0; $i < $count; $i++) {
				require trailingslashit(STREAMIT_EXTENSION_PLUGIN_PATH) . 'includes/Elementor/Elements/General/ajax_Slider.php';
			}
		} ?>
	</ul>

	<?php if ($is_grid && $can_be_loaded && $settings['pagination'] == 'yes') {
		streamit_get_numbers_pagination($total_pages);
	} elseif ($is_grid && $can_be_loaded && $settings['pagination'] == 'infinite' && $total_pages > 1) {
		echo '<div class="loader-wheel-container"></div>';
	} ?>
</div>

<?php if ($can_be_loaded) { ?>
	<div class="loader-wheel-container">
		<?php if ($is_grid && $settings['pagination'] == 'loadmore' && $total_pages > 1) { ?>
			<div class="<?php echo esc_attr($loadmore_btn); ?>">
				<div class="btn btn-hover iq-button">
					<span><?php echo !empty($settings['more_text']) ? esc_html($settings['more_text']) : '' ?></span>
				</div>
			</div>
		<?php }

		if ($is_grid && $settings['pagination'] == "yes") {
			$current_page  = max(1, get_query_var('paged')) - 1;
		}

		$pagination_args = [
			'action' 			=> 'movie_slider',
			'current_page'		=> $current_page,
			'total_pages'		=> $total_pages,
			'loadmore_btn'		=> $loadmore_btn,
			'loading_text'		=> $settings['loading_text'],
			'query_args'		=> $args,
			'temp_settings'		=> $temp_settings,
			'posts_per_page' 	=> $count,
			'ajax_load'			=> $ajax_load,
			'is_ajax_enable'	=> $is_ajax_enable,
		];

		streamit_get_pagination_args($pagination_args); ?>
	</div>
<?php }
