<?php

namespace Iqonic\Elementor\Elements\Movie_Slider;

use Elementor\Plugin;
use Elementor\Controls_Manager;
use Elementor\Widget_Base;

if (!defined('ABSPATH')) exit;

class Widget extends Widget_Base
{
	public function get_name()
	{
		return 'Iq_Movie_Slider';
	}

	public function get_title()
	{
		return esc_html__('Movie Slider/Grid', 'streamit-extensions');
	}

	public function get_categories()
	{
		return ['streamit-extension'];
	}

	public function get_icon()
	{
		return 'eicon-slider-push';
	}

	protected function register_controls()
	{
		$this->start_controls_section(
			'section_Team',
			[
				'label' => __('Movie Slider', 'streamit-extensions'),
			]
		);

		$this->add_control(
			'slider_title',
			[
				'label' => __('Title', 'streamit-extensions'),
				'type' => Controls_Manager::TEXT,
				'default' => __('Title', 'streamit-extensions'),
				'label_block' => true,
			]
		);

		$this->add_control(
			'slider_type',
			[
				'label' => __('Style', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT,
				'label_block' => true,
				'multiple' => true,
				'options' => [
					'slider' => __('Slider', 'streamit-extensions'),
					'grid' => __('Grid', 'streamit-extensions')
				],
				'default' => 'slider'
			]
		);

		$this->add_control(
			'movie_grid_style',
			[
				'label'      => __('Movie Grid', 'streamit-extensions'),
				'type'       => Controls_Manager::SELECT,
				'default'    => '4',
				'options'    => [
					'1'            => __('One', 'streamit-extensions'),
					'2'          => __('Two', 'streamit-extensions'),
					'3'          => __('Three', 'streamit-extensions'),
					'4'          => __('Four', 'streamit-extensions'),
				],
				'condition' => ['slider_type' => 'grid']
			]
		);

		$this->add_control(
			'iq_select_movies',
			[
				'label' => __('Select Movies', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT2,
				'label_block' => true,
				'multiple' => true,
				'options' => isset($_REQUEST['editor_post_id']) ? iq_custom_post_data('movie', false) : [],
			]
		);

		$this->add_control(
			'iq_movie_genre',
			[
				'label' => __('Display Movie From Specific Genre', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT2,
				'label_block' => true,
				'multiple' => true,
				'options' => isset($_REQUEST['editor_post_id']) ? iq_get_custom_taxonomy('movie_genre') : [],
			]
		);

		$this->add_control(
			'iq_movie_tag',
			[
				'label' => __('Display Movie From Specific Tags', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT2,
				'label_block' => true,
				'multiple' => true,
				'options' => isset($_REQUEST['editor_post_id']) ? iq_get_custom_taxonomy('movie_tag') : [],
			]
		);

		$this->add_control(
			'play_now_text',
			[
				'label' => __('Play Now Text', 'streamit-extensions'),
				'type' => Controls_Manager::TEXT,
				'default' => __('Play Now', 'streamit-extensions'),
				'label_block' => true,
			]
		);

		$this->add_control(
			'enable_ajax',
			[
				'label' 		=> __('Enable Ajax', 'streamit-extensions'),
				'type' 			=> Controls_Manager::SWITCHER,
				'yes' 			=> __('Yes', 'streamit-extensions'),
				'no' 			=> __('No', 'streamit-extensions'),
				'return_value' 	=> 'yes',
				'default' 		=> 'no',
			]
		);

		$this->add_control(
			'view_all_switch',
			[
				'label' => __('Use View All Button ?', 'streamit-extensions'),
				'type' => Controls_Manager::SWITCHER,
				'yes' => __('Yes', 'streamit-extensions'),
				'no' => __('No', 'streamit-extensions'),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'use_custom_link_viewall',
			[
				'label' => __('Use View All custom link ?', 'streamit-extensions'),
				'type' => Controls_Manager::SWITCHER,
				'yes' => __('Yes', 'streamit-extensions'),
				'no' => __('No', 'streamit-extensions'),
				'return_value' => 'yes',
				'default' => 'no',
				'condition' => ['view_all_switch' => 'yes'],
			]
		);

		$this->add_control(
			'use_custom_link_text',
			[
				'label' => __('Custom Link Text', 'streamit-extensions'),
				'type' => Controls_Manager::TEXT,
				'default' => __('Link Text', 'streamit-extensions'),
				'label_block' => true,
				'condition' => [
					'use_custom_link_viewall' => 'yes',
					'view_all_switch' => 'yes'
				],
			]
		);

		$this->add_control(
			'view_all_custom_link',
			[
				'label' => __('Custom link', 'streamit-extensions'),
				'type' => Controls_Manager::URL,
				'placeholder' => __('https://your-link.com', 'streamit-extensions'),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
				'condition' => [
					'use_custom_link_viewall' => 'yes',
					'view_all_switch' => 'yes'
				],
			]
		);

		require STREAMIT_EXTENSION_PLUGIN_PATH . '/includes/Elementor/Controls/post-control.php';

		$this->add_control(
			'pagination',
			[
				'label'   => __('Show Pagintion/Loadmore/Infinite', 'streamit-extensions'),
				'type'    => Controls_Manager::SELECT,
				'default' => 'loadmore',
				'label_block' => true,
				'options' => [
					'yes' => esc_html__('Pagination', 'streamit-extensions'),
					'loadmore' => esc_html__('Loadmore', 'streamit-extensions'),
					'infinite' => esc_html__('Infinite Scroll', 'streamit-extensions'),
					'no' => esc_html__('No Pagination', 'streamit-extensions'),
				],
				'condition' => ['slider_type' => 'grid']
			]
		);

		$this->add_control(
			'more_text',
			[
				'label' => __('Load More button text', 'streamit-extensions'),
				'type' => Controls_Manager::TEXT,
				'default' => __('Load More', 'streamit-extensions'),
				'label_block' => true,
				'condition' => ['slider_type' => 'grid', 'pagination' => 'loadmore']
			]
		);

		$this->add_control(
			'loading_text',
			[
				'label' => __('Loading button text', 'streamit-extensions'),
				'type' => Controls_Manager::TEXT,
				'default' => __('Loading...', 'streamit-extensions'),
				'label_block' => true,
				'condition' => ['slider_type' => 'grid', 'pagination' => 'loadmore']
			]
		);

		$this->add_responsive_control(
			'posts_per_page',
			[
				'label' => __('Posts Per Page', 'streamit-extensions'),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'unit' => '%',
					'size' => 10,
				]
			]
		);

		$this->end_controls_section();
		$this->start_controls_section(
			'slick_control_section',
			[
				'label' => __('Slider Control', 'streamit-extensions'),
				'condition' => ['slider_type' => ['slider']],
			]
		);

		require STREAMIT_EXTENSION_PLUGIN_PATH . '/includes/Elementor/Controls/slick-control.php';

		$this->end_controls_section();
	}

	protected function render()
	{
		require   'render.php';
		if (Plugin::$instance->editor->is_edit_mode()) { ?>
			<script>
				(function(jQuery) {
					callSlickSlider(jQuery('.favorites-slider'));
					movieSliderAjaxHandler();
				})(jQuery)
			</script>
<?php
		}
	}
}
