<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;

global $streamit_options;

$rand 			= rand(10, 100);
$slider_title 	= $view_cat = $view_all = $col = $lazy_load = $ajax_load = '';

$current_page 	= '1';
$can_be_loaded  = false;
$post_type 		= 'movie';
$loadmore_btn 	= 'movie-cards-load-btn-' . $rand;

$settings 				= $this->get_settings();

$is_grid 				= ($settings['slider_type'] == 'grid');
$parent_class 			= $is_grid ? "grid-view" : "";
$options_streamit_load 	= $is_grid ? $settings['pagination'] : "";

$post_filter			= $settings['post_view_type'];
$show_title				= $settings['show_title'] == "yes";
$is_ajax_enable			= $settings['enable_ajax'] == "yes";
$is_badges_enable		= (isset($settings['enable_premium_badges']) && $settings['enable_premium_badges'] == "yes") ? true : false;

if (isset($settings['section_title'])) {
	$slider_title 		= $settings['section_title'];
	$slider_title_key  	= str_replace(" ", "_", $slider_title);
	$title_option 		= $slider_title_key;
	$view_cat 			= '&title=' . $title_option;
}

$view_cat .= '&style=2';
if ($settings['image_style'] == "landscape") {
	$view_cat .= '&image=landscape';
} else {
	$view_cat .= '&image=portrait';
}

if (!empty($settings['iq_movie_genre'])) {
	$option_value = implode(',', $settings['iq_movie_genre']);
	$view_cat .= '&genres=' . $option_value;
}

if (!empty($settings['iq_movie_tag'])) {
	$option_value = implode(',', $settings['iq_movie_tag']);
	$view_cat .= '&tags=' . $option_value;
}

if ($post_filter !== 'none') {
	$view_cat .= '&filter=' . $post_filter;
} else {
	$view_cat .= '&' . $post_filter;
}

if ($settings['view_all_switch'] === 'yes') {
	if ($settings['use_custom_link_viewall'] == 'yes' && $settings['view_all_custom_link']['url']) {
		$url = $settings['view_all_custom_link']['url'];
		$this->add_render_attribute('view-all-attr', 'class', 'iq-view-all');
		$this->add_render_attribute('view-all-attr', 'href', esc_url($url));
		if ($settings['view_all_custom_link']['is_external']) {
			$this->add_render_attribute('view-all-attr', 'target', '_blank');
		}

		if ($settings['view_all_custom_link']['nofollow']) {
			$this->add_render_attribute('view-all-attr', 'rel', 'nofollow');
		}

		$view_all_text = esc_html($settings['use_custom_link_text']);
		$view_all = '<a ' . $this->get_render_attribute_string('view-all-attr') . '">' . $view_all_text . '</a>';
	} else {
		$view_all_text 			= $streamit_options['streamit_viewall_text'];
		$settings['show_title'] = $settings['show_title'] == "yes" ? "show" : "hide";
		$view_all 				= '<a class="iq-view-all" href="' . esc_url(get_page_link($streamit_options['streamit_viewall_link'])) . '?type=movies' . esc_html($view_cat) . '&show_title=' . $settings['show_title'] . '">' . esc_html($view_all_text) . '</a>';
	}
}

$args 			= streamit_get_cards_meta_queries($post_type, $settings);
$wp_query 		= new \WP_Query($args);

$post_ids 		= $wp_query->posts;
$count 			= $wp_query->post_count;
$total_pages 	= $wp_query->max_num_pages;

if ($is_ajax_enable) {
	$current_page 	= '0';
	$can_be_loaded 	= true;
	$ajax_load 		= 'ajax_load';
	$lazy_load 		= " iqonic-lazy-load-images";
	$parent_class 	.= $lazy_load;
}

if (!$is_grid) {
	$col 			= '';
	$is_grid 		=  false;
	$thumbnail_size = "full";
	$align 			= 'favorites-slider';

	$this->add_render_attribute('list-ul-attr', 'data-nav', 			$settings['nav-arrow']);
	$this->add_render_attribute('list-ul-attr', 'data-items', 			$settings['desk_number']);
	$this->add_render_attribute('list-ul-attr', 'data-items-laptop', 	$settings['lap_number']);
	$this->add_render_attribute('list-ul-attr', 'data-items-tab', 		$settings['tab_number']);
	$this->add_render_attribute('list-ul-attr', 'data-items-mobile', 	$settings['mob_number']);
	$this->add_render_attribute('list-ul-attr', 'data-items-mobile-sm', $settings['mob_number']);
	$this->add_render_attribute('list-ul-attr', 'data-autoplay', 		$settings['autoplay']);
	$this->add_render_attribute('list-ul-attr', 'data-autoplay-speed', 	$settings['autoplay_speed']);
	$this->add_render_attribute('list-ul-attr', 'data-loop', 			$settings['infinite']);
	$this->add_render_attribute('list-ul-attr', 'data-speed', 			$settings['speed']);
	$this->add_render_attribute('list-ul-attr', 'class', 				'iq-rtl-direction');

	if (isset($settings['nav-arrow-style']) && $settings['nav-arrow-style'] == 'style-2')
		$this->add_render_attribute('list-ul-attr', 'class', 'iq-arrow-2');
} else {
	$align = 'favorites-grid';

	$grid_style = [
		'1' => [
			"class"         => "col-12 wl-child",
			"landscape"     => "full"
		],
		'2' => [
			"class"         => "col-lg-6 col-md-6 col-sm-6 wl-child",
			"landscape"     => "large"
		],
		'3' => [
			"class"         => "col-lg-4 col-md-4 col-sm-6 wl-child",
			"landscape"     => "medium_large"
		],
		'4' => [
			"class"         => "col-xl-3 col-lg-4 col-md-4 col-sm-6 col-6 wl-child",
			"landscape"     => "medium_large"
		],
		'5' => [
			"class"         => "iq-five col-lg-4 col-md-6 col-sm-6 col-6 wl-child",
			"landscape"     => "medium_large"
		],
		'6' => [
			"class"         => "col-xl-2 col-lg-4 col-md-6 col-sm-6 col-6 wl-child",
			"landscape"     => "medium_large"
		]
	];

	$col 			= $grid_style[$settings['movie_grid_style']]["class"];
	$can_be_loaded 	= ($is_ajax_enable || $total_pages > 1) ? true : false;
	$thumbnail_size = $grid_style[$settings['movie_grid_style']]["landscape"];
}

$temp_settings 	= [
	'col'				=> $col,
	'is_grid'			=> $is_grid,
	'thumbnail_size'	=> $thumbnail_size,
	'is_badges_enable'	=> $is_badges_enable,
	'image_style'		=> $settings['image_style'],
	'is_ajax_enable'	=> $is_ajax_enable,
	'lazy_load'			=> $lazy_load,
	'show_title' 		=> $show_title,
];

$this->add_render_attribute('list-ul-attr', 'class', $align . " list-grid list-inline row p-0 mb-0"); ?>

<div class="iq-card-wrapper iq-ajax-content movie_cards <?php echo esc_attr($parent_class); ?>" data-options="<?php echo esc_html($options_streamit_load); ?>" data-can-beloaded="<?php echo esc_attr($can_be_loaded); ?>">
	<?php if (!empty($post_ids)) :
		$title_tag = $settings['title_tag'];
		echo streamit_get_shortcode_title($slider_title, $title_tag, $view_all); ?>
	<?php endif; ?>

	<ul <?php echo $this->get_render_attribute_string('list-ul-attr'); ?>>
		<?php if (!$is_ajax_enable && $wp_query->have_posts()) {
			foreach ($post_ids as $post_id) {
				require trailingslashit(plugin_dir_path(__FILE__)) . 'template.php';
			}
			wp_reset_postdata();
		} else {
			for ($i = 0; $i < $count; $i++) {
				require trailingslashit(STREAMIT_EXTENSION_PLUGIN_PATH) . 'includes/Elementor/Elements/General/ajax_Cards.php';
			}
		} ?>
	</ul>

	<?php if ($is_grid && $can_be_loaded && $settings['pagination'] == 'yes') {
		streamit_get_numbers_pagination($total_pages);
	} elseif ($is_grid && $can_be_loaded && $settings['pagination'] == 'infinite' && $total_pages > 1) {
		echo '<div class="loader-wheel-container"></div>';
	} ?>
</div>

<?php if ($can_be_loaded) { ?>
	<div class="loader-wheel-container">
		<?php if ($is_grid && $settings['pagination'] == 'loadmore' && $total_pages > 1) : ?>
			<div class="<?php echo esc_attr($loadmore_btn); ?>">
				<div class="btn btn-hover iq-button">
					<span><?php echo !empty($settings['more_text']) ? esc_html($settings['more_text']) : '' ?></span>
				</div>
			</div>
		<?php endif;

		if ($is_grid && $settings['pagination'] == "yes") {
			$current_page  = max(1, get_query_var('paged')) - 1;
		}

		$pagination_args = [
			'action' 			=> 'movie_cards',
			'current_page'		=> $current_page,
			'total_pages'		=> $total_pages,
			'loadmore_btn'		=> $loadmore_btn,
			'loading_text'		=> $settings['loading_text'],
			'query_args'		=> $args,
			'temp_settings'		=> $temp_settings,
			'posts_per_page' 	=> $count,
			'ajax_load'			=> $ajax_load,
			'is_ajax_enable'	=> $is_ajax_enable,
		];

		streamit_get_pagination_args($pagination_args); ?>
	</div>
<?php }
