<?php

use Elementor\Controls_Manager;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Typography;

$this->start_controls_section(
    'section_zq808BOa6ovm3lt2xN1E',
    [
        'label' => __('Title', SE_TEXT_DOMAIN),
        'tab' => Controls_Manager::TAB_STYLE,
    ]
);

$this->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name' => 'title_content_text_typography',
        'label' => __('Title Typography', SE_TEXT_DOMAIN),
        'selector' => '{{WRAPPER}} .marquee-text .marquees-list .marquee-title',
    ]
);

$this->add_control(
    'has_gradient_title',
    [
        'label' => __('Use gradient color for title ?', SE_TEXT_DOMAIN),
        'type' => Controls_Manager::SWITCHER,
        'default' => 'no',
        'yes' => __('yes', SE_TEXT_DOMAIN),
        'no' => __('no', SE_TEXT_DOMAIN),
    ]
);

$this->add_control(
    'marquee_title_color',
    [
        'label' => __('Title Color', SE_TEXT_DOMAIN),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .marquee-text .marquees-list .marquee-title, {{WRAPPER}}  .streamit-marquee .streamit-marquee-title' => 'color: {{VALUE}};',
            '{{WRAPPER}} .streamit-marquee-title' => 'color: {{VALUE}} !important;',
        ],
    ]
);

$this->add_control(
    'title_heading',
    [
        'label' => __('Title Color', SE_TEXT_DOMAIN),
        'type' => Controls_Manager::HEADING,
        'separator' => 'before',
        'condition' => ['has_gradient_title' => 'yes'],
    ]
);

$this->add_group_control(
    Group_Control_Background::get_type(),
    [
        'name' => 'title_gradient',
        'label' => __('Title Color', SE_TEXT_DOMAIN),
        'types' => ['gradient'],
        'description' => 'Title gradient color.',
        'condition' => ['has_gradient_title' => 'yes'],
        'selector' => ' {{WRAPPER}} .marquee-text .marquees-list .marquee-title,
                {{WRAPPER}} .streamit-marquee .streamit-marquee-title',
        '{{WRAPPER}} .streamit-marquee-title' => 'color: {{VALUE}} !important;',
    ]
);

$this->add_control(
    'title_hover_heading',
    [
        'label' => __('Title Hover Color', SE_TEXT_DOMAIN),
        'type' => Controls_Manager::HEADING,
        'separator' => 'before',
        'condition' => ['has_gradient_title' => 'yes'],
    ]
);

$this->add_control(
    'marqueebox_title_hover_color',
    [
        'label' => __('Choose Color', SE_TEXT_DOMAIN),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .marquee-text .marquees-list .marquee-title:hover, {{WRAPPER}} .streamit-marquee .item:hover .streamit-marquee-title' => 'color: {{VALUE}};',
        ],
    ]
);

$this->add_group_control(
    Group_Control_Background::get_type(),
    [
        'name' => 'title_gradient_hover',
        'label' => __('Title Hover Color', SE_TEXT_DOMAIN),
        'types' => ['gradient'],
        'description' => 'Title gradient hover color.',
        'condition' => ['has_gradient_title' => 'yes'],
        'selector' => ' {{WRAPPER}} .marquee-text .marquees-list .marquee-title:hover,
        {{WRAPPER}} .streamit-marquee .streamit-marquee-title:hover',
        '{{WRAPPER}} .streamit-marquee-title:hover ',
    ]
);

$this->add_responsive_control(
    'marqueebox_title_padding',
    [
        'label' => __('Padding', SE_TEXT_DOMAIN),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%'],
        'selectors' => [
            '{{WRAPPER}} .marquee-text .marquees-list li, {{WRAPPER}} .streamit-marquee .streamit-marquee-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$this->add_responsive_control(
    'marqueebox_title_margin',
    [
        'label' => __('Margin', SE_TEXT_DOMAIN),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%'],
        'selectors' => [
            '{{WRAPPER}}  .marquee-text .marquees-list .marquee-title, {{WRAPPER}}  .streamit-marquee-blog .streamit-marquee-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$this->end_controls_section();

$this->start_controls_section(
    'section_line6ovm3lt2xN1E',
    [
        'label' => __('Line', SE_TEXT_DOMAIN),
        'tab' => Controls_Manager::TAB_STYLE,
    ]
);

$this->add_control(
    'line_color',
    [
        'label' => __('Choose Color', SE_TEXT_DOMAIN),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .marquee-text .marquees-list li::before' => 'background: {{VALUE}};',
        ],
    ]
);

$this->add_responsive_control(
    'line_width',
    [
        'label' => __('Width', SE_TEXT_DOMAIN),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', '%'],
        'range' => [
            'px' => [
                'min' => 0,
                'max' => 1000,
                'step' => 5,
            ],
            '%' => [
                'min' => 0,
                'max' => 100,
            ],
        ],
        'selectors' => [
            '{{WRAPPER}} .marquee-text .marquees-list li::before' => 'width: {{SIZE}}{{UNIT}};',
        ],
    ]
);

$this->add_responsive_control(
    'line_height',
    [
        'label' => __('Height', SE_TEXT_DOMAIN),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', '%'],
        'range' => [
            'px' => [
                'min' => 0,
                'max' => 1000,
                'step' => 5,
            ],
            '%' => [
                'min' => 0,
                'max' => 100,
            ],
        ],
        'selectors' => [
            '{{WRAPPER}} .marquee-text .marquees-list li::before' => 'height: {{SIZE}}{{UNIT}};',
        ],
    ]
);

$this->end_controls_section();

$this->start_controls_section(
    'section_img',
    [
        'label' => __('Image', SE_TEXT_DOMAIN),
        'tab' => Controls_Manager::TAB_STYLE,
        'condition' => ['design_style' => 'style-two'],
    ]
);

$this->add_control(
    'border_radius',
    [
        'label' => esc_html__('Border Radius', SE_TEXT_DOMAIN),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors' => [
            '{{WRAPPER}}  .iqonic-marquee-text .marquees-list img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);
$this->add_group_control(
    Group_Control_Background::get_type(),
    [
        'name' => 'image_background',
        'label' => __('Background', SE_TEXT_DOMAIN),
        'types' => ['classic', 'gradient'],
        'selector' => ' {{WRAPPER}}  .iqonic-marquee-text .marquees-list img',
    ]
);
$this->add_responsive_control(
    'image_height',
    [
        'label' => __('Height', SE_TEXT_DOMAIN),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em'],
        'range' => [
            'px' => [
                'min' => 0,
                'max' => 1000,
                'step' => 5,
            ],
            '%' => [
                'min' => 0,
                'max' => 100,
            ],
        ],
        'selectors' => [
            '{{WRAPPER}} .marquee-text .marquees-list .image-title-link img' => 'height: {{SIZE}}{{UNIT}};',
        ],
    ]
);
$this->add_responsive_control(
    'image_width',
    [
        'label' => __('Width', SE_TEXT_DOMAIN),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em'],
        'range' => [
            'px' => [
                'min' => 0,
                'max' => 1000,
                'step' => 5,
            ],
            '%' => [
                'min' => 0,
                'max' => 100,
            ],
        ],
        'selectors' => [
            '{{WRAPPER}} .marquee-text .marquees-list .image-title-link img' => 'width: {{SIZE}}{{UNIT}};',
        ],
    ]
);
$this->end_controls_section();
