<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;

$html = $gradient_class = $align = $url = '';

$settings   = $this->get_settings();
$style_one  = ($settings['design_style'] == 'style-one');

if ($settings['has_gradient_title'] === "yes") {
    $gradient_class = ' gradient-text-color';
}

$align .= !empty($settings['design_style']) ? $settings['design_style'] : ''; ?>

<div class="iqonic-marquee-text marquee-text <?php echo esc_attr($align); ?>">
    <div class="mrq-text">
        <div class="marquees-list <?php esc_attr_e($settings['tabs_direction'] . '-direction', SE_TEXT_DOMAIN) ?>">
            <?php $tabs = $settings['tabs'];
            foreach ($tabs as $index => $tab) {
                if ($style_one) {
                    require trailingslashit(plugin_dir_path(__FILE__)) . 'template-one.php';
                } else {
                    require trailingslashit(plugin_dir_path(__FILE__)) . 'template-two.php';
                }
            } ?>
        </div>

        <div class="marquees-list marquees-copy <?php esc_attr_e($settings['tabs_direction'] . '-direction', SE_TEXT_DOMAIN) ?>">
            <?php foreach ($tabs as $index => $tab) {
                if ($style_one) {
                    require trailingslashit(plugin_dir_path(__FILE__)) . 'template-one.php';
                } else {
                    require trailingslashit(plugin_dir_path(__FILE__)) . 'template-two.php';
                }
            } ?>
        </div>
    </div>

    <!-- ROW TWO -->
    <div class="mrq-text-main">
        <div class="marquees-list <?php esc_attr_e($settings['row_two_tabs_direction'] . '-direction', SE_TEXT_DOMAIN) ?>">
            <?php $row_two_tabs = $settings['row_two_tabs'];
            foreach ($row_two_tabs as $index => $tab) {
                if ($style_one) {
                    require trailingslashit(plugin_dir_path(__FILE__)) . 'template-one.php';
                } else {
                    require trailingslashit(plugin_dir_path(__FILE__)) . 'template-two.php';
                }
            } ?>
        </div>

        <div class="marquees-list marquees-copy <?php esc_attr_e($settings['row_two_tabs_direction'] . '-direction', SE_TEXT_DOMAIN) ?>">
            <?php foreach ($row_two_tabs as $index => $tab) {
                if ($style_one) {
                    require trailingslashit(plugin_dir_path(__FILE__)) . 'template-one.php';
                } else {
                    require trailingslashit(plugin_dir_path(__FILE__)) . 'template-two.php';
                }
            } ?>
        </div>
    </div>
</div>