<?php

namespace Iqonic\Elementor\Elements\MarqueeText;

use Elementor\Utils;
use Elementor\Plugin;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit;

class Widget extends Widget_Base
{
    public function get_name()
    {
        return 'iqonic_marquee_text';
    }

    public function get_title()
    {
        return __('Marquee', SE_TEXT_DOMAIN);
    }

    public function get_categories()
    {
        return ['streamit-extension'];
    }

    public function get_icon()
    {
        return 'eicon-animation-text';
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'section_marquee_style',
            [
                'label' => __('Marquee', SE_TEXT_DOMAIN),
            ]
        );

        $this->add_control(
            'design_style',
            [
                'label' => __('Select List Style', SE_TEXT_DOMAIN),
                'type' => Controls_Manager::SELECT,
                'label_block' => false,
                'options' => [
                    'style-one'     => __('Style 1', SE_TEXT_DOMAIN),
                    'style-two'     => __('Style 2', SE_TEXT_DOMAIN),
                ],
                'default' => 'style-one'
            ]
        );

        $this->streamit_marquee_repeater('tabs');

        $this->add_control(
            'tabs_direction',
            [
                'label' => __('Direction ?', SE_TEXT_DOMAIN),
                'type'       => Controls_Manager::SELECT,
                'default'    => 'right',
                'options'    => [
                    'left'  => __('Left', SE_TEXT_DOMAIN),
                    'right' => __('Right', SE_TEXT_DOMAIN),
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_marquee_second_row',
            [
                'label' => __('2nd Row', SE_TEXT_DOMAIN),
            ]
        );

        $this->streamit_marquee_repeater('row_two_tabs');

        $this->add_control(
            'row_two_tabs_direction',
            [
                'label' => __('Direction ?', SE_TEXT_DOMAIN),
                'type'       => Controls_Manager::SELECT,
                'default'    => 'right',
                'options'    => [
                    'left'  => __('Left', SE_TEXT_DOMAIN),
                    'right' => __('Right', SE_TEXT_DOMAIN),
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_marquee_options',
            [
                'label' => __('Options', SE_TEXT_DOMAIN),
            ]
        );

        $this->add_control(
            'title_tag',
            [
                'label'      => __('Title Tag', SE_TEXT_DOMAIN),
                'type'       => Controls_Manager::SELECT,
                'default'    => 'h5',
                'options'    => [
                    'h1'          => __('h1', SE_TEXT_DOMAIN),
                    'h2'          => __('h2', SE_TEXT_DOMAIN),
                    'h3'          => __('h3', SE_TEXT_DOMAIN),
                    'h4'          => __('h4', SE_TEXT_DOMAIN),
                    'h5'          => __('h5', SE_TEXT_DOMAIN),
                    'h6'          => __('h6', SE_TEXT_DOMAIN),
                ],
            ]
        );

        $this->add_control(
            'display_separator',
            [
                'label' => __('Display Separator?', SE_TEXT_DOMAIN),
                'type'       => Controls_Manager::SELECT,
                'default'    => 'set',
                'options'    => [
                    'set'   => __('Yes', SE_TEXT_DOMAIN),
                    'unset' => __('No', SE_TEXT_DOMAIN),
                ],
                'selectors' => [
                    '{{WRAPPER}} .marquee-text .marquees-list li::before' => 'content: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        require_once 'style.php';
    }

    private function  streamit_marquee_repeater($widget_name)
    {
        $repeater = new Repeater();
        $repeater->add_control(
            'rating',
            [
                'label' => esc_html__('Rating', SE_TEXT_DOMAIN),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 5,
                        'step' => 1,
                    ],
                ],
            ]
        );

        $repeater->add_control(
            'client',
            [
                'label'         => __('Client Name', SE_TEXT_DOMAIN),
                'type'          => Controls_Manager::TEXT,
                'placeholder'   => __('Enter Client Name', SE_TEXT_DOMAIN),
                'default'       => '',
                'label_block'   => true
            ]
        );

        $repeater->add_control(
            'for',
            [
                'label'     => __('Enter Review Type', SE_TEXT_DOMAIN),
                'type'      => Controls_Manager::TEXT,
                'placeholder'   => __('Enter Review Type', SE_TEXT_DOMAIN),
                'default'       => '',
                'label_block'   => true
            ]
        );

        $repeater->add_control(
            'link',
            [
                'label' => esc_html__('Link', SE_TEXT_DOMAIN),
                'type' => Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', SE_TEXT_DOMAIN),
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                    'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'image',
            [
                'label'     => __('Choose Image', SE_TEXT_DOMAIN),
                'type'      => Controls_Manager::MEDIA,
                'dynamic'   => [
                    'active' => true,
                ],
                'default'   => [
                    'url'   => Utils::get_placeholder_image_src()
                ],
            ]
        );

        $repeater->add_control(
            'review',
            [
                'label'         => 'Review',
                'type'          => Controls_Manager::WYSIWYG,
                'default' => esc_html__('', SE_TEXT_DOMAIN),
            ]
        );

        $this->add_control(
            $widget_name,
            [
                'label' => __('Items', SE_TEXT_DOMAIN),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );
    }

    protected function render()
    {
        require 'render.php';
    }
}
