<?php

namespace Iqonic\Elementor\Elements\Iqonic_MailChimp;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit;

class Widget extends Widget_Base
{
	public function get_name()
	{
		return 'iqonic_mailchimp_shortcode';
	}

	public function get_title()
	{
		return esc_html__('Iqonic MailChimp Shortcode', SE_TEXT_DOMAIN);
	}

	public function get_icon()
	{
		return 'eicon-shortcode';
	}

	protected function register_controls()
	{
		$this->start_controls_section(
			'section_shortcode',
			[
				'label' => esc_html__('Shortcode', SE_TEXT_DOMAIN),
			]
		);

		$this->add_control(
			'shortcode',
			[
				'label' => esc_html__('Enter your shortcode', SE_TEXT_DOMAIN),
				'type' => Controls_Manager::TEXTAREA,
				'dynamic' => [
					'active' => true,
				],
				'placeholder' => '[gallery id="123" size="medium"]',
				'default' => '',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_banner_style',
			[
				'label' => __('Main', SE_TEXT_DOMAIN),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'form_bg_color',
			[
				'label' => __('Form Background Color', SE_TEXT_DOMAIN),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mc4wp-form .mc4wp-form-fields input ' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();
	}

	protected function render()
	{
		require 'render.php';
	}
}
