<?php

use Elementor\Controls_Manager;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Css_Filter;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Background;

$this->start_controls_section(
    'section_style_image',
    [
        'label' => __('Image', 'streamit-extensions'),
        'tab'   => Controls_Manager::TAB_STYLE,
    ]
);

$this->add_responsive_control(
    'image_space',
    [
        'label' => __('Spacing', 'streamit-extensions'),
        'type' => Controls_Manager::SLIDER,
        'default' => [
            'size' => 15,
        ],
        'range' => [
            'px' => [
                'min' => 0,
                'max' => 100,
            ],
        ],
        'selectors' => [
            '{{WRAPPER}}.elementor-position-right .scroll-img' => 'margin-left: {{SIZE}}{{UNIT}};',
            '{{WRAPPER}}.elementor-position-left .scroll-img' => 'margin-right: {{SIZE}}{{UNIT}};',
            '{{WRAPPER}}.elementor-position-top .scroll-img' => 'margin-bottom: {{SIZE}}{{UNIT}};',
            '(mobile){{WRAPPER}} .scroll-img' => 'margin-bottom: {{SIZE}}{{UNIT}};',
        ],
    ]
);

$this->add_responsive_control(
    'image_size',
    [
        'label' => __('Width', 'streamit-extensions'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['%', 'px', 'vw'],
        'range' => [
            '%' => [
                'min' => 1,
                'max' => 100,
            ],
            'px' => [
                'min' => 1,
                'max' => 1000,
            ],
            'vw' => [
                'min' => 1,
                'max' => 100,
            ],
        ],
        'selectors' => [
            '{{WRAPPER}} .streamit-image-box .streamit-image-box-img' => 'width: {{SIZE}}{{UNIT}};',
        ],
    ]
);

$this->add_responsive_control(
    'image_size_height',
    [
        'label' => __('Height', 'streamit-extensions'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['%', 'px', 'vw'],
        'range' => [
            '%' => [
                'min' => 1,
                'max' => 100,
            ],
            'px' => [
                'min' => 1,
                'max' => 1000,
            ],
            'vw' => [
                'min' => 1,
                'max' => 100,
            ],
        ],
        'condition' => ['use_image_scroll' => 'yes'],
        'selectors' => [
            '{{WRAPPER}} .streamit-image-box.hover-image-scroll .streamit-image-box-img' => 'height: {{SIZE}}{{UNIT}};',
            '{{WRAPPER}} .streamit-image-box.hover-image-scroll:hover .streamit-image-box-img img' => 'transform: translateY(calc(-100% + {{SIZE}}{{UNIT}}));',
        ],
    ]
);

$this->add_group_control(
    Group_Control_Background::get_type(),
    [
        'name' => 'imagebox_background',
        'label' => __('Background', 'streamit-extensions'),
        'types' => ['classic', 'gradient'],
        'selector' => '{{WRAPPER}} .streamit-image-box .streamit-image-box-img',
    ]
);

$this->add_responsive_control(
    'image_border_radius',
    [
        'label' => __('Border Radius', 'streamit-extensions'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', '%'],
        'selectors' => [
            '{{WRAPPER}} .streamit-image-box .streamit-image-box-img,{{WRAPPER}} .streamit-image-box .streamit-image-box-img img' => 'border-radius: {{SIZE}}{{UNIT}};',
        ],
    ]
);

$this->add_group_control(
    Group_Control_Box_Shadow::get_type(),
    [
        'name' => 'image_box_shadow',
        'label' => __('Box Shadow', 'streamit-extensions'),
        'selector' => '{{WRAPPER}} .streamit-image-box .streamit-image-box-img',
    ]
);

$this->add_responsive_control(
    'image_padding',
    [
        'label' => __('Padding', 'streamit-extensions'),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%'],
        'selectors' => [
            '{{WRAPPER}} .streamit-image-box .streamit-image-box-img' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$this->add_control(
    'hover_animation',
    [
        'label' => __('Hover Animation', 'streamit-extensions'),
        'type' => Controls_Manager::HOVER_ANIMATION,
    ]
);

$this->start_controls_tabs('image_effects');
$this->start_controls_tab(
    'normal',
    [
        'label' => __('Normal', 'streamit-extensions'),
    ]
);

$this->add_group_control(
    Group_Control_Css_Filter::get_type(),
    [
        'name' => 'css_filters',
        'selector' => '{{WRAPPER}} .scroll-img img',
    ]
);

$this->add_control(
    'image_opacity',
    [
        'label' => __('Opacity', 'streamit-extensions'),
        'type' => Controls_Manager::SLIDER,
        'range' => [
            'px' => [
                'max' => 1,
                'min' => 0.10,
                'step' => 0.01,
            ],
        ],
        'selectors' => [
            '{{WRAPPER}} .scroll-img img' => 'opacity: {{SIZE}};',
        ],
    ]
);

$this->add_control(
    'background_hover_transition',
    [
        'label' => __('Transition Duration', 'streamit-extensions'),
        'type' => Controls_Manager::SLIDER,
        'default' => [
            'size' => 0.3,
        ],
        'range' => [
            'px' => [
                'max' => 3,
                'step' => 0.1,
            ],
        ],
        'selectors' => [
            '{{WRAPPER}} .scroll-img img, {{WRAPPER}} .streamit-image-box-img img' => 'transition-duration: {{SIZE}}s',
            '{{WRAPPER}} .scroll-img img' => 'animation-duration: {{SIZE}}s',
        ],
    ]
);

$this->end_controls_tab();

$this->start_controls_tab(
    'hover',
    [
        'label' => __('Hover', 'streamit-extensions'),
    ]
);

$this->add_group_control(
    Group_Control_Css_Filter::get_type(),
    [
        'name' => 'css_filters_hover',
        'selector' => '{{WRAPPER}}:hover .scroll-img img',
    ]
);

$this->add_control(
    'image_opacity_hover',
    [
        'label' => __('Opacity', 'streamit-extensions'),
        'type' => Controls_Manager::SLIDER,
        'range' => [
            'px' => [
                'max' => 1,
                'min' => 0.10,
                'step' => 0.01,
            ],
        ],
        'selectors' => [
            '{{WRAPPER}}:hover .scroll-img img' => 'opacity: {{SIZE}};',
        ],
    ]
);

$this->end_controls_tab();
$this->end_controls_tabs();

$this->end_controls_section();

$this->start_controls_section(
    'section_style_content',
    [
        'label' => __('Content', 'streamit-extensions'),
        'tab'   => Controls_Manager::TAB_STYLE,
    ]
);

$this->add_responsive_control(
    'text_align',
    [
        'label' => __('Alignment', 'streamit-extensions'),
        'type' => Controls_Manager::CHOOSE,
        'options' => [
            'left' => [
                'title' => __('Left', 'streamit-extensions'),
                'icon' => 'eicon-text-align-left',
            ],
            'center' => [
                'title' => __('Center', 'streamit-extensions'),
                'icon' => 'eicon-text-align-center',
            ],
            'right' => [
                'title' => __('Right', 'streamit-extensions'),
                'icon' => 'eicon-text-align-right',
            ],
            'justify' => [
                'title' => __('Justified', 'streamit-extensions'),
                'icon' => 'eicon-text-align-justify',
            ],
        ],
        'selectors' => [
            '{{WRAPPER}} .streamit-image-box' => 'text-align: {{VALUE}};',
        ],
    ]
);

$this->add_control(
    'heading_title',
    [
        'label' => __('Title', 'streamit-extensions'),
        'type' => Controls_Manager::HEADING,
        'separator' => 'before',
    ]
);

$this->add_responsive_control(
    'title_bottom_space',
    [
        'label' => __('Margin', 'streamit-extensions'),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%'],
        'selectors' => [
            '{{WRAPPER}} .streamit-image-box-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$this->add_control(
    'title_color',
    [
        'label' => __('Color', 'streamit-extensions'),
        'type' => Controls_Manager::COLOR,
        'default' => '',
        'selectors' => [
            '{{WRAPPER}} .streamit-image-box-title, {{WRAPPER}} .streamit-image-box-title a' => 'color: {{VALUE}};',
        ],
    ]
);

$this->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name' => 'title_typography',
        'selector' => '{{WRAPPER}} .streamit-image-box-title',
    ]
);

$this->add_group_control(
    Group_Control_Text_Shadow::get_type(),
    [
        'name' => 'title_shadow',
        'selector' => '{{WRAPPER}} .streamit-image-box-title',
    ]
);

$this->add_control(
    'heading_description',
    [
        'label' => __('Description', 'streamit-extensions'),
        'type' => Controls_Manager::HEADING,
        'separator' => 'before',
    ]
);

$this->add_control(
    'description_color',
    [
        'label' => __('Color', 'streamit-extensions'),
        'type' => Controls_Manager::COLOR,
        'default' => '',
        'selectors' => [
            '{{WRAPPER}} .streamit-image-box-description' => 'color: {{VALUE}};',
        ],
    ]
);

$this->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name' => 'description_typography',
        'selector' => '{{WRAPPER}} .streamit-image-box-description',
    ]
);

$this->add_group_control(
    Group_Control_Text_Shadow::get_type(),
    [
        'name' => 'description_shadow',
        'selector' => '{{WRAPPER}} .streamit-image-box-description',
    ]
);

$this->end_controls_section();
