<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;

$settings       = $this->get_settings_for_display();
$has_content    = !empty($settings['title_text']) || !empty($settings['description_text']);

$image_scroll   = $settings['img_box_style'];
$image_scroll   .= $settings['use_image_scroll'] == 'yes' ? ' hover-image-scroll' : '';
$image_scroll   .= $settings['img_box_style'] == 'style-two' ? ' scroll-img' : '';
$image_scroll   .= $settings['img_box_style'] == 'style-three' ? ' streamit-radius-gradient' : '';

$html = '<div class="streamit-image-box ' . $image_scroll . '">';

if ($settings['image_has_link'] == 'yes') {
    if ($settings['imagebox_link_type'] == 'dynamic') {
        $url = $settings['use_archive_link'] == 'yes' ? $settings['imagebox_archive_dynamic_link'] : get_permalink(get_page_by_path($settings['imagebox_dynamic_link']));

        $this->add_render_attribute('link_attr', 'href', esc_url($url));
        $this->add_render_attribute('link_attr', 'target', '_blank');
        $this->add_render_attribute('link_attr', 'rel', 'nofollow');
    } else {
        if ($settings['image_box_link']['url']) {
            $url = $settings['image_box_link']['url'];
            $this->add_render_attribute('link_attr', 'href', esc_url($url));

            if ($settings['image_box_link']['is_external']) {
                $this->add_render_attribute('link_attr', 'target', '_blank');
            }

            if ($settings['image_box_link']['nofollow']) {
                $this->add_render_attribute('link_attr', 'rel', 'nofollow');
            }
        }
    }
}

if (!empty($settings['image']['url'])) {
    $this->add_render_attribute('image', 'src', $settings['image']['url']);
    $this->add_render_attribute('image', 'alt', Control_Media::get_image_alt($settings['image']));
    $this->add_render_attribute('image', 'title', Control_Media::get_image_title($settings['image']));

    if ($settings['hover_animation']) {
        $this->add_render_attribute('image', 'class', 'elementor-animation-' . $settings['hover_animation']);
    }

    $image_html = Group_Control_Image_Size::get_attachment_image_html($settings, 'thumbnail', 'image');

    if ($settings['image_has_link'] == 'yes') {
        $image_html = '<a ' . $this->get_render_attribute_string('link_attr') . '>' . $image_html . '</a>';
    }

    $html .= '<figure class="streamit-image-box-img">' . $image_html . '</figure>';
}

if ($has_content) {
    $html .= '<div class="elementor-image-box-content">';

    if (!Utils::is_empty($settings['title_text'])) {
        $this->add_render_attribute('title_text', 'class', 'streamit-image-box-title');
        $this->add_inline_editing_attributes('title_text', 'none');
        $title_html = $settings['title_text'];
        if ($settings['image_has_link'] == 'yes') {
            $title_html = '<a ' . $this->get_render_attribute_string('link_attr') . '>' . $title_html . '</a>';
        }

        $html .= sprintf('<%1$s %2$s>%3$s</%1$s>', Utils::validate_html_tag($settings['title_size']), $this->get_render_attribute_string('title_text'), $title_html);
    }

    if (!Utils::is_empty($settings['description_text'])) {
        $this->add_render_attribute('description_text', 'class', 'streamit-image-box-description');

        $this->add_inline_editing_attributes('description_text');

        $html .= sprintf('<p %1$s>%2$s</p>', $this->get_render_attribute_string('description_text'), $settings['description_text']);
    }

    $html .= '</div>';
}

$html .= '</div>';

echo $html;
