<?php

namespace Iqonic\Elementor\Elements\ImageBox;

use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;

if (!defined('ABSPATH')) exit;

class Widget extends Widget_Base
{
    public function get_name()
    {
        return 'iqonic_imageBox';
    }

    public function get_title()
    {
        return __('Image Box', 'streamit-extensions');
    }

    public function get_categories()
    {
        return ['streamit-extension'];
    }

    public function get_icon()
    {
        return 'eicon-image-box';
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'section_image',
            [
                'label' => __('Image Box', 'streamit-extensions'),
            ]
        );

        $this->add_control(
            'img_box_style',
            [
                'label' => __('Image Box Style', 'streamit-extensions'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'style-one' => esc_html__('One', 'streamit-extensions'),
                    'style-two' => esc_html__('Two', 'streamit-extensions'),
                    'style-three' => esc_html__('Three', 'streamit-extensions'),
                ],
                'default' => __('style-two', 'streamit-extensions'),
            ]
        );

        $this->add_control(
            'image',
            [
                'label' => __('Choose  Image', 'streamit-extensions'),
                'type' => Controls_Manager::MEDIA,
                'dynamic' => [
                    'active' => true,
                ],
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'thumbnail',
                'default' => 'full',
                'separator' => 'none',
            ]
        );

        $this->add_control(
            'object_fit',
            [
                'label' => __('Object Fit', 'streamit-extensions'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'cover' => 'Cover',
                    'contain' => 'Contain',
                ],
                'selectors' => [
                    '{{WRAPPER}} .streamit-image-box img' => 'object-fit: {{VALUE}} !important;',
                ],
                'default' => 'cover',
            ]
        );

        $this->add_control(
            'object_pos',
            [
                'label' => __('Object Position', 'streamit-extensions'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'left' => 'Left',
                    'right' => 'Right',
                ],
                'selectors' => [
                    '{{WRAPPER}} .streamit-image-box img' => 'object-position: {{VALUE}} !important;',
                ],
                'default' => 'cover',
                'condition' => ['object_fit' => 'contain']
            ]
        );

        $this->add_control(
            'object_pos_2',
            [
                'label' => __('Object Position', 'streamit-extensions'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'top' => 'Top',
                    'center' => 'Center',
                    'bottom' => 'Bottom',
                ],
                'selectors' => [
                    '{{WRAPPER}} .streamit-image-box img' => 'object-position: {{VALUE}} !important;',
                ],
                'default' => __('cover', 'streamit-extensions'),
                'condition' => ['object_fit' => 'cover']
            ]
        );

        $this->add_control(
            'title_text',
            [
                'label' => __('Title & Description', 'streamit-extensions'),
                'type' => Controls_Manager::TEXT,
                'dynamic' => [
                    'active' => true,
                ],
                'default' => __('This is the heading', 'streamit-extensions'),
                'placeholder' => __('Enter your title', 'streamit-extensions'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'description_text',
            [
                'label' => __('Content', 'streamit-extensions'),
                'type' => Controls_Manager::TEXTAREA,
                'dynamic' => [
                    'active' => true,
                ],
                'default' => __('Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.', 'streamit-extensions'),
                'placeholder' => __('Enter your description', 'streamit-extensions'),
                'separator' => 'none',
                'rows' => 10,
                'show_label' => false,
            ]
        );

        $this->add_control(
            'image_has_link',
            [
                'label' => __('Use Link', 'streamit-extensions'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'yes' => __('yes', 'streamit-extensions'),
                'no' => __('no', 'streamit-extensions'),
            ]
        );

        $this->add_control(
            'imagebox_link_type',
            [
                'label' => __('Link Type', 'streamit-extensions'),
                'type' => Controls_Manager::SELECT,
                'default' => 'dynamic',
                'options' => [
                    'dynamic' => __('Dynamic', 'streamit-extensions'),
                    'custom' => __('Custom', 'streamit-extensions'),
                ],
                'condition' => ['image_has_link' => 'yes']
            ]
        );

        $this->add_control(
            'use_archive_link',
            [
                'label' => __('Use Archive Page link?', 'streamit-extensions'),
                'type' => Controls_Manager::SELECT,
                'default' => 'no',
                'options' => [
                    'yes' => __('Yes', 'streamit-extensions'),
                    'no' => __('No', 'streamit-extensions'),
                ],
                'condition' => [
                    'image_has_link' => 'yes',
                    'imagebox_link_type' => 'dynamic',
                ],
            ]
        );

        $this->add_control(
            'imagebox_dynamic_link',
            [
                'label' => esc_html__('Select Page', 'streamit-extensions'),
                'type' => Controls_Manager::SELECT,
                'return_value' => 'true',
                'multiple' => true,
                'condition' => [
                    'image_has_link' => 'yes',
                    'imagebox_link_type' => 'dynamic',
                    'use_archive_link' => 'no'
                ],
                'options' => isset($_REQUEST['editor_post_id']) ? iq_custom_post_data("page",true) : [],
            ]
        );

        $this->add_control(
            'imagebox_archive_dynamic_link',
            [
                'label' => esc_html__('Select Archive', 'streamit-extensions'),
                'type' => Controls_Manager::SELECT,
                'return_value' => 'true',
                'multiple' => true,
                'condition' => [
                    'image_has_link' => 'yes',
                    'imagebox_link_type' => 'dynamic',
                    'use_archive_link' => 'yes'
                ],
                'options' => isset($_REQUEST['editor_post_id']) ? iq_custom_post_data_archive_link() : [],
            ]
        );

        $this->add_control(
            'image_box_link',
            [
                'label' => __('Link', 'streamit-extensions'),
                'type' => Controls_Manager::URL,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => __('https://your-link.com', 'streamit-extensions'),
                'default' => [
                    'url' => '#',
                ],
                'condition' => ['image_has_link' => 'yes', 'imagebox_link_type' => 'custom']
            ]
        );

        $this->add_control(
            'position',
            [
                'label' => __('Image Position', 'streamit-extensions'),
                'type' => Controls_Manager::CHOOSE,
                'default' => 'top',
                'options' => [
                    'left' => [
                        'title' => __('Left', 'streamit-extensions'),
                        'icon' => 'eicon-h-align-left',
                    ],
                    'top' => [
                        'title' => __('Top', 'streamit-extensions'),
                        'icon' => 'eicon-v-align-top',
                    ],
                    'right' => [
                        'title' => __('Right', 'streamit-extensions'),
                        'icon' => 'eicon-h-align-right',
                    ],
                ],
                'prefix_class' => 'elementor-position-',
                'toggle' => false,
            ]
        );

        $this->add_control(
            'title_size',
            [
                'label' => __('Title HTML Tag', 'streamit-extensions'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'h1' => 'H1',
                    'h2' => 'H2',
                    'h3' => 'H3',
                    'h4' => 'H4',
                    'h5' => 'H5',
                    'h6' => 'H6',
                    'div' => 'div',
                    'span' => 'span',
                    'p' => 'p',
                ],
                'default' => 'h3',
            ]
        );

        $this->add_control(
            'use_image_scroll',
            [
                'label' => __('Use Image Scroll', 'streamit-extensions'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'yes' => __('yes', 'streamit-extensions'),
                'no' => __('no', 'streamit-extensions'),
            ]
        );

        $this->add_control(
            'view',
            [
                'label' => __('View', 'streamit-extensions'),
                'type' => Controls_Manager::HIDDEN,
                'default' => 'traditional',
            ]
        );

        $this->end_controls_section();

        require 'style.php';
    }

    protected function render()
    {
        require 'render.php';
    }
}
