<?php

$thumbnail_id   = get_term_meta($term->term_id, 'thumbnail_id', true);
$image_alt      = esc_attr__('image', SE_TEXT_DOMAIN);

$slider_image = wp_get_attachment_url($thumbnail_id);
if (!$slider_image)
    $slider_image = get_lazy_load_image();

if (isset($lazy_load) && !empty($lazy_load)) {
    $img_class      = ' iqonic-lazy';
    $lazy_image     = get_lazy_load_image();

    $original_image = $slider_image;
    $slider_image   = $lazy_image;

    $srcset = ($original_image) ? "data-srcset=" . $original_image . "" : "";
} else {
    $img_class = '';
    $srcset = '';
}

// genre link
if ($settings["is_default_genre_link"] != "yes") {
    $link = '?type=' . $post_type . '&title=' . $term->name . '&genres=' . $term->slug;
    $genre_url = esc_url(get_page_link($streamit_options['streamit_viewall_link'])) . $link;
} else {
    $genre_url = get_term_link($term, $term->taxonomy);
    $genre_url = !is_wp_error($genre_url) ? $genre_url : "#";
} ?>

<li class="slide-item <?php echo esc_attr($col); ?>">
    <div class="block-images position-relative <?php echo esc_attr($border); ?>">
        <div class="img-box">
            <a href="<?php echo get_the_permalink(); ?>"></a>
            <img src="<?php echo esc_url($slider_image) ?>" class="img-fluid <?php echo esc_attr($img_class); ?>" alt="<?php echo $image_alt; ?>" <?php echo esc_attr($srcset); ?>>
        </div>

        <div class="block-description">
            <h6 class="iq-title">
                <?php $view_all = '<a href="' . $genre_url . '">' . esc_html($term->name) . '</a>';
                echo wp_kses_post($view_all); ?>
            </h6>
        </div>
    </div>
</li>