<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;

global $streamit_options;

$term_count = 0;
$rand = rand(10, 100);
$args = $taxargs = array();
$can_be_loaded = false;
$slider_title = $view_cat = $post_type = $html = $col = '';

$settings           = $this->get_settings();
$loadmore_btn       = 'genre-load-btn-' . $rand;
$border             = $settings['border_position'] == "bottom" ? "border-btm" : '';

$options_streamit_load = $settings['pagination'];
$terms_per_page        = $settings['posts_per_page']['size'];
$current_page          = (get_query_var('paged')) ? get_query_var('paged') : 1;
$offset                = ($terms_per_page * $current_page) - $terms_per_page;

$watchlist_class    = $settings['slider_type'] == 'slider' ? 'iq-rtl-direction' : 'watchlist-contens';
$genre_class        = $terms_per_page > 0 ? ' streamit_datapass_genres' : '';
$main_classes       = $watchlist_class . $genre_class;

$lazy_load          = $settings['enable_lazy_load_images'] == "yes" ? " iqonic-lazy-load-images" : "";
if (!empty($lazy_load)) {
    $main_classes .= $lazy_load;
}

$args = array(
    'post_type'     => array('tv_show', 'movie', 'video'),
    'post_status'   => 'publish',
    'order'         => $settings['order'],
);

$is_grid = $settings['slider_type'] == 'grid';

if ($settings['slider_type'] == 'slider') {
    $args['posts_per_page'] = -1;
    $args['paged']          = $current_page;
    $align                  = 'favorites-slider ';
    $align                  .= isset($settings['nav-arrow-style']) && $settings['nav-arrow-style'] == 'style-2' ? 'iq-arrow-2' : '';

    $this->add_render_attribute('slider', 'data-nav',               $settings['nav-arrow']);
    $this->add_render_attribute('slider', 'data-items',             $settings['desk_number']);
    $this->add_render_attribute('slider', 'data-items-laptop',      $settings['lap_number']);
    $this->add_render_attribute('slider', 'data-items-tab',         $settings['tab_number']);
    $this->add_render_attribute('slider', 'data-items-mobile',      $settings['mob_number']);
    $this->add_render_attribute('slider', 'data-items-mobile-sm',   $settings['mob_number']);
    $this->add_render_attribute('slider', 'data-autoplay',          $settings['autoplay']);
    $this->add_render_attribute('slider', 'data-autoplay-speed',    $settings['autoplay_speed']);
    $this->add_render_attribute('slider', 'data-infinite',          $settings['infinite']);
    $this->add_render_attribute('slider', 'data-speed',             $settings['speed']);
} else {
    $align = 'favorites-grid';

    $grid_class = [
        "1" => 'col-12 wl-child',
        "2" => 'col-lg-6 col-md-6 col-sm-6 wl-child',
        "3" => 'col-lg-4 col-md-4 col-sm-6 wl-child',
        "4" => 'col-xl-3 col-lg-4 col-md-4 col-sm-6 col-6 wl-child'
    ];

    $col = $grid_class[$settings['movie_grid_style']];

    if ($terms_per_page == -1) {
        $args['paged']          = $current_page;
        $args['posts_per_page'] = -1;
    } else {
        $args['number']         = $terms_per_page;
        $args['offset']         = $offset;
    }
}

if (isset($settings['slider_title'])) {
    $slider_title       = $settings['slider_title'];
    $slider_title_key   = str_replace(" ", "_", $slider_title);
    $view_title         = '&title=' . $slider_title_key;
}

if ($settings['iq_type'] == 'video') {
    $args['post_type']  = 'video';
    $taxonomy           = 'video_cat';
    $terms              = get_terms('video_cat', $args);
    $post_type          = 'videos';
    $genre              = $settings['iq_video'];
} else if ($settings['iq_type'] == 'tv_show') {
    $args['post_type']  = 'tv_show';
    $taxonomy           = 'tv_show_genre';
    $terms              = get_terms('tv_show_genre', $args);
    $post_type          = 'tv_shows';
    $genre              = $settings['iq_tv_show'];
} else {
    $args['post_type']  = 'movie';
    $taxonomy           = 'movie_genre';
    $terms              = get_terms('movie_genre', $args);
    $post_type          = 'movies';
    $genre              = $settings['iq_movie'];
}

if ($settings['iq_type_filter'] == 'selected' && !empty($genre)) {
    $tax_query['taxonomy']  = $taxonomy;
    $tax_query['field']     = 'slug';
    $tax_query['terms']     = $genre;
    $tax_query['operator']  = 'IN';
    array_push($taxargs, $tax_query);
} else {
    $terms = get_terms($taxonomy, $args);
    $term_count = get_terms(array(
        'taxonomy'  => $taxonomy,
        'fields'    => 'count',
    ));

    $can_be_loaded     = ($term_count > $terms_per_page) ? true : false;
}

$temp_settings = [
    'col'                   => $col,
    'border'                => $border,
    'taxonomy'              => $taxonomy,
    'post_type'             => $post_type,
    'is_default_genre_link' => $settings['is_default_genre_link'],
    'terms_per_page'        => $terms_per_page,
    'lazy_load'             => $lazy_load,
]; ?>

<div class="iq_genres-contents iq-ajax-content favorites-contens <?php echo esc_attr($main_classes); ?>" data-options="<?php echo esc_attr($options_streamit_load); ?>" data-can-beloaded="<?php echo esc_attr($can_be_loaded); ?>">
    <div class="iq-main-header d-flex align-items-center justify-content-between">
        <?php if (!empty($slider_title)) { ?>
            <<?php echo esc_html($settings['title_tag']); ?> class="main-title">
                <?php echo esc_html($slider_title); ?>
            </<?php echo esc_html($settings['title_tag']); ?>>
        <?php } ?>
    </div>

    <ul class="list-grid list-inline row p-0 mb-0 <?php echo esc_attr($align); ?>" <?php echo $this->get_render_attribute_string('slider'); ?>>
        <?php if ($settings['iq_type_filter'] == 'selected' && !empty($genre)) {
            $term_count++;
            foreach ($genre as $val) {
                $term = get_term_by('slug', $val, $taxonomy);
                if ($term) {
                    require trailingslashit(plugin_dir_path(__FILE__)) . 'template.php';
                }
            }
        } else {
            if ($terms) {
                foreach ($terms as $term) {
                    require trailingslashit(plugin_dir_path(__FILE__)) . 'template.php';
                }
            }
        }
        wp_reset_postdata(); ?>
    </ul>

    <?php
    $total_pages = ceil($term_count / $terms_per_page);

    if ($is_grid && $can_be_loaded && $settings['pagination'] == 'yes') {
        streamit_get_numbers_pagination($total_pages);
    } elseif ($is_grid && $can_be_loaded && $settings['pagination'] == 'infinite' && $total_pages > 1) {
        echo '<div class="loader-wheel-container"></div>';
    } ?>
</div>

<?php
if ($can_be_loaded) { ?>
    <div class="loader-wheel-container">
        <?php if ($is_grid && $settings['pagination'] == 'loadmore' && $total_pages > 1) : ?>
            <div class="<?php echo esc_attr($loadmore_btn); ?>">
                <div class="btn btn-hover iq-button">
                    <span><?php echo !empty($settings['more_text']) ? esc_html($settings['more_text']) : '' ?></span>
                </div>
            </div>
        <?php endif;

        if ($is_grid && $settings['pagination'] == "yes") {
            $current_page  = max(1, get_query_var('paged')) - 1;
        }

        $pagination_args = [
            'action'            => 'loadmore_genres',
            'current_page'      => $current_page,
            'total_pages'       => $total_pages,
            'loadmore_btn'      => $loadmore_btn,
            'loading_text'      => $settings['loading_text'],
            'query_args'        => $args,
            'temp_settings'     => $temp_settings,
            'posts_per_page'    => $terms_per_page,
        ];

        streamit_get_pagination_args($pagination_args); ?>
    </div>
<?php }
