<?php

namespace Iqonic\Elementor\Elements\Genres;

use Elementor\Plugin;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit;

class Widget extends Widget_Base
{
    public function get_name()
    {
        return 'Iq_Genres';
    }

    public function get_title()
    {
        return esc_html__('Genres', 'streamit-extensions');
    }

    public function get_categories()
    {
        return ['streamit-extension'];
    }

    public function get_icon()
    {
        return 'eicon-gallery-grid';
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'section_Genres',
            [
                'label' => __('Genres', 'streamit-extensions'),
            ]
        );

        $this->add_control(
            'slider_title',
            [
                'label' => __('Title', 'streamit-extensions'),
                'type' => Controls_Manager::TEXT,
                'default' => __('Title', 'streamit-extensions'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'title_tag',
            [
                'label'      => __('Title Tag', 'streamit-extensions'),
                'type'       => Controls_Manager::SELECT,
                'options'    => [
                    'h1'          => __('h1', 'streamit-extensions'),
                    'h2'          => __('h2', 'streamit-extensions'),
                    'h3'          => __('h3', 'streamit-extensions'),
                    'h4'          => __('h4', 'streamit-extensions'),
                    'h5'          => __('h5', 'streamit-extensions'),
                    'h6'          => __('h6', 'streamit-extensions'),
                ],
                'default'    => 'h4',
            ]
        );

        $this->add_control(
            'border_position',
            [
                'label' => __('Border Position', 'streamit-extensions'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'left' => esc_html__('Left', 'streamit-extensions'),
                    'bottom' => esc_html__('Bottom', 'streamit-extensions')
                ],
                'default' => 'left',
            ]
        );

        $this->add_control(
            'slider_type',
            [
                'label' => __('Style', 'streamit-extensions'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'slider' => __('Slider', 'streamit-extensions'),
                    'grid' => __('Grid', 'streamit-extensions')
                ],
                'default' => 'slider'
            ]
        );

        $this->add_control(
            'iq_type',
            [
                'label' => __('Select Specific Post', 'streamit-extensions'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'movie' => __('Movie', 'streamit-extensions'),
                    'tv_show' => __('Tv Show', 'streamit-extensions'),
                    'video' => __('Video', 'streamit-extensions')
                ],
                'default' => 'movie'
            ]
        );

        $this->add_control(
            'iq_type_filter',
            [
                'label' => __('Select List', 'streamit-extensions'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'all' => __('All', 'streamit-extensions'),
                    'selected' => __('Selected', 'streamit-extensions'),
                ],
                'default' => 'all'
            ]
        );

        $this->add_control(
            'iq_tv_show',
            [
                'label' => __('Display Specific Tv-Show', 'streamit-extensions'),
                'type' => Controls_Manager::SELECT2,
                'label_block' => true,
                'multiple' => true,
                'options' => isset($_REQUEST['editor_post_id']) ? iq_get_custom_taxonomy('tv_show_genre') : [],
                'condition' => ['iq_type' => ['tv_show'], 'iq_type_filter' => 'selected'],
            ]
        );

        $this->add_control(
            'iq_movie',
            [
                'label' => __('Display Specific Movie', 'streamit-extensions'),
                'type' => Controls_Manager::SELECT2,
                'label_block' => true,
                'multiple' => true,
                'options' => isset($_REQUEST['editor_post_id']) ? iq_get_custom_taxonomy('movie_genre') : [],
                'condition' => ['iq_type' => ['movie'], 'iq_type_filter' => 'selected'],
            ]
        );

        $this->add_control(
            'iq_video',
            [
                'label' => __('Display Specific Video', 'streamit-extensions'),
                'type' => Controls_Manager::SELECT2,
                'label_block' => true,
                'multiple' => true,
                'options' => isset($_REQUEST['editor_post_id']) ? iq_get_custom_taxonomy('video_cat') : [],
                'condition' => ['iq_type' => ['video'], 'iq_type_filter' => 'selected'],
            ]
        );

        $this->add_control(
            'enable_lazy_load_images',
            [
                'label'         => __('Lazy Load Images', 'streamit-extensions'),
                'type'          => Controls_Manager::SWITCHER,
                'yes'           => __('Yes', 'streamit-extensions'),
                'no'            => __('No', 'streamit-extensions'),
                'return_value'  => 'yes',
                'default'       => 'no',
            ]
        );

        $this->add_control(
            'is_default_genre_link',
            [
                'label'     => __('Use default genre link?', 'streamit-extensions'),
                'type'      => Controls_Manager::SWITCHER,
                'default'   => 'no',
                'yes'       => __('yes', 'streamit-extensions'),
                'no'        => __('no', 'streamit-extensions'),
            ]
        );

        $this->add_control(
            'movie_grid_style',
            [
                'label' => __('Grid', 'streamit-extensions'),
                'type' => Controls_Manager::SELECT,
                'default' => '4',
                'options' => [
                    '1' => __('One', 'streamit-extensions'),
                    '2' => __('Two', 'streamit-extensions'),
                    '3' => __('Three', 'streamit-extensions'),
                    '4' => __('Four', 'streamit-extensions'),
                ],
                'condition' => ['slider_type' => 'grid']
            ]
        );

        $this->add_control(
            'order',
            [
                'label' => __('Order By', 'streamit-extensions'),
                'type' => Controls_Manager::SELECT,
                'default' => 'ASC',
                'options' => [
                    'DESC' => esc_html__('Descending', 'streamit-extensions'),
                    'ASC' => esc_html__('Ascending', 'streamit-extensions')
                ],
            ]
        );

        $this->add_control(
            'pagination',
            [
                'label' => __('Show Pagintion/Loadmore/Infinite', 'streamit-extensions'),
                'type' => Controls_Manager::SELECT,
                'default' => 'loadmore',
                'label_block' => true,
                'options' => [
                    'yes' => esc_html__('Pagination', 'streamit-extensions'),
                    'loadmore' => esc_html__('Loadmore', 'streamit-extensions'),
                    'infinite' => esc_html__('Infinite Scroll', 'streamit-extensions')
                ],
                'condition' => ['slider_type' => 'grid', 'iq_type_filter' => 'all']
            ]
        );

        $this->add_control(
            'more_text',
            [
                'label' => __('Load More button text', 'streamit-extensions'),
                'type' => Controls_Manager::TEXT,
                'default' => __('Load More', 'streamit-extensions'),
                'label_block' => true,
                'condition' => ['slider_type' => 'grid', 'pagination' => 'loadmore', 'iq_type_filter' => 'all']
            ]
        );

        $this->add_control(
            'loading_text',
            [
                'label' => __('Loading button text', 'streamit-extensions'),
                'type' => Controls_Manager::TEXT,
                'default' => __('Loading...', 'streamit-extensions'),
                'label_block' => true,
                'condition' => ['slider_type' => 'grid', 'pagination' => 'loadmore', 'iq_type_filter' => 'all']
            ]
        );

        $this->add_responsive_control(
            'posts_per_page',
            [
                'label' => __('Posts Per Page', 'streamit-extensions'),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'unit' => '%',
                    'size' => 10,
                ],
                'condition' => ['slider_type' => 'grid', 'iq_type_filter' => 'all']
            ]
        );

        $this->end_controls_section();
        $this->start_controls_section(
            'slick_control_section',
            [
                'label' => __('Slider Control', 'streamit-extensions'),
                'condition' => ['slider_type' => ['slider']],
            ]
        );

        require STREAMIT_EXTENSION_PLUGIN_PATH . '/includes/Elementor/Controls/slick-control.php';

        $this->end_controls_section();

        $this->start_controls_section(
            'section_banner_style',
            [
                'label' => __('Main', 'streamit-extensions'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'button_border_radius',
            [
                'label' => __('Border Radius', 'streamit-extensions'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} li.slide-item .block-images' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ],
            ]
        );

        $this->add_responsive_control(
            'button_padding',
            [
                'label' => __('Padding', 'streamit-extensions'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .favorites-slider li.slide-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        require 'render.php';

        if (Plugin::$instance->editor->is_edit_mode()) { ?>
            <script>
                (function(jQuery) {
                    callSlickSlider(jQuery('.favorites-slider'));
                    genresAjaxHandler();
                })(jQuery)
            </script>
<?php
        }
    }
}
