<?php

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;

//Menu Color
$this->start_controls_section(
    'section_footrmenu_style',
    [
        'label' => __('Menu', 'streamit-extensions'),
        'tab' => Controls_Manager::TAB_STYLE,
    ]
);

$this->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name' => 'footer_menu_typography',
        'label' => __('Typography', 'streamit-extensions'),
        'selector' => '{{WRAPPER}} .footer-menu  li  a',
    ]
);

$this->start_controls_tabs('menu_tabs');
$this->start_controls_tab(
    'tabs_menujeBef122kCfHOb40638',
    [
        'label' => __('Normal', 'streamit-extensions'),
    ]
);

$this->add_control(
    'text_color',
    [
        'label' => __('Choose color', 'streamit-extensions'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .footer-menu  li  a'  => 'color: {{VALUE}};'
        ],
    ]
);

$this->add_control(
    'icon_color',
    [
        'label' => __('Icon color', 'streamit-extensions'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .iqonic-footer-menu-icon .footer-menu > li::before,{{WRAPPER}} .iqonic-footer-menu-icon .footer-menu > li>i '  => 'color: {{VALUE}};'
        ],
        'condition' => ['has_icon' => 'yes']
    ]
);

$this->end_controls_tab();

$this->start_controls_tab(
    'tabs_menuaJ0C3kdUtggtL5G4tW12awyR',
    [
        'label' => __('Hover', 'streamit-extensions'),
    ]
);

$this->add_control(
    'text_hover_color',
    [
        'label' => __('Choose color', 'streamit-extensions'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .footer-menu  li:hover  a' => 'color: {{VALUE}};'
        ],
    ]
);

$this->add_control(
    'icon_hover_color',
    [
        'label' => __('Icon color', 'streamit-extensions'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .iqonic-footer-menu-icon .footer-menu > li:hover::before'  => 'color: {{VALUE}};'
        ],
        'condition' => ['has_icon' => 'yes']
    ]
);

$this->end_controls_tab();
$this->end_controls_tabs();

$this->add_responsive_control(
    'menu_parent_padding',
    [
        'label' => __('Padding', 'streamit-extensions'),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%'],
        'selectors' => [
            '{{WRAPPER}}  .footer-menu  li  a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$this->add_responsive_control(
    'menu_parent_margin',
    [
        'label' => __('Margin', 'streamit-extensions'),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%'],
        'selectors' => [
            '{{WRAPPER}}  .footer-menu  li ' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$this->add_responsive_control(
    'menu_before_margin',
    [
        'label' => __('Before Margin', 'streamit-extensions'),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%'],
        'selectors' => [
            '{{WRAPPER}}  .ft-nav-style-three .footer-menu>li::before ' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'condition' => ['ft_nav_style' => 'ft-nav-style-three']
    ]
);

$this->end_controls_section();
